/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor;

import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.springframework.boot.configurationprocessor.MetadataGenerationEnvironment;
import org.springframework.boot.configurationprocessor.PropertyDescriptor;

class JavaBeanPropertyDescriptor
extends PropertyDescriptor {
    private final ExecutableElement setter;
    private final VariableElement field;
    private final ExecutableElement factoryMethod;

    JavaBeanPropertyDescriptor(String name, TypeMirror type, TypeElement declaringElement, ExecutableElement getter, ExecutableElement setter, VariableElement field, ExecutableElement factoryMethod) {
        super(name, type, declaringElement, getter);
        this.setter = setter;
        this.field = field;
        this.factoryMethod = factoryMethod;
    }

    ExecutableElement getSetter() {
        return this.setter;
    }

    @Override
    protected boolean isMarkedAsNested(MetadataGenerationEnvironment environment) {
        return environment.getNestedConfigurationPropertyAnnotation(this.field) != null || environment.getNestedConfigurationPropertyAnnotation(this.getGetter()) != null;
    }

    @Override
    protected String resolveDescription(MetadataGenerationEnvironment environment) {
        return environment.getTypeUtils().getJavaDoc(this.field);
    }

    @Override
    protected Object resolveDefaultValue(MetadataGenerationEnvironment environment) {
        return environment.getFieldDefaultValue(this.getDeclaringElement(), this.field);
    }

    @Override
    protected List<Element> getDeprecatableElements() {
        return Arrays.asList(this.getGetter(), this.setter, this.field, this.factoryMethod);
    }

    @Override
    public boolean isProperty(MetadataGenerationEnvironment env) {
        boolean isCollection = env.getTypeUtils().isCollectionOrMap(this.getType());
        boolean hasGetter = this.getGetter() != null;
        boolean hasSetter = this.getSetter() != null;
        return !env.isExcluded(this.getType()) && hasGetter && (hasSetter || isCollection);
    }
}

