/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.scheduler;

import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.util.lang.Generics;
import org.wicketstuff.kendo.ui.scheduler.ISchedulerVisitor;

public class SchedulerEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_RANGE = 1;
    private Object id;
    private String title;
    private ZonedDateTime start;
    private ZonedDateTime until;
    private boolean allDay = false;
    private String description = null;
    private String recurrenceId = null;
    private String recurrenceRule = null;
    private String recurrenceException = null;
    private boolean visible = true;
    private final Map<String, Object> fields = Generics.newHashMap();

    SchedulerEvent() {
        this((Object)null, "", ZonedDateTime.now(ZoneOffset.UTC));
    }

    public SchedulerEvent(Object id, String title, ZonedDateTime start) {
        this(id, title, start, start.plusHours(1L));
    }

    public SchedulerEvent(Object id, String title, ZonedDateTime start, ZonedDateTime until) {
        this.id = id;
        this.title = title;
        this.start = start;
        this.until = until;
    }

    public SchedulerEvent(Number id, String title, ZonedDateTime start) {
        this(id, title, start, start.plusHours(1L));
    }

    public SchedulerEvent(Number id, String title, ZonedDateTime start, ZonedDateTime until) {
        this.id = id;
        this.title = title;
        this.start = start;
        this.until = until;
    }

    public Object getId() {
        return this.id;
    }

    public <T> T getId(Class<T> type) {
        return (T)this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ZonedDateTime getStart() {
        return this.start;
    }

    public void setStart(ZonedDateTime date) {
        this.start = date;
    }

    public ZonedDateTime getUntil() {
        return this.until;
    }

    public void setUntil(ZonedDateTime date) {
        this.until = date;
    }

    public boolean isAllDay() {
        return this.allDay;
    }

    public void setAllDay(boolean allDay) {
        this.allDay = allDay;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getRecurrenceId() {
        return this.recurrenceId;
    }

    public void setRecurrenceId(String id) {
        this.recurrenceId = id;
    }

    public String getRecurrenceRule() {
        return this.recurrenceRule;
    }

    public void setRecurrenceRule(String rule) {
        this.recurrenceRule = rule;
    }

    public String getRecurrenceException() {
        return this.recurrenceException;
    }

    public void setRecurrenceException(String exception) {
        this.recurrenceException = exception;
    }

    public Set<String> getFields() {
        return this.fields.keySet();
    }

    public final Object getValue(String field) {
        return this.fields.get(field);
    }

    public final Object getValue(String field, Object defaultValue) {
        Object value = this.fields.get(field);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public final void setValue(String field, Object value) {
        this.fields.put(field, value);
    }

    public final void accept(ISchedulerVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.title;
    }

    public static boolean isNew(SchedulerEvent event) {
        String id = String.valueOf(event.id);
        return id.equals("null") || id.equals("0");
    }
}

