/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public final class SpringResourceHelper {
    public static final String RESOURCE_PREFIX = "resource:";
    public static final String CLASSPATH_PREFIX = "classpath:";
    public static final String FILE_PREFIX = "file:";

    public static InputStream getResourceInputStream(Resource resource, Proxy proxy, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier, int connectTimeout, int readTimeout) throws IOException {
        if (resource instanceof UrlResource) {
            URLConnection con = proxy != null ? resource.getURL().openConnection(proxy) : resource.getURL().openConnection();
            if (con instanceof HttpsURLConnection) {
                HttpsURLConnection connection = (HttpsURLConnection)con;
                if (sslSocketFactory != null) {
                    connection.setSSLSocketFactory(sslSocketFactory);
                }
                if (hostnameVerifier != null) {
                    connection.setHostnameVerifier(hostnameVerifier);
                }
            }
            try {
                con.setConnectTimeout(connectTimeout);
                con.setReadTimeout(readTimeout);
                return con.getInputStream();
            }
            catch (Exception e) {
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
                throw new TechnicalException("Error getting URL resource", e);
            }
        }
        return resource.getInputStream();
    }

    public static Resource buildResourceFromPath(String path) {
        CommonHelper.assertNotBlank("path", path);
        try {
            if (path.startsWith(RESOURCE_PREFIX)) {
                return new ClassPathResource(path.substring(RESOURCE_PREFIX.length()));
            }
            if (path.startsWith(CLASSPATH_PREFIX)) {
                return new ClassPathResource(path.substring(CLASSPATH_PREFIX.length()));
            }
            if (path.startsWith("http") || path.startsWith("https")) {
                return new UrlResource(new URL(path));
            }
            if (path.startsWith(FILE_PREFIX)) {
                return new FileSystemResource(path.substring(FILE_PREFIX.length()));
            }
            return new FileSystemResource(path);
        }
        catch (Exception e) {
            throw new TechnicalException(e);
        }
    }

    public static UrlResource newUrlResource(String url) {
        try {
            return new UrlResource(url);
        }
        catch (MalformedURLException e) {
            throw new TechnicalException(e);
        }
    }
}

