/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.calendar;

import java.time.Duration;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Date;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.calendar.BusinessCalendarImpl;
import org.flowable.common.engine.impl.runtime.ClockReader;
import org.flowable.common.engine.impl.util.DateUtil;

public class DueDateBusinessCalendar
extends BusinessCalendarImpl {
    public static final String NAME = "dueDate";

    public DueDateBusinessCalendar(ClockReader clockReader) {
        super(clockReader);
    }

    @Override
    public Date resolveDuedate(String duedate, int maxIterations) {
        try {
            if (duedate.startsWith("P")) {
                Duration duration;
                Period period;
                ZonedDateTime calculateTime = this.clockReader.getCurrentTime().toInstant().atZone(this.clockReader.getCurrentTimeZone().toZoneId());
                if (duedate.startsWith("PT")) {
                    period = Period.ZERO;
                    duration = Duration.parse(duedate);
                } else {
                    int timeIndex = duedate.indexOf(84);
                    if (timeIndex > 0) {
                        period = Period.parse(duedate.substring(0, timeIndex));
                        duration = Duration.parse("P" + duedate.substring(timeIndex));
                    } else {
                        period = Period.parse(duedate);
                        duration = Duration.ZERO;
                    }
                }
                return Date.from(calculateTime.plus(period).plus(duration).toInstant());
            }
            return DateUtil.parseDate(duedate);
        }
        catch (Exception e) {
            throw new FlowableException("couldn't resolve duedate: " + e.getMessage(), (Throwable)e);
        }
    }
}

