/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.javax.el;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.flowable.common.engine.impl.javax.el.ELException;
import org.flowable.common.engine.impl.javax.el.ExpressionFactory;
import org.flowable.common.engine.impl.javax.el.JreCompat;
import org.flowable.common.engine.impl.javax.el.MethodNotFoundException;

class Util {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    Util() {
    }

    static Method findMethod(Class<?> clazz, Object base, String methodName, Class<?>[] paramTypes, Object[] paramValues, ExpressionFactory factory) {
        if (clazz == null || methodName == null) {
            throw new MethodNotFoundException("Method not found: " + String.valueOf(clazz) + "." + methodName + "(" + Util.paramString(paramTypes) + ")");
        }
        if (paramTypes == null) {
            paramTypes = Util.getTypesFromValues(paramValues);
        }
        Method[] methods = clazz.getMethods();
        List wrappers = Wrapper.wrap(methods, methodName);
        Wrapper result = Util.findWrapper(clazz, wrappers, methodName, paramTypes, paramValues, factory);
        return Util.getMethod(clazz, base, (Method)result.unWrap());
    }

    private static <T> Wrapper<T> findWrapper(Class<?> clazz, List<Wrapper<T>> wrappers, String name, Class<?>[] paramTypes, Object[] paramValues, ExpressionFactory factory) {
        ArrayList<Wrapper<T>> candidates = new ArrayList<Wrapper<T>>();
        CandidatesType candidatesType = CandidatesType.UNKNOWN;
        int paramCount = paramTypes.length;
        for (Wrapper<T> w : wrappers) {
            Class<?>[] mParamTypes = w.getParameterTypes();
            int mParamCount = mParamTypes == null ? 0 : mParamTypes.length;
            if (!w.isVarArgs() && paramCount != mParamCount || w.isVarArgs() && paramCount < mParamCount - 1 || w.isVarArgs() && paramCount == mParamCount && paramValues != null && paramValues.length > paramCount && !paramTypes[mParamCount - 1].isArray() || w.isVarArgs() && paramCount > mParamCount && paramValues != null && paramValues.length != paramCount || !w.isVarArgs() && paramValues != null && paramCount != paramValues.length) continue;
            boolean assignable = false;
            boolean coercible = false;
            boolean varArgs = false;
            int exactMatch = 0;
            boolean noMatch = false;
            block1: for (int i = 0; i < mParamCount; ++i) {
                if (w.isVarArgs() && i == mParamCount - 1) {
                    varArgs = true;
                    if (mParamCount == paramCount && mParamTypes[i] == paramTypes[i]) continue;
                    if (i == paramCount || paramValues != null && paramValues.length == i) break;
                    Class<?> varType = mParamTypes[i].getComponentType();
                    for (int j = i; j < paramCount; ++j) {
                        if (Util.isAssignableFrom(paramTypes[j], varType)) continue;
                        if (paramValues == null) {
                            noMatch = true;
                            continue block1;
                        }
                        if (Util.isCoercibleFrom(paramValues[j], varType, factory)) continue;
                        noMatch = true;
                        continue block1;
                    }
                    continue;
                }
                if (mParamTypes[i].equals(paramTypes[i])) {
                    ++exactMatch;
                    continue;
                }
                if (paramTypes[i] != null && Util.isAssignableFrom(paramTypes[i], mParamTypes[i])) {
                    assignable = true;
                    continue;
                }
                if (paramValues == null) {
                    noMatch = true;
                    break;
                }
                if (Util.isCoercibleFrom(paramValues[i], mParamTypes[i], factory)) {
                    coercible = true;
                    continue;
                }
                noMatch = true;
                break;
            }
            if (noMatch) continue;
            if (exactMatch == paramCount) {
                return w;
            }
            if (varArgs) {
                if (candidatesType == CandidatesType.VAR_ARGS) {
                    candidates.add(w);
                    continue;
                }
                if (candidatesType.compareTo(CandidatesType.VAR_ARGS) >= 0) continue;
                candidatesType = CandidatesType.VAR_ARGS;
                candidates.clear();
                candidates.add(w);
                continue;
            }
            if (coercible) {
                if (candidatesType == CandidatesType.COERCIBLE) {
                    candidates.add(w);
                    continue;
                }
                if (candidatesType.compareTo(CandidatesType.COERCIBLE) >= 0) continue;
                candidatesType = CandidatesType.COERCIBLE;
                candidates.clear();
                candidates.add(w);
                continue;
            }
            if (!assignable) continue;
            if (candidatesType == CandidatesType.ASSIGNABLE) {
                candidates.add(w);
                continue;
            }
            if (candidatesType.compareTo(CandidatesType.ASSIGNABLE) >= 0) continue;
            candidatesType = CandidatesType.ASSIGNABLE;
            candidates.clear();
            candidates.add(w);
        }
        if (!candidates.isEmpty()) {
            String errorMsg = "Unable to find unambiguous method: " + String.valueOf(clazz) + "." + name + "(" + Util.paramString(paramTypes) + ")";
            return Util.findMostSpecificWrapper(candidates, paramTypes, candidatesType == CandidatesType.ASSIGNABLE, errorMsg);
        }
        throw new MethodNotFoundException("Method not found: " + String.valueOf(clazz) + "." + name + "(" + Util.paramString(paramTypes) + ")");
    }

    private static <T> Wrapper<T> findMostSpecificWrapper(List<Wrapper<T>> candidates, Class<?>[] matchingTypes, boolean elSpecific, String errorMsg) {
        ArrayList<Wrapper<T>> ambiguouses = new ArrayList<Wrapper<T>>();
        for (Wrapper<T> candidate : candidates) {
            boolean lessSpecific = false;
            Iterator it = ambiguouses.iterator();
            while (it.hasNext()) {
                int result = Util.isMoreSpecific(candidate, (Wrapper)it.next(), matchingTypes, elSpecific);
                if (result == 1) {
                    it.remove();
                    continue;
                }
                if (result != -1) continue;
                lessSpecific = true;
            }
            if (lessSpecific) continue;
            ambiguouses.add(candidate);
        }
        if (ambiguouses.size() > 1) {
            throw new MethodNotFoundException(errorMsg);
        }
        return (Wrapper)ambiguouses.get(0);
    }

    private static <T> int isMoreSpecific(Wrapper<T> wrapper1, Wrapper<T> wrapper2, Class<?>[] matchingTypes, boolean elSpecific) {
        Class<?>[] paramTypes1 = wrapper1.getParameterTypes();
        Class<?>[] paramTypes2 = wrapper2.getParameterTypes();
        if (wrapper1.isVarArgs()) {
            int length = Math.max(Math.max(paramTypes1.length, paramTypes2.length), matchingTypes.length);
            paramTypes1 = Util.getComparingParamTypesForVarArgsMethod(paramTypes1, length);
            paramTypes2 = Util.getComparingParamTypesForVarArgsMethod(paramTypes2, length);
            if (length > matchingTypes.length) {
                Class[] matchingTypes2 = new Class[length];
                System.arraycopy(matchingTypes, 0, matchingTypes2, 0, matchingTypes.length);
                matchingTypes = matchingTypes2;
            }
        }
        int result = 0;
        for (int i = 0; i < paramTypes1.length; ++i) {
            if (paramTypes1[i] == paramTypes2[i]) continue;
            int r2 = Util.isMoreSpecific(paramTypes1[i], paramTypes2[i], matchingTypes[i], elSpecific);
            if (r2 == 1) {
                if (result == -1) {
                    return 0;
                }
                result = 1;
                continue;
            }
            if (r2 == -1) {
                if (result == 1) {
                    return 0;
                }
                result = -1;
                continue;
            }
            return 0;
        }
        if (result == 0) {
            result = Boolean.compare(wrapper1.isBridge(), wrapper2.isBridge());
        }
        return result;
    }

    private static int isMoreSpecific(Class<?> type1, Class<?> type2, Class<?> matchingType, boolean elSpecific) {
        type1 = Util.getBoxingTypeIfPrimitive(type1);
        if ((type2 = Util.getBoxingTypeIfPrimitive(type2)).isAssignableFrom(type1)) {
            return 1;
        }
        if (type1.isAssignableFrom(type2)) {
            return -1;
        }
        if (elSpecific) {
            if (matchingType != null && Number.class.isAssignableFrom(matchingType)) {
                boolean b2;
                boolean b1 = Number.class.isAssignableFrom(type1) || type1.isPrimitive();
                boolean bl = b2 = Number.class.isAssignableFrom(type2) || type2.isPrimitive();
                if (b1 && !b2) {
                    return 1;
                }
                if (b2 && !b1) {
                    return -1;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    private static Class<?> getBoxingTypeIfPrimitive(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return Boolean.class;
            }
            if (clazz == Character.TYPE) {
                return Character.class;
            }
            if (clazz == Byte.TYPE) {
                return Byte.class;
            }
            if (clazz == Short.TYPE) {
                return Short.class;
            }
            if (clazz == Integer.TYPE) {
                return Integer.class;
            }
            if (clazz == Long.TYPE) {
                return Long.class;
            }
            if (clazz == Float.TYPE) {
                return Float.class;
            }
            return Double.class;
        }
        return clazz;
    }

    private static Class<?>[] getComparingParamTypesForVarArgsMethod(Class<?>[] paramTypes, int length) {
        Class[] result = new Class[length];
        System.arraycopy(paramTypes, 0, result, 0, paramTypes.length - 1);
        Class<?> type = paramTypes[paramTypes.length - 1].getComponentType();
        for (int i = paramTypes.length - 1; i < length; ++i) {
            result[i] = type;
        }
        return result;
    }

    private static final String paramString(Class<?>[] types) {
        if (types != null) {
            StringBuilder sb = new StringBuilder();
            for (Class<?> type : types) {
                if (type == null) {
                    sb.append("null, ");
                    continue;
                }
                sb.append(type.getName()).append(", ");
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
            }
            return sb.toString();
        }
        return null;
    }

    private static <T> Wrapper<T> resolveAmbiguousWrapper(Set<Wrapper<T>> candidates, Class<?>[] paramTypes) {
        Wrapper<T> w = candidates.iterator().next();
        int nonMatchIndex = 0;
        Class<?> nonMatchClass = null;
        for (int i = 0; i < paramTypes.length; ++i) {
            if (w.getParameterTypes()[i] == paramTypes[i]) continue;
            nonMatchIndex = i;
            nonMatchClass = paramTypes[i];
            break;
        }
        if (nonMatchClass == null) {
            return null;
        }
        for (Wrapper<T> c : candidates) {
            if (c.getParameterTypes()[nonMatchIndex] != paramTypes[nonMatchIndex]) continue;
            return null;
        }
        for (Class superClass = nonMatchClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            for (Wrapper wrapper : candidates) {
                if (!wrapper.getParameterTypes()[nonMatchIndex].equals(superClass)) continue;
                return wrapper;
            }
        }
        Wrapper<T> match = null;
        if (Number.class.isAssignableFrom(nonMatchClass)) {
            for (Wrapper<T> c : candidates) {
                Class<?> candidateType = c.getParameterTypes()[nonMatchIndex];
                if (!Number.class.isAssignableFrom(candidateType) && !candidateType.isPrimitive()) continue;
                if (match == null) {
                    match = c;
                    continue;
                }
                match = null;
                break;
            }
        }
        return match;
    }

    static boolean isAssignableFrom(Class<?> src, Class<?> target) {
        if (src == null) {
            return true;
        }
        Class<Object> targetClass = target.isPrimitive() ? (target == Boolean.TYPE ? Boolean.class : (target == Character.TYPE ? Character.class : (target == Byte.TYPE ? Byte.class : (target == Short.TYPE ? Short.class : (target == Integer.TYPE ? Integer.class : (target == Long.TYPE ? Long.class : (target == Float.TYPE ? Float.class : Double.class))))))) : target;
        return targetClass.isAssignableFrom(src);
    }

    private static boolean isCoercibleFrom(Object src, Class<?> target, ExpressionFactory factory) {
        try {
            factory.coerceToType(src, target);
        }
        catch (ELException e) {
            return false;
        }
        return true;
    }

    private static Class<?>[] getTypesFromValues(Object[] values) {
        if (values == null) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] result = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i] == null ? null : values[i].getClass();
        }
        return result;
    }

    static Method getMethod(Class<?> type, Object base, Method m) {
        JreCompat jreCompat = JreCompat.getInstance();
        if (m == null || Modifier.isPublic(type.getModifiers()) && (jreCompat.canAccess(base, m) || base != null && jreCompat.canAccess(null, m))) {
            return m;
        }
        if (Modifier.isPublic(m.getModifiers()) && jreCompat.trySetAccessible(m)) {
            return m;
        }
        Class<?>[] interfaces = type.getInterfaces();
        Method mp = null;
        for (Class<?> iface : interfaces) {
            try {
                mp = iface.getMethod(m.getName(), m.getParameterTypes());
                mp = Util.getMethod(mp.getDeclaringClass(), base, mp);
                if (mp == null) continue;
                return mp;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<?> sup = type.getSuperclass();
        if (sup != null) {
            try {
                mp = sup.getMethod(m.getName(), m.getParameterTypes());
                mp = Util.getMethod(mp.getDeclaringClass(), base, mp);
                if (mp != null) {
                    return mp;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    static Object[] buildParameters(Class<?>[] parameterTypes, boolean isVarArgs, Object[] params, ExpressionFactory factory) {
        Object[] parameters = null;
        if (parameterTypes.length > 0) {
            parameters = new Object[parameterTypes.length];
            if (params == null) {
                params = EMPTY_OBJECT_ARRAY;
            }
            int paramCount = params.length;
            if (isVarArgs) {
                int varArgIndex = parameterTypes.length - 1;
                for (int i = 0; i < varArgIndex; ++i) {
                    parameters[i] = Util.coerceValue(params[i], parameterTypes[i], factory);
                }
                Class<?> varArgClass = parameterTypes[varArgIndex].getComponentType();
                Object varargs = Array.newInstance(varArgClass, paramCount - varArgIndex);
                for (int i = varArgIndex; i < paramCount; ++i) {
                    Array.set(varargs, i - varArgIndex, Util.coerceValue(params[i], varArgClass, factory));
                }
                parameters[varArgIndex] = varargs;
            } else {
                parameters = new Object[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameters[i] = Util.coerceValue(params[i], parameterTypes[i], factory);
                }
            }
        }
        return parameters;
    }

    static Object coerceValue(Object value, Class<?> type, ExpressionFactory factory) {
        if (value != null || type.isPrimitive()) {
            return factory.coerceToType(value, type);
        }
        return null;
    }

    private static abstract class Wrapper<T> {
        private Wrapper() {
        }

        public static List<Wrapper<Method>> wrap(Method[] methods, String name) {
            ArrayList<Wrapper<Method>> result = new ArrayList<Wrapper<Method>>();
            for (Method method : methods) {
                if (!method.getName().equals(name)) continue;
                result.add(new MethodWrapper(method));
            }
            return result;
        }

        public static List<Wrapper<Constructor<?>>> wrap(Constructor<?>[] constructors) {
            ArrayList result = new ArrayList();
            for (Constructor<?> constructor : constructors) {
                result.add(new ConstructorWrapper(constructor));
            }
            return result;
        }

        public abstract T unWrap();

        public abstract Class<?>[] getParameterTypes();

        public abstract boolean isVarArgs();

        public abstract boolean isBridge();
    }

    private static enum CandidatesType {
        UNKNOWN,
        VAR_ARGS,
        COERCIBLE,
        ASSIGNABLE;

    }

    private static class ConstructorWrapper
    extends Wrapper<Constructor<?>> {
        private final Constructor<?> c;

        public ConstructorWrapper(Constructor<?> c) {
            this.c = c;
        }

        @Override
        public Constructor<?> unWrap() {
            return this.c;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.c.getParameterTypes();
        }

        @Override
        public boolean isVarArgs() {
            return this.c.isVarArgs();
        }

        @Override
        public boolean isBridge() {
            return false;
        }
    }

    private static class MethodWrapper
    extends Wrapper<Method> {
        private final Method m;

        public MethodWrapper(Method m) {
            this.m = m;
        }

        @Override
        public Method unWrap() {
            return this.m;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.m.getParameterTypes();
        }

        @Override
        public boolean isVarArgs() {
            return this.m.isVarArgs();
        }

        @Override
        public boolean isBridge() {
            return this.m.isBridge();
        }
    }
}

