/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.core.ResolvableType;
import org.springframework.data.web.PagedModel;

public class PageOpenAPIConverter
implements ModelConverter {
    private static final String PAGE_TO_REPLACE = "org.springframework.data.domain.Page";
    private static final AnnotatedType PAGED_MODEL = new AnnotatedType(PagedModel.class).resolveAsRef(true);
    private final ObjectMapperProvider springDocObjectMapper;
    private final boolean replacePageWithPagedModel;

    public PageOpenAPIConverter(boolean replacePageWithPagedModel, ObjectMapperProvider springDocObjectMapper) {
        this.replacePageWithPagedModel = replacePageWithPagedModel;
        this.springDocObjectMapper = springDocObjectMapper;
    }

    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        JavaType javaType = this.springDocObjectMapper.jsonMapper().constructType(type.getType());
        if (javaType != null) {
            Class cls = javaType.getRawClass();
            if (this.replacePageWithPagedModel && PAGE_TO_REPLACE.equals(cls.getCanonicalName())) {
                if (!type.isSchemaProperty()) {
                    type = this.resolvePagedModelType(type);
                } else {
                    type.name(SpringDocUtils.getParentTypeName(type, cls));
                }
            }
        }
        return chain.hasNext() ? chain.next().resolve(type, context, chain) : null;
    }

    private AnnotatedType resolvePagedModelType(AnnotatedType type) {
        Type pageType = type.getType();
        if (pageType instanceof ParameterizedType) {
            Type argumentType = ((ParameterizedType)type.getType()).getActualTypeArguments()[0];
            Type pagedModelType = ResolvableType.forClassWithGenerics(PagedModel.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)argumentType)}).getType();
            return new AnnotatedType(pagedModelType).resolveAsRef(true);
        }
        return PAGED_MODEL;
    }
}

