/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.mdui;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.services.WebBasedRegisteredService;
import org.apereo.cas.support.saml.mdui.MetadataResolverAdapter;
import org.apereo.cas.support.saml.mdui.SamlMetadataUIInfo;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataUIUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataUIUtils.class);

    public static SPSSODescriptor getSPSsoDescriptor(EntityDescriptor entityDescriptor) {
        LOGGER.trace("Locating SP SSO descriptor for SAML2 protocol...");
        SPSSODescriptor spssoDescriptor = entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (spssoDescriptor == null) {
            LOGGER.trace("Locating SP SSO descriptor for SAML11 protocol...");
            spssoDescriptor = entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:1.1:protocol");
        }
        if (spssoDescriptor == null) {
            LOGGER.trace("Locating SP SSO descriptor for SAML1 protocol...");
            spssoDescriptor = entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:1.0:protocol");
        }
        LOGGER.trace("SP SSO descriptor resolved to be [{}]", (Object)spssoDescriptor);
        return spssoDescriptor;
    }

    public static boolean isMetadataFoundForEntityId(MetadataResolverAdapter metadataAdapter, String entityId) {
        return metadataAdapter.getEntityDescriptorForEntityId(entityId) != null;
    }

    public static SamlMetadataUIInfo locateMetadataUserInterfaceForEntityId(MetadataResolverAdapter metadataAdapter, String entityId, WebBasedRegisteredService registeredService, HttpServletRequest requestContext) {
        EntityDescriptor entityDescriptor = metadataAdapter.getEntityDescriptorForEntityId(entityId);
        return MetadataUIUtils.locateMetadataUserInterfaceForEntityId(entityDescriptor, entityId, registeredService, requestContext);
    }

    public static SamlMetadataUIInfo locateMetadataUserInterfaceForEntityId(EntityDescriptor entityDescriptor, String entityId, WebBasedRegisteredService registeredService, HttpServletRequest requestContext) {
        SamlMetadataUIInfo mdui = new SamlMetadataUIInfo(registeredService, requestContext.getLocale().getLanguage());
        if (entityDescriptor == null) {
            LOGGER.trace("Entity descriptor not found for [{}]", (Object)entityId);
            return mdui;
        }
        SPSSODescriptor spssoDescriptor = MetadataUIUtils.getSPSsoDescriptor(entityDescriptor);
        if (spssoDescriptor == null) {
            LOGGER.trace("SP SSO descriptor not found for [{}]", (Object)entityId);
            return mdui;
        }
        Extensions extensions = spssoDescriptor.getExtensions();
        if (extensions == null) {
            LOGGER.trace("No extensions in the SP SSO descriptor are found for [{}]", (Object)UIInfo.DEFAULT_ELEMENT_NAME.getNamespaceURI());
            return mdui;
        }
        List spExtensions = extensions.getUnknownXMLObjects(UIInfo.DEFAULT_ELEMENT_NAME);
        if (spExtensions.isEmpty()) {
            LOGGER.trace("No extensions in the SP SSO descriptor are located for [{}]", (Object)UIInfo.DEFAULT_ELEMENT_NAME.getNamespaceURI());
            return mdui;
        }
        spExtensions.stream().filter(UIInfo.class::isInstance).map(UIInfo.class::cast).forEach(uiInfo -> {
            LOGGER.trace("Found MDUI info for [{}]", (Object)entityId);
            mdui.setUiInfo((UIInfo)uiInfo);
        });
        return mdui;
    }

    @Generated
    private MetadataUIUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

