/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeValueCompleteness;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.Uid;

public final class AttributeBuilder {
    private static final String NAME_ERROR = "Name must not be blank!";
    private String name;
    private List<Object> value;
    private AttributeValueCompleteness attributeValueCompleteness = AttributeValueCompleteness.COMPLETE;

    public static Attribute build(String name) {
        AttributeBuilder bld = new AttributeBuilder();
        bld.setName(name);
        return bld.build();
    }

    public static Attribute build(String name, Object ... args) {
        AttributeBuilder bld = new AttributeBuilder();
        bld.setName(name);
        bld.addValue(args);
        return bld.build();
    }

    public static Attribute build(String name, Collection<?> obj) {
        AttributeBuilder bld = new AttributeBuilder();
        bld.setName(name);
        bld.addValue(obj);
        return bld.build();
    }

    public String getName() {
        return this.name;
    }

    public AttributeBuilder setName(String name) {
        if (StringUtil.isBlank(name)) {
            throw new IllegalArgumentException(NAME_ERROR);
        }
        this.name = name;
        return this;
    }

    public List<Object> getValue() {
        return this.value == null ? null : CollectionUtil.asReadOnlyList(this.value);
    }

    public AttributeBuilder addValue(Object ... objs) {
        if (objs != null) {
            this.addValuesInternal(Arrays.asList(objs));
        }
        return this;
    }

    public AttributeBuilder addValue(Collection<?> obj) {
        this.addValuesInternal(obj);
        return this;
    }

    public Attribute build() {
        if (StringUtil.isBlank(this.name)) {
            throw new IllegalArgumentException(NAME_ERROR);
        }
        if (Uid.NAME.equals(this.name)) {
            return new Uid(this.getSingleStringValue());
        }
        if (Name.NAME.equals(this.name)) {
            return new Name(this.getSingleStringValue());
        }
        return new Attribute(this.name, this.value, this.attributeValueCompleteness);
    }

    private void checkSingleValue() {
        if (this.value == null || this.value.size() != 1) {
            throw new IllegalArgumentException("Value of attribute '" + this.name + "' must be a single value, but it has " + (this.value == null ? null : Integer.valueOf(this.value.size())) + "values");
        }
    }

    private String getSingleStringValue() {
        this.checkSingleValue();
        if (!(this.value.get(0) instanceof String)) {
            throw new IllegalArgumentException("Value of attribute '" + this.name + "' must be an instance of String.");
        }
        return (String)this.value.get(0);
    }

    private void addValuesInternal(Iterable<?> values) {
        if (values != null) {
            if (this.value == null) {
                this.value = new ArrayList<Object>();
            }
            for (Object v : values) {
                FrameworkUtil.checkAttributeValue(this.name, v);
                this.value.add(v);
            }
        }
    }

    public AttributeValueCompleteness getAttributeValueCompleteness() {
        return this.attributeValueCompleteness;
    }

    public void setAttributeValueCompleteness(AttributeValueCompleteness attributeValueCompleteness) {
        this.attributeValueCompleteness = attributeValueCompleteness;
    }

    public static Attribute buildPasswordExpirationDate(Date dateTime) {
        return AttributeBuilder.buildPasswordExpirationDate(dateTime.getTime());
    }

    public static Attribute buildPasswordExpirationDate(long dateTime) {
        return AttributeBuilder.build(OperationalAttributes.PASSWORD_EXPIRATION_DATE_NAME, dateTime);
    }

    public static Attribute buildPassword(GuardedString password) {
        return AttributeBuilder.build(OperationalAttributes.PASSWORD_NAME, password);
    }

    public static Attribute buildPassword(char[] password) {
        return AttributeBuilder.buildPassword(new GuardedString(password));
    }

    public static Attribute buildCurrentPassword(GuardedString password) {
        return AttributeBuilder.build(OperationalAttributes.CURRENT_PASSWORD_NAME, password);
    }

    public static Attribute buildCurrentPassword(char[] password) {
        return AttributeBuilder.buildCurrentPassword(new GuardedString(password));
    }

    public static Attribute buildEnabled(boolean value) {
        return AttributeBuilder.build(OperationalAttributes.ENABLE_NAME, value);
    }

    public static Attribute buildEnableDate(Date date) {
        return AttributeBuilder.buildEnableDate(date.getTime());
    }

    public static Attribute buildEnableDate(long date) {
        return AttributeBuilder.build(OperationalAttributes.ENABLE_DATE_NAME, date);
    }

    public static Attribute buildDisableDate(Date date) {
        return AttributeBuilder.buildDisableDate(date.getTime());
    }

    public static Attribute buildDisableDate(long date) {
        return AttributeBuilder.build(OperationalAttributes.DISABLE_DATE_NAME, date);
    }

    public static Attribute buildLockOut(boolean lock) {
        return AttributeBuilder.build(OperationalAttributes.LOCK_OUT_NAME, lock);
    }

    public static Attribute buildPasswordExpired(boolean value) {
        return AttributeBuilder.build(OperationalAttributes.PASSWORD_EXPIRED_NAME, value);
    }

    public static Attribute buildLastLoginDate(Date date) {
        return AttributeBuilder.buildLastLoginDate(date.getTime());
    }

    public static Attribute buildLastLoginDate(long date) {
        return AttributeBuilder.build(PredefinedAttributes.LAST_LOGIN_DATE_NAME, date);
    }

    public static Attribute buildLastPasswordChangeDate(Date date) {
        return AttributeBuilder.buildLastPasswordChangeDate(date.getTime());
    }

    public static Attribute buildLastPasswordChangeDate(long date) {
        return AttributeBuilder.build(PredefinedAttributes.LAST_PASSWORD_CHANGE_DATE_NAME, date);
    }

    public static Attribute buildPasswordChangeInterval(long value) {
        return AttributeBuilder.build(PredefinedAttributes.PASSWORD_CHANGE_INTERVAL_NAME, value);
    }
}

