/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.naming.directory.SearchControls;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.AttributeRepositoryStates;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.persondir.LdaptivePersonAttributeDao;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LdapConnectionFactory;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.ldaptive.handler.LdapEntryHandler;
import org.ldaptive.handler.SearchResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@ConditionalOnClass(value={LdapConnectionFactory.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PersonDirectory})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="CasPersonDirectoryLdapConfiguration", proxyBeanMethods=false)
class CasPersonDirectoryLdapConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasPersonDirectoryLdapConfiguration.class);
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.attribute-repository.ldap[0].ldap-url");

    CasPersonDirectoryLdapConfiguration() {
    }

    @Configuration(value="LdapAttributeRepositoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class LdapAttributeRepositoryPlanConfiguration {
        LdapAttributeRepositoryPlanConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"ldapPersonDirectoryAttributeRepositoryPlanConfigurer"})
        public PersonDirectoryAttributeRepositoryPlanConfigurer ldapPersonDirectoryAttributeRepositoryPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="ldapAttributeRepositories") BeanContainer<PersonAttributeDao> ldapAttributeRepositories) {
            return (PersonDirectoryAttributeRepositoryPlanConfigurer)BeanSupplier.of(PersonDirectoryAttributeRepositoryPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> {
                List results = ldapAttributeRepositories.toList().stream().filter(PersonAttributeDao::isEnabled).collect(Collectors.toList());
                plan.registerAttributeRepositories(results);
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="LdapAttributeRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class LdapAttributeRepositoryConfiguration {
        private static final LdapEntryHandler[] LDAP_ENTRY_HANDLERS = new LdapEntryHandler[0];
        private static final SearchResultHandler[] SEARCH_RESULT_HANDLERS = new SearchResultHandler[0];

        LdapAttributeRepositoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"ldapAttributeRepositories"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<PersonAttributeDao> ldapAttributeRepositories(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                ArrayList list = new ArrayList();
                PrincipalAttributesProperties attrs = casProperties.getAuthn().getAttributeRepository();
                attrs.getLdap().stream().filter(ldap -> StringUtils.isNotBlank((CharSequence)ldap.getBaseDn()) && StringUtils.isNotBlank((CharSequence)ldap.getLdapUrl())).forEach(ldap -> {
                    List searchEntryHandlers;
                    LdaptivePersonAttributeDao dao = new LdaptivePersonAttributeDao();
                    FunctionUtils.doIfNotNull((Object)ldap.getId(), id -> dao.setId(new String[]{id}));
                    LOGGER.debug("Configured LDAP attribute source for [{}] and baseDn [{}]", (Object)ldap.getLdapUrl(), (Object)ldap.getBaseDn());
                    dao.setConnectionFactory(LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap));
                    dao.setBaseDN(ldap.getBaseDn());
                    dao.setEnabled(ldap.getState() != AttributeRepositoryStates.DISABLED);
                    dao.putTag(PersonDirectoryAttributeRepositoryPlanConfigurer.class.getSimpleName(), (Object)(ldap.getState() == AttributeRepositoryStates.ACTIVE ? 1 : 0));
                    LOGGER.debug("LDAP attributes are fetched from [{}] via filter [{}]", (Object)ldap.getLdapUrl(), (Object)ldap.getSearchFilter());
                    dao.setSearchFilter(ldap.getSearchFilter());
                    SearchControls constraints = new SearchControls();
                    if (ldap.getAttributes() != null && !ldap.getAttributes().isEmpty()) {
                        LOGGER.debug("Configured result attribute mapping for [{}] to be [{}]", (Object)ldap.getLdapUrl(), (Object)ldap.getAttributes());
                        Map resultingAttributes = CollectionUtils.fromCommaDelimitedValues((Map)ldap.getAttributes());
                        dao.setResultAttributeMapping(resultingAttributes);
                        String[] attributes = ldap.getAttributes().keySet().toArray(ArrayUtils.EMPTY_STRING_ARRAY);
                        constraints.setReturningAttributes(attributes);
                    } else {
                        LOGGER.debug("Retrieving all attributes as no explicit attribute mappings are defined for [{}]", (Object)ldap.getLdapUrl());
                        constraints.setReturningAttributes(null);
                    }
                    List binaryAttributes = ldap.getBinaryAttributes();
                    if (binaryAttributes != null && !binaryAttributes.isEmpty()) {
                        LOGGER.debug("Setting binary attributes [{}]", (Object)binaryAttributes);
                        dao.setBinaryAttributes(binaryAttributes.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
                    }
                    if ((searchEntryHandlers = ldap.getSearchEntryHandlers()) != null && !searchEntryHandlers.isEmpty()) {
                        List searchResultHandlers;
                        List entryHandlers = LdapUtils.newLdaptiveEntryHandlers((List)searchEntryHandlers);
                        if (!entryHandlers.isEmpty()) {
                            LOGGER.debug("Setting entry handlers [{}]", (Object)entryHandlers);
                            dao.setEntryHandlers(entryHandlers.toArray(LDAP_ENTRY_HANDLERS));
                        }
                        if (!(searchResultHandlers = LdapUtils.newLdaptiveSearchResultHandlers((List)searchEntryHandlers)).isEmpty()) {
                            LOGGER.debug("Setting search result handlers [{}]", (Object)searchResultHandlers);
                            dao.setSearchResultHandlers(searchResultHandlers.toArray(SEARCH_RESULT_HANDLERS));
                        }
                    }
                    if (ldap.isSubtreeSearch()) {
                        LOGGER.debug("Configured subtree searching for [{}]", (Object)ldap.getLdapUrl());
                        constraints.setSearchScope(2);
                    }
                    if (!ldap.getQueryAttributes().isEmpty()) {
                        dao.setQueryAttributeMapping(ldap.getQueryAttributes());
                    }
                    constraints.setDerefLinkFlag(true);
                    dao.setSearchControls(constraints);
                    dao.setUseAllQueryAttributes(ldap.isUseAllQueryAttributes());
                    dao.setOrder(ldap.getOrder());
                    LOGGER.debug("Adding LDAP attribute source for [{}]", (Object)ldap.getLdapUrl());
                    list.add(dao);
                });
                return BeanContainer.of(list);
            }).otherwise(BeanContainer::empty).get();
        }
    }
}

