/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.webflow.core.AnnotatedObject;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AnnotatedAction
extends AnnotatedObject
implements Action {
    private static final Log logger = LogFactory.getLog(AnnotatedAction.class);
    public static final String NAME_ATTRIBUTE = "name";
    public static final String METHOD_ATTRIBUTE = "method";
    private Action targetAction;

    public AnnotatedAction(Action targetAction) {
        this.setTargetAction(targetAction);
    }

    public Action getTargetAction() {
        return this.targetAction;
    }

    public void setTargetAction(Action targetAction) {
        Assert.notNull((Object)targetAction, (String)"The targetAction to annotate is required");
        this.targetAction = targetAction;
    }

    public String getName() {
        return this.getAttributes().getString(NAME_ATTRIBUTE);
    }

    public void setName(String name) {
        this.getAttributes().put(NAME_ATTRIBUTE, name);
    }

    public boolean isNamed() {
        return StringUtils.hasText((String)this.getName());
    }

    public String getMethod() {
        return this.getAttributes().getString(METHOD_ATTRIBUTE);
    }

    public void setMethod(String method) {
        this.getAttributes().put(METHOD_ATTRIBUTE, method);
    }

    public AnnotatedAction putAttribute(String attributeName, Object attributeValue) {
        this.getAttributes().put(attributeName, attributeValue);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Event execute(RequestContext context) throws Exception {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Putting action execution attributes " + this.getAttributes()));
            }
            context.getAttributes().putAll(this.getAttributes());
            Event result = this.getTargetAction().execute(context);
            Event event = this.postProcessResult(result);
            return event;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Clearing action execution attributes " + this.getAttributes()));
            }
            context.getAttributes().removeAll(this.getAttributes());
        }
    }

    protected Event postProcessResult(Event resultEvent) {
        if (resultEvent == null) {
            return null;
        }
        if (this.isNamed()) {
            String qualifiedId = this.getName() + "." + resultEvent.getId();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Qualifying action result '" + resultEvent.getId() + "'; qualified result = '" + qualifiedId + "'"));
            }
            resultEvent = new Event(resultEvent.getSource(), qualifiedId, resultEvent.getAttributes());
        }
        return resultEvent;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("targetAction", (Object)this.getTargetAction()).append("attributes", this.getAttributes()).toString();
    }
}

