/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.execution.EnterStateVetoException;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.security.SecurityRule;

public class SecurityFlowExecutionListener
implements FlowExecutionListener {
    private Function<SecurityRule, AuthorizationManager<Object>> authorizationManagerInitializer = SecurityRule::getAuthorizationManager;
    private AccessDecisionManager accessDecisionManager;

    public void setAuthorizationManagerInitializer(Function<SecurityRule, AuthorizationManager<Object>> initializer) {
        Assert.notNull(initializer, (String)"'initializer' is required");
        this.authorizationManagerInitializer = initializer;
    }

    @Deprecated(since="3.0.1", forRemoval=true)
    public AccessDecisionManager getAccessDecisionManager() {
        return this.accessDecisionManager;
    }

    @Deprecated(since="3.0.1", forRemoval=true)
    public void setAccessDecisionManager(AccessDecisionManager accessDecisionManager) {
        this.accessDecisionManager = accessDecisionManager;
    }

    @Override
    public void sessionCreating(RequestContext context, FlowDefinition definition) {
        SecurityRule rule = (SecurityRule)definition.getAttributes().get("secured");
        if (rule != null) {
            this.decide(rule, definition);
        }
    }

    @Override
    public void stateEntering(RequestContext context, StateDefinition state) throws EnterStateVetoException {
        SecurityRule rule = (SecurityRule)state.getAttributes().get("secured");
        if (rule != null) {
            this.decide(rule, state);
        }
    }

    @Override
    public void transitionExecuting(RequestContext context, TransitionDefinition transition) {
        SecurityRule rule = (SecurityRule)transition.getAttributes().get("secured");
        if (rule != null) {
            this.decide(rule, transition);
        }
    }

    protected void decide(SecurityRule rule, Object object) {
        AccessDecisionManager decisionManager;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        AccessDecisionManager accessDecisionManager = decisionManager = this.accessDecisionManager != null ? this.accessDecisionManager : this.createAccessDecisionManager(rule);
        if (decisionManager != null) {
            this.accessDecisionManager.decide(authentication, object, this.getConfigAttributes(rule));
        } else {
            AuthorizationManager<Object> manager = this.authorizationManagerInitializer.apply(rule);
            manager.verify(() -> authentication, object);
        }
    }

    @Deprecated(since="3.0.1", forRemoval=true)
    protected AccessDecisionManager createAccessDecisionManager(SecurityRule rule) {
        return null;
    }

    @Deprecated(since="3.0.1", forRemoval=true)
    protected Collection<ConfigAttribute> getConfigAttributes(SecurityRule rule) {
        ArrayList<ConfigAttribute> configAttributes = new ArrayList<ConfigAttribute>();
        for (String attribute : rule.getAttributes()) {
            configAttributes.add((ConfigAttribute)new SecurityConfig(attribute));
        }
        return configAttributes;
    }
}

