/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ConditionalEventDefinition;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.EscalationEventDefinition;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.bpmn.model.VariableListenerEventDefinition;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;

public class EventSubprocessValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List eventSubprocesses = process.findFlowElementsOfType(EventSubProcess.class);
        for (EventSubProcess eventSubprocess : eventSubprocesses) {
            List startEvents = process.findFlowElementsInSubProcessOfType((SubProcess)eventSubprocess, StartEvent.class);
            for (StartEvent startEvent : startEvents) {
                VariableListenerEventDefinition variableListenerEventDefinition;
                if (startEvent.getEventDefinitions() == null || startEvent.getEventDefinitions().isEmpty()) continue;
                EventDefinition eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0);
                if (!(eventDefinition instanceof ConditionalEventDefinition || eventDefinition instanceof ErrorEventDefinition || eventDefinition instanceof EscalationEventDefinition || eventDefinition instanceof MessageEventDefinition || eventDefinition instanceof SignalEventDefinition || eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof VariableListenerEventDefinition)) {
                    this.addError(errors, "flowable-event-subprocess-invalid-start-event-definition", process, (FlowElement)eventSubprocess, (BaseElement)eventDefinition, "start event of event subprocess must be of type 'error', 'timer', 'message' or 'signal'");
                }
                if (!(eventDefinition instanceof VariableListenerEventDefinition) || !StringUtils.isEmpty((CharSequence)(variableListenerEventDefinition = (VariableListenerEventDefinition)eventDefinition).getVariableName())) continue;
                this.addError(errors, "flowable-event-subprocess-invalid-start-event-variable-name", process, (BaseElement)startEvent, "variable name is required for variable listener with activity id " + startEvent.getId());
            }
            List boundaryEvents = eventSubprocess.getBoundaryEvents();
            if (boundaryEvents == null || boundaryEvents.isEmpty()) continue;
            this.addWarning(errors, "flowable-event-subprocess-boundary-event", process, (BaseElement)eventSubprocess, "event sub process cannot have attached boundary events");
        }
    }
}

