/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j.web;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientSessionManager;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.oauth.client.OAuth10Client;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oidc.client.OidcClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class DelegatedClientOidcSessionManager
implements DelegatedClientSessionManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientOidcSessionManager.class);
    private static final String OIDC_CLIENT_ID_SESSION_KEY = "OIDC_CLIENT_ID";
    private static final String OAUTH20_CLIENT_ID_SESSION_KEY = "OAUTH20_CLIENT_ID";
    private static final List<String> SESSION_KEYS = List.of("OIDC_CLIENT_ID", "OAUTH20_CLIENT_ID");
    private final ObjectProvider<DelegatedClientAuthenticationConfigurationContext> contextProvider;

    public void trackIdentifier(WebContext webContext, TransientSessionTicket ticket, Client client) {
        OAuth20Client instance;
        if (client instanceof OAuth20Client) {
            instance = (OAuth20Client)client;
            this.trackSessionIdForOAuth20Client(webContext, instance, ticket);
        }
        if (client instanceof OidcClient) {
            instance = (OidcClient)client;
            this.trackSessionIdForOidcClient(webContext, (OidcClient)instance, ticket);
        }
    }

    public boolean supports(Client client) {
        return client instanceof OAuth20Client || client instanceof OidcClient || client instanceof OAuth10Client;
    }

    public String retrieveIdentifier(WebContext webContext, Client client) {
        for (String sessionKey : SESSION_KEYS) {
            Optional clientId = this.getSessionStore().get(webContext, sessionKey);
            if (!clientId.isPresent()) continue;
            LOGGER.trace("Found client id [{}] for key [{}]", (Object)clientId, (Object)sessionKey);
            this.getSessionStore().set(webContext, sessionKey, null);
            return clientId.map(Object::toString).orElse("");
        }
        return "";
    }

    private SessionStore getSessionStore() {
        return ((DelegatedClientAuthenticationConfigurationContext)this.contextProvider.getObject()).getSessionStore();
    }

    protected void trackSessionIdForOidcClient(WebContext webContext, OidcClient client, TransientSessionTicket ticket) {
        this.getSessionStore().set(webContext, OIDC_CLIENT_ID_SESSION_KEY, (Object)ticket.getId());
    }

    protected void trackSessionIdForOAuth20Client(WebContext webContext, OAuth20Client client, TransientSessionTicket ticket) {
        this.getSessionStore().set(webContext, OAUTH20_CLIENT_ID_SESSION_KEY, (Object)ticket.getId());
    }

    @Generated
    public DelegatedClientOidcSessionManager(ObjectProvider<DelegatedClientAuthenticationConfigurationContext> contextProvider) {
        this.contextProvider = contextProvider;
    }
}

