/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.LogCleaner;
import kafka.log.UnifiedLog;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.mutable.ArraySeq;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\t}b\u0001\u0002\u000e\u001c\u0001\u0001BQ!\n\u0001\u0005\u0002\u0019Bq\u0001\u000b\u0001C\u0002\u0013\u0005\u0011\u0006\u0003\u00048\u0001\u0001\u0006IA\u000b\u0005\bq\u0001\u0011\r\u0011\"\u0001:\u0011\u00191\u0005\u0001)A\u0005u!)q\t\u0001C\u0001\u0011\"9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\b\u0003_\u0002A\u0011AA9\u0011\u001d\tY\b\u0001C\u0001\u0003{Bq!!\"\u0001\t\u0013\t9\tC\u0004\u00028\u0002!I!!/\t\u000f\u0005u\u0007\u0001\"\u0003\u0002`\"9\u0011q\u001f\u0001\u0005\n\u0005e\bbBA\u007f\u0001\u0011%\u0011q \u0005\n\u0005O\u0001\u0011\u0013!C\u0005\u0005S9QA[\u000e\t\u0002-4QAG\u000e\t\u00021DQ!\n\n\u0005\u0002A4A!\u001d\n\u0001e\")Q\u0005\u0006C\u0001}\"9\u00111\u0001\u000b\u0005B\u0005\u0015aABA!%\u0001\t\u0019\u0005\u0003\u0004&/\u0011\u0005\u0011Q\t\u0005\b\u0003\u00079B\u0011IA%\u0005\u0019bunZ\"mK\u0006tWM\u001d)be\u0006lW\r^3sSj,G-\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u00039u\t1\u0001\\8h\u0015\u0005q\u0012!B6bM.\f7\u0001A\n\u0003\u0001\u0005\u0002\"AI\u0012\u000e\u0003mI!\u0001J\u000e\u0003C\u0005\u00137\u000f\u001e:bGRdunZ\"mK\u0006tWM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0012\u0001\u0003\u0011!\u0018.\\3\u0016\u0003)\u0002\"aK\u001b\u000e\u00031R!!\f\u0018\u0002\tU$\u0018\u000e\u001c\u0006\u0003_A\naa]3sm\u0016\u0014(B\u0001\u00102\u0015\t\u00114'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0005\u0019qN]4\n\u0005Yb#\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012A\u000f\t\u0004wy\u0002U\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r\u0003\u0014AB2p[6|g.\u0003\u0002F\u0005\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\:!\u0003-\u0019G.Z1oKJ$Vm\u001d;\u0015\u0005%c\u0005CA\u001eK\u0013\tYEH\u0001\u0003V]&$\b\"B'\u0007\u0001\u0004q\u0015aD2p[B\u0014Xm]:j_:$\u0016\u0010]3\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E\u0013\u0015A\u0002:fG>\u0014H-\u0003\u0002T!\ny1i\\7qe\u0016\u001c8/[8o)f\u0004X\r\u000b\u0002\u0007+B\u0011a+X\u0007\u0002/*\u0011\u0001,W\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005i[\u0016a\u00026va&$XM\u001d\u0006\u00039N\nQA[;oSRL!AX,\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000f\u000b\u0003\u0007A\u001a<\u0007CA1e\u001b\u0005\u0011'BA2X\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018BA3c\u0005=\t%oZ;nK:$8oU8ve\u000e,\u0017!\u0002<bYV,7%\u00015\u0011\u0005%$bB\u0001\u0012\u0012\u0003\u0019bunZ\"mK\u0006tWM\u001d)be\u0006lW\r^3sSj,G-\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\t\u0003EI\u0019\"AE7\u0011\u0005mr\u0017BA8=\u0005\u0019\te.\u001f*fMR\t1NA\bBY2\u001cu.\u001c9sKN\u001c\u0018n\u001c8t'\r!2o\u001f\t\u0003ifl\u0011!\u001e\u0006\u0003m^\fA\u0001\\1oO*\t\u00010\u0001\u0003kCZ\f\u0017B\u0001>v\u0005\u0019y%M[3diB\u0011\u0011\r`\u0005\u0003{\n\u0014\u0011#\u0011:hk6,g\u000e^:Qe>4\u0018\u000eZ3s)\u0005y\bcAA\u0001)5\t!#\u0001\tqe>4\u0018\u000eZ3Be\u001e,X.\u001a8ugR!\u0011qAA\u0017a\u0011\tI!a\u0007\u0011\r\u0005-\u00111CA\f\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011AB:ue\u0016\fWN\u0003\u0002.o&!\u0011QCA\u0007\u0005\u0019\u0019FO]3b[B!\u0011\u0011DA\u000e\u0019\u0001!1\"!\b\u0017\u0003\u0003\u0005\tQ!\u0001\u0002 \t\u0019q\fJ\u0019\u0012\t\u0005\u0005\u0012q\u0005\t\u0004w\u0005\r\u0012bAA\u0013y\t9aj\u001c;iS:<\u0007cA1\u0002*%\u0019\u00111\u00062\u0003\u0013\u0005\u0013x-^7f]R\u001c\bbBA\u0018-\u0001\u0007\u0011\u0011G\u0001\bG>tG/\u001a=u!\u0011\t\u0019$!\u0010\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\t\u0011\"\u001a=uK:\u001c\u0018n\u001c8\u000b\u0007\u0005m\u0012,A\u0002ba&LA!a\u0010\u00026\t\u0001R\t\u001f;f]NLwN\\\"p]R,\u0007\u0010\u001e\u0002\f\u000bb\u001cG.\u001e3f5N$HmE\u0002\u0018gn$\"!a\u0012\u0011\u0007\u0005\u0005q\u0003\u0006\u0003\u0002L\u0005U\u0003\u0007BA'\u0003#\u0002b!a\u0003\u0002\u0014\u0005=\u0003\u0003BA\r\u0003#\"1\"a\u0015\u001a\u0003\u0003\u0005\tQ!\u0001\u0002 \t\u0019q\f\n\u001a\t\u000f\u0005=\u0012\u00041\u0001\u00022\u00059C/Z:u\u00072,\u0017M\\:D_6\u0014\u0017N\\3e\u0007>l\u0007/Y2u\u0003:$G)\u001a7fi\u0016$v\u000e]5d)\rI\u00151\f\u0005\u0006\u001b\u001e\u0001\rA\u0014\u0015\u0003\u000fUCCa\u00021gO\u0006qB/Z:u\u00072,\u0017M\\3s/&$\b.T3tg\u0006<WMR8s[\u0006$h\u000b\r\u000b\u0004\u0013\u0006\u0015\u0004\"B'\t\u0001\u0004q\u0005F\u0001\u0005VQ\u0015A\u0001MZA6G\t\ti\u0007\u0005\u0002j/\u0005)C/Z:u\u00072,\u0017M\\5oO:+7\u000f^3e\u001b\u0016\u001c8/Y4fg^KG\u000f\u001b,1\u0003:$g+\r\u000b\u0004\u0013\u0006M\u0004BBA;\u0013\u0001\u0007a*A\u0003d_\u0012,7\r\u000b\u0002\n+\"*\u0011\u0002\u00194\u0002l\u000592\r\\3b]\u0016\u00148i\u001c8gS\u001e,\u0006\u000fZ1uKR+7\u000f\u001e\u000b\u0004\u0013\u0006}\u0004\"B'\u000b\u0001\u0004q\u0005F\u0001\u0006VQ\u0011Q\u0001MZ4\u0002!\rDWmY6MCN$8\t\\3b]\u0016$GcB%\u0002\n\u0006\r\u0016Q\u0016\u0005\b\u0003\u0017[\u0001\u0019AAG\u0003\u0015!x\u000e]5d!\u0011\ty)!(\u000f\t\u0005E\u0015\u0011\u0014\t\u0004\u0003'cTBAAK\u0015\r\t9jH\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005mE(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\u000b\tK\u0001\u0004TiJLgn\u001a\u0006\u0004\u00037c\u0004bBAS\u0017\u0001\u0007\u0011qU\u0001\fa\u0006\u0014H/\u001b;j_:LE\rE\u0002<\u0003SK1!a+=\u0005\rIe\u000e\u001e\u0005\b\u0003_[\u0001\u0019AAY\u0003)1\u0017N]:u\t&\u0014H/\u001f\t\u0004w\u0005M\u0016bAA[y\t!Aj\u001c8h\u0003i\u0019\u0007.Z2l\u0019><\u0017I\u001a;fe\u0006\u0003\b/\u001a8eS:<G)\u001e9t)\u001dI\u00151XAb\u0003\u000fDa\u0001\b\u0007A\u0002\u0005u\u0006c\u0001\u0012\u0002@&\u0019\u0011\u0011Y\u000e\u0003\u0015Us\u0017NZ5fI2{w\rC\u0004\u0002F2\u0001\r!!-\u0002\u0013M$\u0018M\u001d;TSj,\u0007bBAe\u0019\u0001\u0007\u00111Z\u0001\bCB\u0004XM\u001c3t!\u0019\ti-a5\u0002X6\u0011\u0011q\u001a\u0006\u0004\u0003#d\u0014AC2pY2,7\r^5p]&!\u0011Q[Ah\u0005\r\u0019V-\u001d\t\nw\u0005e\u0017qUAG\u0003cK1!a7=\u0005\u0019!V\u000f\u001d7fg\u0005)Ao\\'baR!\u0011\u0011]Aw!!\ti-a9\u0002(\u0006\u001d\u0018\u0002BAs\u0003\u001f\u00141!T1q!\u001dY\u0014\u0011^AG\u0003cK1!a;=\u0005\u0019!V\u000f\u001d7fe!9\u0011q^\u0007A\u0002\u0005E\u0018\u0001C7fgN\fw-Z:\u0011\r\u00055\u00171_Al\u0013\u0011\t)0a4\u0003\u0011%#XM]1cY\u0016\f1B]3bI\u001a\u0013x.\u001c'pOR!\u0011\u0011_A~\u0011\u0019ab\u00021\u0001\u0002>\u0006IrO]5uK\u0012+\bo]*j]\u001edW-T3tg\u0006<WmU3u)9\tYM!\u0001\u0003\u0006\t%!1\u0002B\r\u0005;AqAa\u0001\u0010\u0001\u0004\t9+A\u0004ok6\\U-_:\t\u000f\t\u001dq\u00021\u0001\u0002(\u00069a.^7EkB\u001c\bB\u0002\u000f\u0010\u0001\u0004\ti\fC\u0004\u0002v=\u0001\rA!\u0004\u0011\t\t=!QC\u0007\u0003\u0005#Q1Aa\u0005C\u0003!\u0019w.\u001c9sKN\u001c\u0018\u0002\u0002B\f\u0005#\u00111bQ8naJ,7o]5p]\"I!1D\b\u0011\u0002\u0003\u0007\u0011qU\u0001\tgR\f'\u000f^&fs\"9!qD\bA\u0002\t\u0005\u0012AC7bO&\u001cg+\u00197vKB\u00191Ha\t\n\u0007\t\u0015BH\u0001\u0003CsR,\u0017aI<sSR,G)\u001e9t'&tw\r\\3NKN\u001c\u0018mZ3TKR$C-\u001a4bk2$H%N\u000b\u0003\u0005WQC!a*\u0003.-\u0012!q\u0006\t\u0005\u0005c\u0011Y$\u0004\u0002\u00034)!!Q\u0007B\u001c\u0003%)hn\u00195fG.,GMC\u0002\u0003:q\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011iDa\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class LogCleanerParameterizedIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final MockTime time = new MockTime();
    private final TopicPartition[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void cleanerTest(CompressionType compressionType) {
        void var5_5;
        void var6_6;
        int largeMessageKey = 20;
        Compression codec = Compression.of((CompressionType)compressionType).build();
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var6_6.sizeInBytes();
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$3 = this.makeCleaner$default$2();
        int x$4 = this.makeCleaner$default$3();
        long x$5 = this.makeCleaner$default$4();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$3, x$4, x$5, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log, codec, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, appends);
        LogAppendInfo appendInfo = log.appendAsLeader((MemoryRecords)var6_6, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.updateHighWatermark(log.logEndOffset());
        long largeMessageOffset = appendInfo.firstOffset();
        int x$12 = largeMessageKey + 1;
        byte x$17 = this.writeDups$default$6();
        Seq<Tuple3<Object, String, Object>> dups = this.writeDups(100, 3, log, codec, x$12, x$17);
        Seq appends2 = (Seq)((IterableOps)appends.$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)var5_5, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset)), (List)Nil$.MODULE$))).$plus$plus(dups);
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
        this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
        this.cleaner().updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)this.topicPartitions()[0]));
        Assertions.assertFalse((boolean)new OffsetCheckpointFile(new File(this.logDir(), this.cleaner().cleanerManager().offsetCheckpointFile()), null).read().contains((Object)this.topicPartitions()[0]));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void testCleansCombinedCompactAndDeleteTopic(CompressionType compressionType) {
        void var10_12;
        void var9_11;
        void var5_5;
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put("retention.ms", retentionMs);
        logProps.put("cleanup.policy", "compact,delete");
        Tuple2 tuple2 = this.runCleanerAndCheckCompacted$1(100, logProps, compressionType);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        long endOffset = var5_5.logEndOffset();
        var5_5.logSegments().forEach(x$4 -> x$4.setLastModified(this.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(retentionMs))));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerParameterizedIntegrationTest.$anonfun$testCleansCombinedCompactAndDeleteTopic$3((UnifiedLog)var5_5, endOffset)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for deletion of old segments");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.cleaner().shutdown();
        this.closeLog((UnifiedLog)var5_5);
        Tuple2 tuple22 = this.runCleanerAndCheckCompacted$1(20, logProps, compressionType);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log2 = (UnifiedLog)tuple22._1();
        Seq messages = (Seq)tuple22._2();
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog((UnifiedLog)var9_11);
        Assertions.assertEquals(this.toMap((Iterable<Tuple3<Object, String, Object>>)var10_12), this.toMap(read), (String)"Contents of the map shouldn't change");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=ExcludeZstd.class)
    public void testCleanerWithMessageFormatV0(CompressionType compressionType) {
        void var5_5;
        void var6_6;
        int largeMessageKey = 20;
        Compression codec = Compression.of((CompressionType)compressionType).build();
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)0, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        NoCompression noCompression = Compression.NONE;
        int maxMessageSize = !(noCompression != null ? !noCompression.equals(codec) : codec != null) ? var6_6.sizeInBytes() : var6_6.sizeInBytes() + 6;
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$3 = this.makeCleaner$default$2();
        int x$4 = this.makeCleaner$default$3();
        long x$5 = this.makeCleaner$default$4();
        long x$6 = this.makeCleaner$default$6();
        int x$72 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$3, x$4, x$5, maxMessageSize, x$6, x$72, x$8, x$9, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Properties x$13 = this.logConfigProperties$default$1();
        float x$14 = this.logConfigProperties$default$3();
        long x$15 = this.logConfigProperties$default$4();
        int x$16 = this.logConfigProperties$default$5();
        int x$17 = this.logConfigProperties$default$6();
        long x$18 = this.logConfigProperties$default$7();
        Properties props = this.logConfigProperties(x$13, maxMessageSize, x$14, x$15, x$16, x$17, x$18);
        props.put("message.format.version", MetadataVersion.IBP_0_9_0.version());
        log.updateConfig(new LogConfig((java.util.Map)props));
        int x$24 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log, codec, x$24, (byte)0);
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, appends);
        int x$30 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> dupsV0 = this.writeDups(40, 3, log, codec, x$30, (byte)0);
        LogAppendInfo appendInfo = log.appendAsLeader((MemoryRecords)var6_6, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.updateHighWatermark(log.logEndOffset());
        long largeMessageOffset = appendInfo.firstOffset();
        props.put("message.format.version", MetadataVersion.IBP_0_11_0_IV0.version());
        log.updateConfig(new LogConfig((java.util.Map)props));
        Seq<Tuple3<Object, String, Object>> dupsV1 = this.writeDups(40, 3, log, codec, 30, (byte)1);
        Seq<Tuple3<Object, String, Object>> dupsV2 = this.writeDups(5, 3, log, codec, 15, (byte)2);
        Seq appends2 = (Seq)((IterableOps)((IterableOps)((IterableOps)appends.$plus$plus(dupsV0)).$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)var5_5, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset)), (List)Nil$.MODULE$))).$plus$plus(dupsV1)).$plus$plus(dupsV2);
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ExcludeZstd.class)
    public void testCleaningNestedMessagesWithV0AndV1(CompressionType codec) {
        Compression compression = Compression.of((CompressionType)codec).build();
        int maxMessageSize = 192;
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$4();
        long x$7 = this.makeCleaner$default$6();
        int x$82 = this.makeCleaner$default$7();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$6, maxMessageSize, x$7, x$82, 256, x$9, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Properties x$14 = this.logConfigProperties$default$1();
        float x$15 = this.logConfigProperties$default$3();
        long x$16 = this.logConfigProperties$default$4();
        int x$17 = this.logConfigProperties$default$5();
        long x$18 = this.logConfigProperties$default$7();
        Properties props = this.logConfigProperties(x$14, maxMessageSize, x$15, x$16, x$17, 256, x$18);
        props.put("message.format.version", MetadataVersion.IBP_0_9_0.version());
        log.updateConfig(new LogConfig((java.util.Map)props));
        int x$24 = 0;
        Seq appendsV0 = this.writeDupsSingleMessageSet(2, 3, log, compression, x$24, (byte)0);
        appendsV0 = (Seq)appendsV0.$plus$plus(this.writeDupsSingleMessageSet(2, 2, log, compression, 3, (byte)0));
        props.put("message.format.version", MetadataVersion.IBP_0_10_0_IV1.version());
        log.updateConfig(new LogConfig((java.util.Map)props));
        Seq appendsV1 = this.writeDupsSingleMessageSet(2, 2, log, compression, 4, (byte)1);
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(2, 2, log, compression, 4, (byte)1));
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(2, 2, log, compression, 6, (byte)1));
        Seq appends = (Seq)appendsV0.$plus$plus((IterableOnce)appendsV1);
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        Assertions.assertTrue((firstDirty > (long)appendsV0.size() ? 1 : 0) != 0);
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void cleanerConfigUpdateTest(CompressionType compressionType) {
        void var5_5;
        int largeMessageKey = 20;
        Compression codec = Compression.of((CompressionType)compressionType).build();
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var5_5.sizeInBytes();
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        float x$5 = this.makeCleaner$default$2();
        int x$6 = this.makeCleaner$default$3();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        int x$92 = this.makeCleaner$default$8();
        long x$10 = this.makeCleaner$default$9();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$5, x$6, 1L, maxMessageSize, x$7, x$8, x$92, x$10, (Option<Object>)x$4, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        this.writeDups(100, 3, log, codec, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        Assertions.assertEquals((int)1, (int)this.cleaner().cleanerCount());
        long firstDirty = log.activeSegment().baseOffset();
        TopicPartition topicPartition = new TopicPartition("log", 0);
        this.cleaner().awaitCleaned(topicPartition, firstDirty, 10L);
        Assertions.assertTrue((boolean)this.cleaner().cleanerManager().allCleanerCheckpoints().isEmpty(), (String)"Should not have cleaned");
        KafkaConfig oldConfig = LogCleanerParameterizedIntegrationTest.kafkaConfigWithCleanerConfig$1(this.cleaner().currentConfig());
        KafkaConfig newConfig = LogCleanerParameterizedIntegrationTest.kafkaConfigWithCleanerConfig$1(new CleanerConfig(2, this.cleaner().currentConfig().dedupeBufferSize, this.cleaner().currentConfig().dedupeBufferLoadFactor, 100000, this.cleaner().currentConfig().maxMessageSize, this.cleaner().currentConfig().maxIoBytesPerSecond, this.cleaner().currentConfig().backoffMs, true));
        this.cleaner().reconfigure(oldConfig, newConfig);
        Assertions.assertEquals((int)2, (int)this.cleaner().cleanerCount());
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
    }

    private void checkLastCleaned(String topic, int partitionId, long firstDirty) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        LogCleaner qual$1 = this.cleaner();
        long x$3 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(topicPartition, firstDirty, x$3);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)topicPartition));
        Assertions.assertTrue((lastCleaned >= firstDirty ? 1 : 0) != 0, (String)new StringBuilder(65).append("log cleaner should have processed up to offset ").append(firstDirty).append(", but lastCleaned=").append(lastCleaned).toString());
    }

    private void checkLogAfterAppendingDups(UnifiedLog log, long startSize, Seq<Tuple3<Object, String, Object>> appends) {
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log);
        Assertions.assertEquals(this.toMap((Iterable<Tuple3<Object, String, Object>>)appends), this.toMap(read), (String)"Contents of the map shouldn't change");
        Assertions.assertTrue((startSize > log.size() ? 1 : 0) != 0);
    }

    private Map<Object, Tuple2<String, Object>> toMap(Iterable<Tuple3<Object, String, Object>> messages) {
        return ((IterableOnceOps)messages.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int key = BoxesRunTime.unboxToInt((Object)x0$1._1());
                String value = (String)x0$1._2();
                long offset = BoxesRunTime.unboxToLong((Object)x0$1._3());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToLong((long)offset)));
            }
            throw new MatchError(null);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Iterable<Tuple3<Object, String, Object>> readFromLog(UnifiedLog log) {
        return (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().flatMap((Function1 & Serializable)segment -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().records()).asScala().map((Function1 & Serializable)deepLogEntry -> {
            int key = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(deepLogEntry.key(), TestUtils$.MODULE$.readString$default$2())));
            String value = TestUtils$.MODULE$.readString(deepLogEntry.value(), TestUtils$.MODULE$.readString$default$2());
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)deepLogEntry.offset()));
        }));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Tuple3<Object, String, Object>> writeDupsSingleMessageSet(int numKeys, int numDups, UnifiedLog log, Compression codec, int startKey, byte magicValue) {
        void withRecords_timestampType;
        IndexedSeq kvs = (IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable)x$10 -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$1(this, startKey, numKeys, BoxesRunTime.unboxToInt((Object)x$10)));
        IndexedSeq records = (IndexedSeq)kvs.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int key = x0$1._1$mcI$sp();
                String payload = (String)x0$1._2();
                return new SimpleRecord(Integer.toString(key).getBytes(), payload.getBytes());
            }
            throw new MatchError(null);
        });
        SimpleRecord[] withRecords_records = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var11_9 = null;
        LogAppendInfo appendInfo = log.appendAsLeader(MemoryRecords.withRecords((byte)magicValue, (long)withRecords_initialOffset, (Compression)codec, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.updateHighWatermark(log.logEndOffset());
        NumericRange.Inclusive offsets = new RichLong(Predef$.MODULE$.longWrapper(appendInfo.firstOffset())).to((Object)BoxesRunTime.boxToLong((long)appendInfo.lastOffset()));
        return (Seq)((IndexedSeqOps)kvs.zip((IterableOnce)offsets)).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Tuple2 kv = (Tuple2)x0$2._1();
                long offset = x0$2._2$mcJ$sp();
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp()), kv._2(), (Object)BoxesRunTime.boxToLong((long)offset));
            }
            throw new MatchError(null);
        });
    }

    private int writeDupsSingleMessageSet$default$5() {
        return 0;
    }

    private final Tuple2 runCleanerAndCheckCompacted$1(int numKeys, Properties logProps$1, CompressionType compressionType$1) {
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])this.topicPartitions()), 1));
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        int x$6 = this.makeCleaner$default$5();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        int x$9 = this.makeCleaner$default$8();
        long x$10 = this.makeCleaner$default$9();
        Option<Object> x$11 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, 100L, x$6, x$7, x$8, x$9, x$10, x$11, logProps$1));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> messages = this.writeDups(numKeys, 3, log, Compression.of((CompressionType)compressionType$1).build(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        log.updateHighWatermark(log.logEndOffset());
        long firstDirty = log.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        return new Tuple2((Object)log, messages);
    }

    public static final /* synthetic */ boolean $anonfun$testCleansCombinedCompactAndDeleteTopic$3(UnifiedLog log$1, long endOffset$1) {
        return log$1.logStartOffset() == endOffset$1 && log$1.numberOfSegments() == 1;
    }

    public static final /* synthetic */ String $anonfun$testCleansCombinedCompactAndDeleteTopic$4() {
        return "Timed out waiting for deletion of old segments";
    }

    private static final KafkaConfig kafkaConfigWithCleanerConfig$1(CleanerConfig cleanerConfig) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put("log.cleaner.threads", Integer.toString(cleanerConfig.numThreads));
        props.put("log.cleaner.dedupe.buffer.size", Long.toString(cleanerConfig.dedupeBufferSize));
        props.put("log.cleaner.io.buffer.load.factor", Double.toString(cleanerConfig.dedupeBufferLoadFactor));
        props.put("log.cleaner.io.buffer.size", Integer.toString(cleanerConfig.ioBufferSize));
        props.put("message.max.bytes", Integer.toString(cleanerConfig.maxMessageSize));
        props.put("log.cleaner.backoff.ms", Long.toString(cleanerConfig.backoffMs));
        props.put("log.cleaner.io.max.bytes.per.second", Double.toString(cleanerConfig.maxIoBytesPerSecond));
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDupsSingleMessageSet$2(LogCleanerParameterizedIntegrationTest $this, int key) {
        String payload = Integer.toString($this.counter());
        $this.incCounter();
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDupsSingleMessageSet$1(LogCleanerParameterizedIntegrationTest $this, int startKey$1, int numKeys$1, int x$10) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startKey$1), startKey$1 + numKeys$1).map((Function1 & Serializable)key -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$2($this, BoxesRunTime.unboxToInt((Object)key)));
    }

    public static class AllCompressions
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Arrays.stream((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])CompressionType.values()), (Function1 & Serializable)codec -> Arguments.of((Object[])new Object[]{codec}), ClassTag$.MODULE$.apply(Arguments.class)));
        }
    }

    public static class ExcludeZstd
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Arrays.stream((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])CompressionType.values()), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ExcludeZstd.$anonfun$provideArguments$2(x$11)))), (Function1 & Serializable)codec -> Arguments.of((Object[])new Object[]{codec}), ClassTag$.MODULE$.apply(Arguments.class)));
        }

        public static final /* synthetic */ boolean $anonfun$provideArguments$2(CompressionType x$11) {
            CompressionType compressionType = x$11;
            CompressionType compressionType2 = CompressionType.ZSTD;
            return compressionType == null ? compressionType2 != null : !compressionType.equals(compressionType2);
        }
    }
}

