/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.wicket.util.cookies.CookieDefaults;
import org.apache.wicket.util.cookies.CookieUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PreferenceManager
implements Serializable {
    private static final long serialVersionUID = 3581434664555284193L;
    private static final Logger LOG = LoggerFactory.getLogger(PreferenceManager.class);
    private static final String COOKIE_NAME = "syncope2EnduserPrefs";
    private static final int ONE_YEAR_TIME = 31536000;
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    private static final TypeReference<Map<String, String>> MAP_TYPE_REF = new TypeReference<Map<String, String>>(){};
    private static final List<Integer> PAGINATOR_CHOICES = Arrays.asList(10, 25, 50);
    private static final CookieUtils COOKIE_UTILS;

    public List<Integer> getPaginatorChoices() {
        return PAGINATOR_CHOICES;
    }

    private Map<String, String> getPrefs(String value) {
        HashMap<String, String> prefs;
        try {
            if (!StringUtils.isNotBlank((CharSequence)value)) {
                throw new Exception("Invalid cookie value '" + value + "'");
            }
            prefs = (HashMap<String, String>)MAPPER.readValue(value, MAP_TYPE_REF);
        }
        catch (Exception e) {
            LOG.debug("No preferences found", (Throwable)e);
            prefs = new HashMap<String, String>();
        }
        return prefs;
    }

    private String setPrefs(Map<String, String> prefs) throws IOException {
        StringWriter writer = new StringWriter();
        MAPPER.writeValue((Writer)writer, prefs);
        return writer.toString();
    }

    public String get(String key) {
        String result = null;
        String prefString = COOKIE_UTILS.load(COOKIE_NAME);
        if (prefString != null) {
            Map<String, String> prefs = this.getPrefs(new String(Base64.getDecoder().decode(prefString.getBytes())));
            result = prefs.get(key);
        }
        return result;
    }

    public Integer getPaginatorRows(String key) {
        Integer result = this.getPaginatorChoices().getFirst();
        String value = this.get(key);
        if (value != null) {
            result = NumberUtils.toInt((String)value, (int)10);
        }
        return result;
    }

    public List<String> getList(String key) {
        ArrayList<String> result = new ArrayList<String>();
        String compound = this.get(key);
        if (StringUtils.isNotBlank((CharSequence)compound)) {
            String[] items = compound.split(";");
            result.addAll(Arrays.asList(items));
        }
        return result;
    }

    public void set(Map<String, List<String>> prefs) {
        HashMap<String, String> current = new HashMap<String, String>();
        String prefString = COOKIE_UTILS.load(COOKIE_NAME);
        if (prefString != null) {
            current.putAll(this.getPrefs(new String(Base64.getDecoder().decode(prefString.getBytes()))));
        }
        prefs.forEach((key, values) -> current.put((String)key, String.join((CharSequence)";", values)));
        try {
            COOKIE_UTILS.save(COOKIE_NAME, Base64.getEncoder().encodeToString(this.setPrefs(current).getBytes()));
        }
        catch (IOException e) {
            LOG.error("Could not save {} info: {}", new Object[]{this.getClass().getSimpleName(), current, e});
        }
    }

    public void set(String key, String value) {
        String prefString = COOKIE_UTILS.load(COOKIE_NAME);
        HashMap<String, String> current = new HashMap<String, String>();
        if (prefString != null) {
            current.putAll(this.getPrefs(new String(Base64.getDecoder().decode(prefString.getBytes()))));
        }
        current.put(key, value);
        try {
            COOKIE_UTILS.save(COOKIE_NAME, Base64.getEncoder().encodeToString(this.setPrefs(current).getBytes()));
        }
        catch (IOException e) {
            LOG.error("Could not save {} info: {}", new Object[]{this.getClass().getSimpleName(), current, e});
        }
    }

    public void setList(String key, List<String> values) {
        this.set(key, String.join((CharSequence)";", values));
    }

    public void setList(Map<String, List<String>> prefs) {
        this.set(prefs);
    }

    private PreferenceManager() {
    }

    static {
        CookieDefaults cookieDefaults = new CookieDefaults();
        cookieDefaults.setMaxAge(31536000);
        COOKIE_UTILS = new CookieUtils(cookieDefaults);
    }
}

