/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.scripting;

import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.ScriptingException;
import org.apache.ibatis.util.MapUtil;

public class LanguageDriverRegistry {
    private final Map<Class<? extends LanguageDriver>, LanguageDriver> languageDriverMap = new HashMap<Class<? extends LanguageDriver>, LanguageDriver>();
    private Class<? extends LanguageDriver> defaultDriverClass;

    public void register(Class<? extends LanguageDriver> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("null is not a valid Language Driver");
        }
        MapUtil.computeIfAbsent(this.languageDriverMap, cls, k -> {
            try {
                return (LanguageDriver)k.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new ScriptingException("Failed to load language driver for " + cls.getName(), ex);
            }
        });
    }

    public void register(LanguageDriver instance) {
        if (instance == null) {
            throw new IllegalArgumentException("null is not a valid Language Driver");
        }
        Class<?> cls = instance.getClass();
        if (!this.languageDriverMap.containsKey(cls)) {
            this.languageDriverMap.put(cls, instance);
        }
    }

    public LanguageDriver getDriver(Class<? extends LanguageDriver> cls) {
        return this.languageDriverMap.get(cls);
    }

    public LanguageDriver getDefaultDriver() {
        return this.getDriver(this.getDefaultDriverClass());
    }

    public Class<? extends LanguageDriver> getDefaultDriverClass() {
        return this.defaultDriverClass;
    }

    public void setDefaultDriverClass(Class<? extends LanguageDriver> defaultDriverClass) {
        this.register(defaultDriverClass);
        this.defaultDriverClass = defaultDriverClass;
    }
}

