/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrVoid;

public abstract class OncRpcClientStub {
    protected OncRpcClient client;

    public OncRpcClientStub(InetAddress host, int program, int version, int port, int protocol) throws OncRpcException, IOException {
        this.client = OncRpcClient.newOncRpcClient(host, program, version, port, protocol);
    }

    public OncRpcClientStub(OncRpcClient client) throws OncRpcException, IOException {
        this.client = client;
    }

    public void close() throws OncRpcException {
        if (this.client != null) {
            try {
                this.client.close();
            }
            finally {
                this.client = null;
            }
        }
    }

    public void nullproc() throws OncRpcException {
        if (this.client == null) {
            throw new OncRpcException(16, "ONC/RPC client is not connected.");
        }
        this.client.call(0, XdrVoid.XDR_VOID, XdrVoid.XDR_VOID);
    }

    public OncRpcClient getClient() {
        return this.client;
    }

    public void setClient(OncRpcClient client) {
        if (this.client != client) {
            try {
                this.close();
            }
            catch (OncRpcException oncRpcException) {
                // empty catch block
            }
            this.client = client;
        }
    }
}

