/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrEncodingStream;

public class XdrTcpEncodingStream
extends XdrEncodingStream {
    private Socket socket;
    OutputStream stream;
    private byte[] buffer;
    private int bufferIndex;
    private int bufferHighmark;
    private int bufferFragmentHeaderIndex;
    private static final byte[] paddingZeros = new byte[]{0, 0, 0, 0};

    public XdrTcpEncodingStream(Socket streamingSocket, int bufferSize) throws IOException {
        this.socket = streamingSocket;
        this.stream = this.socket.getOutputStream();
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        if ((bufferSize & 3) != 0) {
            bufferSize = bufferSize + 4 & 0xFFFFFFFC;
        }
        this.buffer = new byte[bufferSize];
        this.bufferFragmentHeaderIndex = 0;
        this.bufferIndex = 4;
        this.bufferHighmark = bufferSize - 4;
    }

    public InetAddress getSenderAddress() {
        return this.socket.getInetAddress();
    }

    public int getSenderPort() {
        return this.socket.getPort();
    }

    public void beginEncoding(InetAddress receiverAddress, int receiverPort) throws OncRpcException, IOException {
    }

    public void endEncoding() throws OncRpcException, IOException {
        this.flush(true, false);
    }

    public void endEncoding(boolean flush) throws OncRpcException, IOException {
        this.flush(true, !flush);
    }

    private void flush(boolean lastFragment, boolean batch) throws OncRpcException, IOException {
        int fragmentLength = this.bufferIndex - this.bufferFragmentHeaderIndex - 4;
        if (lastFragment) {
            fragmentLength |= Integer.MIN_VALUE;
        }
        this.buffer[this.bufferFragmentHeaderIndex] = (byte)(fragmentLength >>> 24);
        this.buffer[this.bufferFragmentHeaderIndex + 1] = (byte)(fragmentLength >>> 16);
        this.buffer[this.bufferFragmentHeaderIndex + 2] = (byte)(fragmentLength >>> 8);
        this.buffer[this.bufferFragmentHeaderIndex + 3] = (byte)fragmentLength;
        if (!lastFragment || !batch || this.bufferIndex >= this.bufferHighmark) {
            this.stream.write(this.buffer, 0, this.bufferIndex);
            this.stream.flush();
            this.bufferFragmentHeaderIndex = 0;
            this.bufferIndex = 4;
        } else {
            this.bufferFragmentHeaderIndex = this.bufferIndex;
            this.bufferIndex += 4;
        }
    }

    public void close() throws OncRpcException, IOException {
        this.buffer = null;
        this.socket = null;
    }

    public void xdrEncodeInt(int value) throws OncRpcException, IOException {
        if (this.bufferIndex > this.bufferHighmark) {
            this.flush(false, false);
        }
        this.buffer[this.bufferIndex++] = (byte)(value >>> 24);
        this.buffer[this.bufferIndex++] = (byte)(value >>> 16);
        this.buffer[this.bufferIndex++] = (byte)(value >>> 8);
        this.buffer[this.bufferIndex++] = (byte)value;
    }

    public void xdrEncodeOpaque(byte[] value, int offset, int length) throws OncRpcException, IOException {
        int padding = 4 - (length & 3) & 3;
        while (length > 0) {
            int toCopy = this.bufferHighmark - this.bufferIndex + 4;
            if (toCopy >= length) {
                System.arraycopy(value, offset, this.buffer, this.bufferIndex, length);
                this.bufferIndex += length;
                break;
            }
            System.arraycopy(value, offset, this.buffer, this.bufferIndex, toCopy);
            this.bufferIndex += toCopy;
            offset += toCopy;
            length -= toCopy;
            this.flush(false, false);
        }
        System.arraycopy(paddingZeros, 0, this.buffer, this.bufferIndex, padding);
        this.bufferIndex += padding;
    }
}

