/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.device.MultifactorAuthenticationRegisteredDevice;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Endpoint(id="mfaDevices", defaultAccess=Access.NONE)
public class MultifactorAuthenticationDevicesEndpoint
extends BaseCasRestActuatorEndpoint {
    public MultifactorAuthenticationDevicesEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
        super(casProperties, applicationContext);
    }

    @GetMapping(value={"/{username}"}, produces={"application/json"})
    @Operation(summary="Get all present and registered MFA devices for a given user", parameters={@Parameter(name="username", description="The user that owns registered multifactor devices", in=ParameterIn.PATH)})
    public List<MultifactorAuthenticationRegisteredDevice> allMfaDevicesForUser(@PathVariable String username) throws Throwable {
        Principal principal = PrincipalFactoryUtils.newPrincipalFactory().createPrincipal(username);
        Collection providers = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext).values();
        return providers.stream().filter(provider -> Objects.nonNull(provider.getDeviceManager())).map(provider -> provider.getDeviceManager().findRegisteredDevices(principal)).flatMap(Collection::stream).toList();
    }

    @DeleteMapping(value={"/{username}/{providerId}/{key}"}, produces={"application/json"})
    @Operation(summary="Delete registered MFA device for a given user", parameters={@Parameter(name="username", description="The user that owns registered multifactor devices", in=ParameterIn.PATH), @Parameter(name="providerId", description="The multifactor provider ID that owns the device", in=ParameterIn.PATH), @Parameter(name="key", description="The device id or key that belongs to the user and needs to be removed", in=ParameterIn.PATH)})
    public void removeMfaDeviceForUser(@PathVariable String username, @PathVariable String key, @PathVariable String providerId) throws Throwable {
        Principal principal = PrincipalFactoryUtils.newPrincipalFactory().createPrincipal(username);
        Collection providers = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext).values();
        providers.stream().filter(provider -> provider.matches(providerId)).filter(provider -> Objects.nonNull(provider.getDeviceManager())).forEach(provider -> provider.getDeviceManager().removeRegisteredDevice(principal, key));
    }
}

