/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.configuration;

import org.apereo.cas.client.configuration.ConfigurationKey;
import org.apereo.cas.client.configuration.ConfigurationStrategy;
import org.apereo.cas.client.util.CommonUtils;
import org.apereo.cas.client.util.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConfigurationStrategy
implements ConfigurationStrategy {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public final boolean getBoolean(ConfigurationKey<Boolean> configurationKey) {
        return this.getValue(configurationKey, CommonUtils::toBoolean);
    }

    @Override
    public final String getString(ConfigurationKey<String> configurationKey) {
        return this.getValue(configurationKey, value -> value);
    }

    @Override
    public final long getLong(ConfigurationKey<Long> configurationKey) {
        return this.getValue(configurationKey, value -> CommonUtils.toLong(value, (Long)configurationKey.getDefaultValue()));
    }

    @Override
    public final int getInt(ConfigurationKey<Integer> configurationKey) {
        return this.getValue(configurationKey, value -> CommonUtils.toInt(value, (Integer)configurationKey.getDefaultValue()));
    }

    @Override
    public <T> Class<? extends T> getClass(ConfigurationKey<Class<? extends T>> configurationKey) {
        return this.getValue(configurationKey, value -> {
            try {
                return ReflectUtils.loadClass(value);
            }
            catch (IllegalArgumentException e) {
                return (Class)configurationKey.getDefaultValue();
            }
        });
    }

    protected abstract String get(ConfigurationKey var1);

    private <T> T getValue(ConfigurationKey<T> configurationKey, Parser<T> parser) {
        String value = this.getWithCheck(configurationKey);
        if (CommonUtils.isBlank(value)) {
            this.logger.trace("No value found for property {}, returning default {}", (Object)configurationKey.getName(), configurationKey.getDefaultValue());
            return configurationKey.getDefaultValue();
        }
        this.logger.trace("Loaded property {} with value {}", (Object)configurationKey.getName(), configurationKey.getDefaultValue());
        return parser.parse(value);
    }

    private String getWithCheck(ConfigurationKey configurationKey) {
        CommonUtils.assertNotNull(configurationKey, "configurationKey cannot be null");
        return this.get(configurationKey);
    }

    @FunctionalInterface
    private static interface Parser<T> {
        public T parse(String var1);
    }
}

