/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.stats;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.internals.MetricsUtils;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class RateTest {
    private static final double EPS = 1.0E-6;
    private Rate rate;
    private Time time;

    @BeforeEach
    public void setup() {
        this.rate = new Rate();
        this.time = new MockTime();
    }

    @ParameterizedTest
    @CsvSource(value={"1,1", "1,11", "11,1", "11,11"})
    public void testRateWithNoPriorAvailableSamples(int numSample, int sampleWindowSizeSec) {
        MetricConfig config = new MetricConfig().samples(numSample).timeWindow((long)sampleWindowSizeSec, TimeUnit.SECONDS);
        double sampleValue = 50.0;
        this.rate.record(config, 50.0, this.time.milliseconds());
        long measurementTime = TimeUnit.SECONDS.toMillis(sampleWindowSizeSec) - 1L;
        this.time.sleep(measurementTime);
        double observedRate = this.rate.measure(config, this.time.milliseconds());
        Assertions.assertFalse((boolean)Double.isNaN(observedRate));
        int dummyPriorSamplesAssumedByAlgorithm = numSample - 1;
        double windowSize = MetricsUtils.convert((long)measurementTime, (TimeUnit)TimeUnit.SECONDS) + (double)(dummyPriorSamplesAssumedByAlgorithm * sampleWindowSizeSec);
        double expectedRatePerSec = 50.0 / windowSize;
        Assertions.assertEquals((double)expectedRatePerSec, (double)observedRate, (double)1.0E-6);
    }

    @Test
    public void testRateIsConsistentAfterTheFirstWindow() {
        MetricConfig config = new MetricConfig().timeWindow(1L, TimeUnit.SECONDS).samples(2);
        List<Integer> steps = Arrays.asList(0, 99, 100, 100, 100, 100, 100, 100, 100, 100, 100);
        for (int stepMs : steps) {
            this.time.sleep((long)stepMs);
            this.rate.record(config, 1.0, this.time.milliseconds());
        }
        this.time.sleep(101L);
        for (int stepMs : steps) {
            this.time.sleep((long)stepMs);
            this.rate.record(config, 1.0, this.time.milliseconds());
            double observedRate = this.rate.measure(config, this.time.milliseconds());
            Assertions.assertTrue((10.0 <= observedRate && observedRate <= 11.0 ? 1 : 0) != 0);
            double measuredAgain = this.rate.measure(config, this.time.milliseconds());
            Assertions.assertEquals((double)observedRate, (double)measuredAgain);
        }
    }
}

