/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.io.IOException;
import java.util.Map;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidatorFactory;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.junit.jupiter.api.Test;

public class AccessTokenValidatorFactoryTest
extends OAuthBearerTest {
    @Test
    public void testConfigureThrowsExceptionOnAccessTokenValidatorInit() {
        OAuthBearerLoginCallbackHandler handler = new OAuthBearerLoginCallbackHandler();
        AccessTokenRetriever accessTokenRetriever = new AccessTokenRetriever(){

            public void init() throws IOException {
                throw new IOException("My init had an error!");
            }

            public String retrieve() {
                return "dummy";
            }
        };
        Map<String, ?> configs = this.getSaslConfigs();
        AccessTokenValidator accessTokenValidator = AccessTokenValidatorFactory.create(configs);
        this.assertThrowsWithMessage(KafkaException.class, () -> handler.init(accessTokenRetriever, accessTokenValidator), "encountered an error when initializing");
    }

    @Test
    public void testConfigureThrowsExceptionOnAccessTokenValidatorClose() {
        OAuthBearerLoginCallbackHandler handler = new OAuthBearerLoginCallbackHandler();
        AccessTokenRetriever accessTokenRetriever = new AccessTokenRetriever(){

            public void close() throws IOException {
                throw new IOException("My close had an error!");
            }

            public String retrieve() {
                return "dummy";
            }
        };
        Map<String, ?> configs = this.getSaslConfigs();
        AccessTokenValidator accessTokenValidator = AccessTokenValidatorFactory.create(configs);
        handler.init(accessTokenRetriever, accessTokenValidator);
        handler.close();
    }
}

