/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;

public class CachedValueMap {
    private HashMap<Byte, ArrayList<IndexedMatrixValue>> map = new HashMap();

    public IndexedMatrixValue getFirst(byte tag) {
        ArrayList<IndexedMatrixValue> tmp = this.map.get(tag);
        if (tmp != null) {
            return tmp.get(0);
        }
        return null;
    }

    public IndexedMatrixValue holdPlace(byte tag, Class<? extends MatrixValue> cls) {
        IndexedMatrixValue newVal = new IndexedMatrixValue(cls);
        this.add(tag, newVal);
        return newVal;
    }

    public void set(byte tag, MatrixIndexes indexes, MatrixValue value) {
        IndexedMatrixValue newVal = new IndexedMatrixValue(indexes, value);
        this.add(tag, newVal);
    }

    public void set(byte tag, MatrixIndexes indexes, MatrixValue value, boolean copy) {
        if (copy) {
            MatrixValue tmp = null;
            try {
                tmp = (MatrixValue)value.getClass().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            tmp.copy(value);
            this.set(tag, indexes, tmp);
        } else {
            this.set(tag, indexes, value);
        }
    }

    public void reset() {
        this.map.clear();
    }

    public ArrayList<IndexedMatrixValue> get(byte tag) {
        return this.map.get(tag);
    }

    public Set<Byte> getIndexesOfAll() {
        return this.map.keySet();
    }

    public void remove(byte tag) {
        this.map.remove(tag);
    }

    public void add(byte tag, IndexedMatrixValue value) {
        ArrayList<IndexedMatrixValue> list = this.map.get(tag);
        if (list == null) {
            list = new ArrayList();
            this.map.put(tag, list);
        }
        list.add(value);
    }
}

