/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class PickByCount
extends Lop {
    public static final String OPCODE = "qpick";
    private OperationTypes operation;
    private boolean inMemoryInput = false;

    public PickByCount(Lop input1, Lop input2, Expression.DataType dt, Expression.ValueType vt, OperationTypes op) {
        this(input1, input2, dt, vt, op, LopProperties.ExecType.MR);
    }

    public PickByCount(Lop input1, Lop input2, Expression.DataType dt, Expression.ValueType vt, OperationTypes op, LopProperties.ExecType et) {
        super(Lop.Type.PickValues, dt, vt);
        this.init(input1, input2, op, et);
    }

    public PickByCount(Lop input1, Lop input2, Expression.DataType dt, Expression.ValueType vt, OperationTypes op, LopProperties.ExecType et, boolean inMemoryInput) {
        super(Lop.Type.PickValues, dt, vt);
        this.inMemoryInput = inMemoryInput;
        this.init(input1, input2, op, et);
    }

    private void init(Lop input1, Lop input2, OperationTypes op, LopProperties.ExecType et) {
        this.addInput(input1);
        input1.addOutput(this);
        if (input2 != null) {
            this.addInput(input2);
            input2.addOutput(this);
        }
        this.operation = op;
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.MR) {
            this.lps.addCompatibility(JobType.GMR);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.RecordReader, breaksAlignment, aligner, definesMRJob);
        } else {
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return "Operation: " + (Object)((Object)this.operation);
    }

    public OperationTypes getOperationType() {
        return this.operation;
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int output_index) {
        return this.getInstructions("" + input_index1, "" + input_index2, "" + output_index);
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        if (this.operation != OperationTypes.MEDIAN) {
            if (this.getInputs().get(1).getDataType() == Expression.DataType.SCALAR) {
                sb.append(this.getInputs().get(1).prepScalarInputOperand(this.getExecType()));
            } else {
                sb.append(this.getInputs().get(1).prepInputOperand(input2));
            }
            sb.append("\u00b0");
        }
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append((Object)this.operation);
        sb.append("\u00b0");
        sb.append(this.inMemoryInput);
        return sb.toString();
    }

    @Override
    public String getInstructions(String input, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append((Object)this.operation);
        sb.append("\u00b0");
        sb.append(this.inMemoryInput);
        return sb.toString();
    }

    public static enum OperationTypes {
        VALUEPICK,
        RANGEPICK,
        IQM,
        MEDIAN;

    }
}

