/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.caching;

import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysml.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysml.runtime.controlprogram.caching.LazyWriteBuffer;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.gpu.context.GPUContext;
import org.apache.sysml.runtime.instructions.gpu.context.GPUObject;
import org.apache.sysml.runtime.instructions.spark.data.BroadcastObject;
import org.apache.sysml.runtime.instructions.spark.data.RDDObject;
import org.apache.sysml.runtime.io.FileFormatProperties;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaData;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.runtime.matrix.MetaDataNumItemsByEachReducer;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.util.LocalFileUtils;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.utils.Statistics;

public abstract class CacheableData<T extends CacheBlock>
extends Data {
    private static final long serialVersionUID = -413810592207212835L;
    protected static final Log LOG = LogFactory.getLog(CacheableData.class.getName());
    public static final long CACHING_THRESHOLD = (long)Math.max(4096.0, 1.0E-5 * (double)InfrastructureAnalyzer.getLocalMaxMemory());
    public static double CACHING_BUFFER_SIZE = 0.15;
    public static final LazyWriteBuffer.RPolicy CACHING_BUFFER_POLICY = LazyWriteBuffer.RPolicy.FIFO;
    public static final boolean CACHING_BUFFER_PAGECACHE = false;
    public static final boolean CACHING_WRITE_CACHE_ON_READ = false;
    public static final String CACHING_COUNTER_GROUP_NAME = "SystemML Caching Counters";
    public static final String CACHING_EVICTION_FILEEXTENSION = ".dat";
    public static final boolean CACHING_ASYNC_FILECLEANUP = true;
    private static volatile boolean _activeFlag = false;
    private static IDSequence _seq = null;
    public static String cacheEvictionLocalFilePath = null;
    public static String cacheEvictionLocalFilePrefix = "cache";
    private static ThreadLocal<Long> sizePinned = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return 0L;
        }
    };
    private static final AtomicLong _refBCs = new AtomicLong(0L);
    private final long _uniqueID = CacheableData.isCachingActive() ? _seq.getNextID() : -1L;
    private CacheStatus _cacheStatus = CacheStatus.EMPTY;
    protected SoftReference<T> _cache = null;
    protected T _data = null;
    protected MetaData _metaData = null;
    protected String _hdfsFileName = null;
    private boolean _hdfsFileExists = false;
    private FileFormatProperties _formatProps = null;
    private boolean _dirtyFlag = false;
    private int _numReadThreads = 0;
    private boolean _cleanupFlag = true;
    private String _cacheFileName = null;
    private boolean _requiresLocalWrite = false;
    private boolean _isAcquireFromEmpty = false;
    private RDDObject _rddHandle = null;
    private BroadcastObject<T> _bcHandle = null;
    protected HashMap<GPUContext, GPUObject> _gpuObjects = DMLScript.USE_ACCELERATOR ? new HashMap() : null;

    protected CacheableData(Expression.DataType dt, Expression.ValueType vt) {
        super(dt, vt);
    }

    protected CacheableData(CacheableData<T> that) {
        this(that.getDataType(), that.getValueType());
        this._cleanupFlag = that._cleanupFlag;
        this._hdfsFileName = that._hdfsFileName;
        this._hdfsFileExists = that._hdfsFileExists;
        this._gpuObjects = that._gpuObjects;
    }

    public void enableCleanup(boolean flag) {
        this._cleanupFlag = flag;
    }

    public boolean isCleanupEnabled() {
        return this._cleanupFlag;
    }

    public CacheStatus getStatus() {
        return this._cacheStatus;
    }

    public boolean isHDFSFileExists() {
        return this._hdfsFileExists;
    }

    public void setHDFSFileExists(boolean flag) {
        this._hdfsFileExists = flag;
    }

    public String getFileName() {
        return this._hdfsFileName;
    }

    public synchronized void setFileName(String file) {
        if (this._hdfsFileName != null && !this._hdfsFileName.equals(file) && !this.isEmpty(true)) {
            this._dirtyFlag = true;
        }
        this._hdfsFileName = file;
    }

    public boolean isDirty() {
        return this._dirtyFlag;
    }

    public void setDirty(boolean flag) {
        this._dirtyFlag = flag;
    }

    public FileFormatProperties getFileFormatProperties() {
        return this._formatProps;
    }

    public void setFileFormatProperties(FileFormatProperties props) {
        this._formatProps = props;
    }

    @Override
    public void setMetaData(MetaData md) {
        this._metaData = md;
    }

    @Override
    public MetaData getMetaData() {
        return this._metaData;
    }

    @Override
    public void removeMetaData() {
        this._metaData = null;
    }

    public MatrixCharacteristics getMatrixCharacteristics() {
        return this._metaData.getMatrixCharacteristics();
    }

    public abstract void refreshMetaData();

    public RDDObject getRDDHandle() {
        return this._rddHandle;
    }

    public void setRDDHandle(RDDObject rdd) {
        if (this._rddHandle != null) {
            this._rddHandle.setBackReference(null);
        }
        this._rddHandle = rdd;
        if (this._rddHandle != null) {
            rdd.setBackReference(this);
        }
    }

    public BroadcastObject<T> getBroadcastHandle() {
        return this._bcHandle;
    }

    public void setBroadcastHandle(BroadcastObject bc) {
        if (this._bcHandle != null) {
            this._bcHandle.setBackReference(null);
        }
        this._bcHandle = bc;
        if (this._bcHandle != null) {
            bc.setBackReference(this);
        }
    }

    public synchronized GPUObject getGPUObject(GPUContext gCtx) {
        if (this._gpuObjects == null) {
            return null;
        }
        return this._gpuObjects.get(gCtx);
    }

    public synchronized void setGPUObject(GPUContext gCtx, GPUObject gObj) {
        GPUObject old;
        if (this._gpuObjects == null) {
            this._gpuObjects = new HashMap();
        }
        if ((old = this._gpuObjects.put(gCtx, gObj)) != null) {
            throw new DMLRuntimeException("GPU : Inconsistent internal state - this CacheableData already has a GPUObject assigned to the current GPUContext (" + gCtx + ")");
        }
    }

    public T acquireReadAndRelease() {
        T tmp = this.acquireRead();
        this.release();
        return tmp;
    }

    public T acquireRead() {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        T ret = this.acquireReadIntern();
        if (!this.isBelowCachingThreshold()) {
            this.updateStatusPinned(true);
        }
        if (DMLScript.STATISTICS) {
            long t1 = System.nanoTime();
            CacheStatistics.incrementAcquireRTime(t1 - t0);
        }
        return ret;
    }

    private synchronized T acquireReadIntern() {
        if (!this.isAvailableToRead()) {
            throw new DMLRuntimeException("MatrixObject not available to read.");
        }
        if (this._data == null) {
            this.getCache();
        }
        if (DMLScript.USE_ACCELERATOR && this._gpuObjects != null) {
            boolean copiedFromGPU = false;
            for (Map.Entry<GPUContext, GPUObject> kv : this._gpuObjects.entrySet()) {
                GPUObject gObj = kv.getValue();
                if (gObj != null && copiedFromGPU && gObj.isDirty()) {
                    throw new DMLRuntimeException("Internal Error : Inconsistent internal state, A copy of this CacheableData was dirty on more than 1 GPU");
                }
                if (gObj == null) continue;
                copiedFromGPU = gObj.acquireHostRead(null);
                if (this._data != null) continue;
                this.getCache();
            }
        }
        if (this._data == null && this.isEmpty(true)) {
            try {
                if (DMLScript.STATISTICS) {
                    CacheStatistics.incrementHDFSHits();
                }
                if (this.getRDDHandle() == null || this.getRDDHandle().allowsShortCircuitRead()) {
                    if (this._hdfsFileName == null) {
                        throw new DMLRuntimeException("Cannot read matrix for empty filename.");
                    }
                    this._data = this.readBlobFromHDFS(this._hdfsFileName);
                    this._requiresLocalWrite = false;
                } else {
                    MutableBoolean writeStatus = new MutableBoolean();
                    this._data = this.readBlobFromRDD(this.getRDDHandle(), writeStatus);
                    this._requiresLocalWrite = !writeStatus.booleanValue();
                }
                this.setDirty(false);
            }
            catch (IOException e) {
                throw new DMLRuntimeException("Reading of " + this._hdfsFileName + " (" + this.hashCode() + ") failed.", e);
            }
            this._isAcquireFromEmpty = true;
        } else if (this._data != null && DMLScript.STATISTICS) {
            CacheStatistics.incrementMemHits();
        }
        this.acquire(false, this._data == null);
        return this._data;
    }

    public T acquireModify(T newData) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        T ret = this.acquireModifyIntern(newData);
        if (!this.isBelowCachingThreshold()) {
            this.updateStatusPinned(true);
        }
        if (DMLScript.STATISTICS) {
            long t1 = System.nanoTime();
            CacheStatistics.incrementAcquireMTime(t1 - t0);
            if (DMLScript.JMLC_MEM_STATISTICS) {
                Statistics.addCPMemObject(System.identityHashCode(this), this.getDataSize());
            }
        }
        return ret;
    }

    private synchronized T acquireModifyIntern(T newData) {
        if (!this.isAvailableToModify()) {
            throw new DMLRuntimeException("CacheableData not available to modify.");
        }
        this.clearData();
        this.acquire(true, false);
        this.setDirty(true);
        this._isAcquireFromEmpty = false;
        if (newData == null) {
            throw new DMLRuntimeException("acquireModify with empty cache block.");
        }
        this._data = newData;
        return this._data;
    }

    public void release() {
        long t0;
        long l = t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        if (!this.isBelowCachingThreshold()) {
            this.updateStatusPinned(false);
        }
        this.releaseIntern();
        if (DMLScript.STATISTICS) {
            long t1 = System.nanoTime();
            CacheStatistics.incrementReleaseTime(t1 - t0);
        }
    }

    private synchronized void releaseIntern() {
        boolean write = false;
        if (this.isModify()) {
            write = true;
            this.setDirty(true);
            this.refreshMetaData();
            this._data.compactEmptyBlock();
        }
        this.release(this._isAcquireFromEmpty && !this._requiresLocalWrite);
        if (CacheableData.isCachingActive() && this.isCached(true) && !this.isBelowCachingThreshold()) {
            if (write || this._requiresLocalWrite) {
                String filePath = this.getCacheFilePathAndName();
                try {
                    LazyWriteBuffer.writeBlock(filePath, this._data);
                }
                catch (Exception e) {
                    throw new DMLRuntimeException("Eviction to local path " + filePath + " (" + this.hashCode() + ") failed.", e);
                }
                this._requiresLocalWrite = false;
            }
            this.createCache();
            this._data = null;
        }
    }

    public synchronized void clearData() {
        if (!this.isCleanupEnabled()) {
            return;
        }
        if (!this.isAvailableToModify()) {
            throw new DMLRuntimeException("CacheableData (" + this.getDebugName() + ") not available to modify. Status = " + this._cacheStatus.name() + ".");
        }
        if (!(this.isEmpty(true) || this._data != null && this.isBelowCachingThreshold() || this._data != null && !CacheableData.isCachingActive())) {
            this.freeEvictedBlob();
        }
        this._data = null;
        this.clearCache();
        if (this._rddHandle != null) {
            this._rddHandle.setBackReference(null);
        }
        if (this._bcHandle != null) {
            this._bcHandle.setBackReference(null);
        }
        if (this._gpuObjects != null) {
            for (GPUObject gObj : this._gpuObjects.values()) {
                if (gObj == null) continue;
                gObj.clearData(null, DMLScript.EAGER_CUDA_FREE);
            }
        }
        this.setDirty(false);
        this.setEmpty();
    }

    public synchronized void exportData() {
        this.exportData(-1);
    }

    public synchronized void exportData(int replication) {
        this.exportData(this._hdfsFileName, null, replication, null);
        this._hdfsFileExists = true;
    }

    public synchronized void exportData(String fName, String outputFormat) {
        this.exportData(fName, outputFormat, -1, null);
    }

    public synchronized void exportData(String fName, String outputFormat, FileFormatProperties formatProperties) {
        this.exportData(fName, outputFormat, -1, formatProperties);
    }

    public synchronized void exportData(String fName, String outputFormat, int replication, FileFormatProperties formatProperties) {
        this.exportData(fName, outputFormat, replication, formatProperties, null);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void exportData(String fName, String outputFormat, int replication, FileFormatProperties formatProperties, String opcode) {
        if (CacheableData.LOG.isTraceEnabled()) {
            CacheableData.LOG.trace("Export data " + this.hashCode() + " " + fName);
        }
        v0 = t0 = DMLScript.STATISTICS != false ? System.nanoTime() : 0L;
        if (!this.isAvailableToRead()) {
            throw new DMLRuntimeException("MatrixObject not available to read.");
        }
        CacheableData.LOG.trace("Exporting " + this.getDebugName() + " to " + fName + " in format " + outputFormat);
        if (DMLScript.USE_ACCELERATOR && this._gpuObjects != null) {
            copiedFromGPU = false;
            for (Map.Entry<GPUContext, GPUObject> kv : this._gpuObjects.entrySet()) {
                gObj = kv.getValue();
                if (gObj != null && copiedFromGPU && gObj.isDirty()) {
                    throw new DMLRuntimeException("Internal Error : Inconsistent internal state, A copy of this CacheableData was dirty on more than 1 GPU");
                }
                if (gObj == null) continue;
                copiedFromGPU = gObj.acquireHostRead(null);
                if (this._data != null) continue;
                this.getCache();
            }
        }
        v1 = pWrite = fName.equals(this._hdfsFileName) == false;
        if (!pWrite) {
            this.setHDFSFileExists(true);
        }
        eqScheme = IOUtilFunctions.isSameFileScheme(new Path(this._hdfsFileName), new Path(fName));
        if (this.isDirty() || !eqScheme || pWrite && !this.isEqualOutputFormat(outputFormat)) {
            if (this.isEmpty(true)) {
                try {
                    this._data = this.getRDDHandle() == null || this.getRDDHandle().allowsShortCircuitRead() != false ? this.readBlobFromHDFS(this._hdfsFileName) : this.readBlobFromRDD(this.getRDDHandle(), new MutableBoolean());
                    this.setDirty(false);
                }
                catch (IOException e) {
                    throw new DMLRuntimeException("Reading of " + this._hdfsFileName + " (" + this.hashCode() + ") failed.", e);
                }
            }
            if (this._data == null) {
                this.getCache();
            }
            this.acquire(false, this._data == null);
            try {
                this.writeMetaData(fName, outputFormat, formatProperties);
                this.writeBlobToHDFS(fName, outputFormat, replication, formatProperties);
                if (pWrite) ** GOTO lbl65
                this.setDirty(false);
            }
            catch (Exception e) {
                throw new DMLRuntimeException("Export to " + fName + " failed.", e);
            }
            finally {
                this.release();
            }
        } else if (pWrite) {
            try {
                MapReduceTool.deleteFileIfExistOnHDFS(fName);
                MapReduceTool.deleteFileIfExistOnHDFS(fName + ".mtd");
                if (this.getRDDHandle() == null || this.getRDDHandle().allowsShortCircuitRead()) {
                    MapReduceTool.copyFileOnHDFS(this._hdfsFileName, fName);
                } else {
                    this.writeBlobFromRDDtoHDFS(this.getRDDHandle(), fName, outputFormat);
                }
                this.writeMetaData(fName, outputFormat, formatProperties);
            }
            catch (Exception e) {
                throw new DMLRuntimeException("Export to " + fName + " failed.", e);
            }
        } else if (this.getRDDHandle() != null && this.getRDDHandle().isPending() && !this.getRDDHandle().isHDFSFile() && !this.getRDDHandle().allowsShortCircuitRead()) {
            try {
                this.writeBlobFromRDDtoHDFS(this.getRDDHandle(), fName, outputFormat);
                this.writeMetaData(fName, outputFormat, formatProperties);
                this.getRDDHandle().setPending(false);
            }
            catch (Exception e) {
                throw new DMLRuntimeException("Export to " + fName + " failed.", e);
            }
        } else {
            CacheableData.LOG.trace(this.getDebugName() + ": Skip export to hdfs since data already exists.");
        }
lbl65:
        // 5 sources

        if (DMLScript.STATISTICS) {
            t1 = System.nanoTime();
            CacheStatistics.incrementExportTime(t1 - t0);
        }
    }

    protected boolean isBlobPresent() {
        return this._data != null;
    }

    protected void restoreBlobIntoMemory() {
        long begin;
        String cacheFilePathAndName = this.getCacheFilePathAndName();
        long l = begin = LOG.isTraceEnabled() ? System.currentTimeMillis() : 0L;
        if (LOG.isTraceEnabled()) {
            LOG.trace("CACHE: Restoring matrix...  " + this.hashCode() + "  HDFS path: " + (this._hdfsFileName == null ? "null" : this._hdfsFileName) + ", Restore from path: " + cacheFilePathAndName);
        }
        if (this._data != null) {
            throw new DMLRuntimeException(cacheFilePathAndName + " : Cannot restore on top of existing in-memory data.");
        }
        try {
            this._data = this.readBlobFromCache(cacheFilePathAndName);
        }
        catch (IOException e) {
            throw new DMLRuntimeException(cacheFilePathAndName + " : Restore failed.", e);
        }
        if (this._data == null) {
            throw new DMLRuntimeException(cacheFilePathAndName + " : Restore failed.");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Restoring matrix - COMPLETED ... " + (System.currentTimeMillis() - begin) + " msec.");
        }
    }

    protected abstract T readBlobFromCache(String var1) throws IOException;

    public final void freeEvictedBlob() {
        long begin;
        String cacheFilePathAndName = this.getCacheFilePathAndName();
        long l = begin = LOG.isTraceEnabled() ? System.currentTimeMillis() : 0L;
        if (LOG.isTraceEnabled()) {
            LOG.trace("CACHE: Freeing evicted matrix...  " + this.hashCode() + "  HDFS path: " + (this._hdfsFileName == null ? "null" : this._hdfsFileName) + " Eviction path: " + cacheFilePathAndName);
        }
        LazyWriteBuffer.deleteBlock(cacheFilePathAndName);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Freeing evicted matrix - COMPLETED ... " + (System.currentTimeMillis() - begin) + " msec.");
        }
    }

    protected boolean isBelowCachingThreshold() {
        return this._data.getInMemorySize() <= CACHING_THRESHOLD;
    }

    public long getDataSize() {
        return this._data != null ? this._data.getInMemorySize() : 0L;
    }

    protected Expression.ValueType[] getSchema() {
        return null;
    }

    @Override
    public synchronized String getDebugName() {
        int maxLength = 23;
        String debugNameEnding = this._hdfsFileName == null ? "null" : (this._hdfsFileName.length() < maxLength ? this._hdfsFileName : "..." + this._hdfsFileName.substring(this._hdfsFileName.length() - maxLength + 3));
        return this.hashCode() + " " + debugNameEnding;
    }

    protected T readBlobFromHDFS(String fname) throws IOException {
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        MatrixCharacteristics mc = iimd.getMatrixCharacteristics();
        return this.readBlobFromHDFS(fname, mc.getRows(), mc.getCols());
    }

    protected abstract T readBlobFromHDFS(String var1, long var2, long var4) throws IOException;

    protected abstract T readBlobFromRDD(RDDObject var1, MutableBoolean var2) throws IOException;

    protected abstract void writeBlobToHDFS(String var1, String var2, int var3, FileFormatProperties var4) throws IOException;

    protected abstract void writeBlobFromRDDtoHDFS(RDDObject var1, String var2, String var3) throws IOException;

    protected void writeMetaData(String filePathAndName, String outputFormat, FileFormatProperties formatProperties) throws IOException {
        OutputInfo oinfo;
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        if (iimd == null) {
            throw new DMLRuntimeException("Unexpected error while writing mtd file (" + filePathAndName + ") -- metadata is null.");
        }
        OutputInfo outputInfo = oinfo = outputFormat != null ? OutputInfo.stringToOutputInfo(outputFormat) : InputInfo.getMatchingOutputInfo(iimd.getInputInfo());
        if (oinfo != OutputInfo.MatrixMarketOutputInfo) {
            MatrixCharacteristics mc = iimd.getMatrixCharacteristics();
            if (oinfo == OutputInfo.BinaryBlockOutputInfo && DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.SINGLE_NODE && (mc.getRowsPerBlock() != ConfigurationManager.getBlocksize() || mc.getColsPerBlock() != ConfigurationManager.getBlocksize())) {
                mc = new MatrixCharacteristics(mc.getRows(), mc.getCols(), ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize(), mc.getNonZeros());
            }
            MapReduceTool.writeMetaDataFile(filePathAndName + ".mtd", this.valueType, this.getSchema(), this.dataType, mc, oinfo, formatProperties);
        }
    }

    protected boolean isEqualOutputFormat(String outputFormat) {
        boolean ret = true;
        if (outputFormat != null) {
            try {
                MetaDataFormat iimd = (MetaDataFormat)this._metaData;
                OutputInfo oi1 = InputInfo.getMatchingOutputInfo(iimd.getInputInfo());
                OutputInfo oi2 = OutputInfo.stringToOutputInfo(outputFormat);
                if (oi1 != oi2) {
                    ret = false;
                }
            }
            catch (Exception ex) {
                ret = false;
            }
        }
        return ret;
    }

    protected String getCacheFilePathAndName() {
        if (this._cacheFileName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(cacheEvictionLocalFilePath);
            sb.append(cacheEvictionLocalFilePrefix);
            sb.append(String.format("%09d", this._uniqueID));
            sb.append(CACHING_EVICTION_FILEEXTENSION);
            this._cacheFileName = sb.toString();
        }
        return this._cacheFileName;
    }

    protected void acquire(boolean isModify, boolean restore) {
        switch (this._cacheStatus) {
            case CACHED: {
                if (restore) {
                    this.restoreBlobIntoMemory();
                }
            }
            case CACHED_NOWRITE: 
            case EMPTY: {
                if (isModify) {
                    this.setModify();
                    break;
                }
                this.addOneRead();
                break;
            }
            case READ: {
                if (isModify) {
                    throw new DMLRuntimeException("READ-MODIFY not allowed.");
                }
                this.addOneRead();
                break;
            }
            case MODIFY: {
                throw new DMLRuntimeException("MODIFY-MODIFY not allowed.");
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Acquired lock on " + this.getDebugName() + ", status: " + this._cacheStatus.name());
        }
    }

    protected void release(boolean cacheNoWrite) {
        switch (this._cacheStatus) {
            case CACHED: 
            case CACHED_NOWRITE: 
            case EMPTY: {
                throw new DMLRuntimeException("Redundant release.");
            }
            case READ: {
                this.removeOneRead(this.isBlobPresent(), cacheNoWrite);
                break;
            }
            case MODIFY: {
                if (this.isBlobPresent()) {
                    this.setCached();
                    break;
                }
                this.setEmpty();
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Released lock on " + this.getDebugName() + ", status: " + this._cacheStatus.name());
        }
    }

    public boolean isCached(boolean inclCachedNoWrite) {
        return this._cacheStatus == CacheStatus.CACHED || inclCachedNoWrite && this._cacheStatus == CacheStatus.CACHED_NOWRITE;
    }

    public void setEmptyStatus() {
        this.setEmpty();
    }

    protected boolean isEmpty(boolean inclCachedNoWrite) {
        return this._cacheStatus == CacheStatus.EMPTY || inclCachedNoWrite && this._cacheStatus == CacheStatus.CACHED_NOWRITE;
    }

    protected boolean isModify() {
        return this._cacheStatus == CacheStatus.MODIFY;
    }

    protected void setEmpty() {
        this._cacheStatus = CacheStatus.EMPTY;
    }

    protected void setModify() {
        this._cacheStatus = CacheStatus.MODIFY;
    }

    protected void setCached() {
        this._cacheStatus = CacheStatus.CACHED;
    }

    protected void addOneRead() {
        ++this._numReadThreads;
        this._cacheStatus = CacheStatus.READ;
    }

    protected void removeOneRead(boolean doesBlobExist, boolean cacheNoWrite) {
        --this._numReadThreads;
        if (this._numReadThreads == 0) {
            this._cacheStatus = cacheNoWrite ? (doesBlobExist ? CacheStatus.CACHED_NOWRITE : CacheStatus.EMPTY) : (doesBlobExist ? CacheStatus.CACHED : CacheStatus.EMPTY);
        }
    }

    protected boolean isAvailableToRead() {
        return this._cacheStatus != CacheStatus.MODIFY;
    }

    protected boolean isAvailableToModify() {
        return this._cacheStatus == CacheStatus.EMPTY || this._cacheStatus == CacheStatus.CACHED || this._cacheStatus == CacheStatus.CACHED_NOWRITE;
    }

    protected void createCache() {
        if (this._cache == null || this._cache.get() == null) {
            this._cache = new SoftReference<T>(this._data);
        }
    }

    protected void getCache() {
        if (this._cache != null) {
            this._data = (CacheBlock)this._cache.get();
        }
    }

    protected void clearCache() {
        if (this._cache != null) {
            this._cache.clear();
            this._cache = null;
        }
    }

    protected void updateStatusPinned(boolean add) {
        if (this._data == null || !OptimizerUtils.isHybridExecutionMode()) {
            return;
        }
        long size = sizePinned.get();
        sizePinned.set(Math.max(size += (long)(add ? 1 : -1) * this._data.getInMemorySize(), 0L));
    }

    protected static long getPinnedSize() {
        return sizePinned.get();
    }

    public static void addBroadcastSize(long size) {
        _refBCs.addAndGet(size);
    }

    public static long getBroadcastSize() {
        return (long)((double)_refBCs.longValue() * InfrastructureAnalyzer.getLocalMaxMemoryFraction());
    }

    public static synchronized void cleanupCacheDir() {
        LazyWriteBuffer.cleanup();
        CacheableData.cleanupCacheDir(true);
    }

    public static synchronized void cleanupCacheDir(boolean withDir) {
        File fdir;
        String dir = cacheEvictionLocalFilePath;
        if (dir != null && (fdir = new File(dir)).exists()) {
            File[] files;
            for (File f : files = fdir.listFiles()) {
                if (!f.getName().startsWith(cacheEvictionLocalFilePrefix)) continue;
                f.delete();
            }
            if (withDir) {
                fdir.delete();
            }
        }
        _activeFlag = false;
    }

    public static synchronized void initCaching() throws IOException {
        CacheableData.initCaching(DMLScript.getUUID());
    }

    public static synchronized void initCaching(String uuid) throws IOException {
        try {
            String dir = LocalFileUtils.getWorkingDir("cache");
            LocalFileUtils.createLocalFileIfNotExist(dir);
            cacheEvictionLocalFilePath = dir;
        }
        catch (DMLRuntimeException e) {
            throw new IOException(e);
        }
        LazyWriteBuffer.init();
        _refBCs.set(0L);
        _activeFlag = true;
    }

    public static boolean isCachingActive() {
        return _activeFlag;
    }

    public static void disableCaching() {
        _activeFlag = false;
    }

    public static void enableCaching() {
        _activeFlag = true;
    }

    public synchronized boolean moveData(String fName, String outputFormat) {
        boolean ret = false;
        try {
            boolean eqScheme = IOUtilFunctions.isSameFileScheme(new Path(this._hdfsFileName), new Path(fName));
            if (this.isDirty() || !eqScheme || !this.isEqualOutputFormat(outputFormat) && this.isEmpty(true) || this.getRDDHandle() != null && !MapReduceTool.existsFileOnHDFS(this._hdfsFileName)) {
                this.exportData(fName, outputFormat);
                ret = true;
            } else if (this.isEqualOutputFormat(outputFormat)) {
                MapReduceTool.deleteFileIfExistOnHDFS(fName);
                MapReduceTool.deleteFileIfExistOnHDFS(fName + ".mtd");
                MapReduceTool.renameFileOnHDFS(this._hdfsFileName, fName);
                this.writeMetaData(fName, outputFormat, null);
                ret = true;
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Move to " + fName + " failed.", e);
        }
        return ret;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getSimpleName());
        str.append(": ");
        str.append(this._hdfsFileName + ", ");
        if (this._metaData instanceof MetaDataNumItemsByEachReducer) {
            str.append("NumItemsByEachReducerMetaData");
        } else {
            try {
                MetaDataFormat md = (MetaDataFormat)this._metaData;
                if (md != null) {
                    MatrixCharacteristics mc = this._metaData.getMatrixCharacteristics();
                    str.append(mc.toString());
                    InputInfo ii = md.getInputInfo();
                    if (ii == null) {
                        str.append("null");
                    } else {
                        str.append(", ");
                        str.append(InputInfo.inputInfoToString(ii));
                    }
                } else {
                    str.append("null, null");
                }
            }
            catch (Exception ex) {
                LOG.error(ex);
            }
        }
        str.append(", ");
        str.append(this.isDirty() ? "dirty" : "not-dirty");
        return str.toString();
    }

    static {
        _seq = new IDSequence();
    }

    public static enum CacheStatus {
        EMPTY,
        READ,
        MODIFY,
        CACHED,
        CACHED_NOWRITE;

    }
}

