/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.sysml.runtime.instructions.mr.CSVWriteInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.util.UtilFunctions;

public class TaggedFirstSecondIndexes
implements WritableComparable<TaggedFirstSecondIndexes> {
    protected long first = -1L;
    protected byte tag = (byte)-1;
    protected long second = -1L;

    public TaggedFirstSecondIndexes() {
    }

    public TaggedFirstSecondIndexes(long i1, byte t, long i2) {
        this.setIndexes(i1, i2);
        this.setTag(t);
    }

    public void setTag(byte t) {
        this.tag = t;
    }

    public TaggedFirstSecondIndexes(TaggedFirstSecondIndexes other) {
        this.setIndexes(other.first, other.second);
        this.setTag(other.tag);
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ") tag: " + this.tag;
    }

    public byte getTag() {
        return this.tag;
    }

    public long getFirstIndex() {
        return this.first;
    }

    public long getSecondIndex() {
        return this.second;
    }

    public void setIndexes(long i1, long i2) {
        this.first = i1;
        this.second = i2;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.first = in.readLong();
        this.tag = in.readByte();
        this.second = in.readLong();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.first);
        out.writeByte(this.tag);
        out.writeLong(this.second);
    }

    @Override
    public int compareTo(TaggedFirstSecondIndexes other) {
        if (this.first != other.first) {
            return this.first > other.first ? 1 : -1;
        }
        if (this.tag != other.tag) {
            return this.tag - other.tag;
        }
        if (this.second != other.second) {
            return this.second > other.second ? 1 : -1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TaggedFirstSecondIndexes)) {
            return false;
        }
        TaggedFirstSecondIndexes tother = (TaggedFirstSecondIndexes)other;
        return this.first == tother.first && this.tag == tother.tag && this.second == tother.second;
    }

    public int hashCode() {
        return UtilFunctions.longHashCode((this.first << 32) + this.second + (long)this.tag + 99991L) % 1405695061;
    }

    public static class TagPartitioner
    implements Partitioner<TaggedFirstSecondIndexes, MatrixValue> {
        public int getPartition(TaggedFirstSecondIndexes key, MatrixValue value, int numPartitions) {
            return key.tag % numPartitions;
        }

        public void configure(JobConf arg0) {
        }
    }

    public static class FirstIndexRangePartitioner
    implements Partitioner<TaggedFirstSecondIndexes, Writable> {
        long[] rstep = null;

        public int getPartition(TaggedFirstSecondIndexes key, Writable value, int numPartitions) {
            return (int)((key.first - 1L) / this.rstep[key.tag]);
        }

        public void configure(JobConf job) {
            String[] matrices = MRJobConfiguration.getInputPaths(job);
            int partitions = job.getNumReduceTasks();
            long[] inRstep = new long[matrices.length];
            for (int i = 0; i < matrices.length; ++i) {
                inRstep[i] = (long)Math.ceil((double)MRJobConfiguration.getNumRows(job, (byte)i) / (double)partitions);
            }
            byte maxIndex = 0;
            HashMap<Byte, Long> outRsteps = new HashMap<Byte, Long>();
            try {
                CSVWriteInstruction[] ins;
                for (CSVWriteInstruction in : ins = MRJobConfiguration.getCSVWriteInstructions(job)) {
                    outRsteps.put(in.output, inRstep[in.input]);
                    if (in.output <= maxIndex) continue;
                    maxIndex = in.output;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.rstep = new long[maxIndex + 1];
            for (Map.Entry outRstep : outRsteps.entrySet()) {
                this.rstep[((Byte)outRstep.getKey()).byteValue()] = (Long)outRstep.getValue();
            }
        }
    }

    public static class FirstIndexPartitioner
    implements Partitioner<TaggedFirstSecondIndexes, Writable> {
        public int getPartition(TaggedFirstSecondIndexes key, Writable value, int numPartitions) {
            return UtilFunctions.longHashCode(key.getFirstIndex() * 127L) % 10007 % numPartitions;
        }

        public void configure(JobConf arg0) {
        }
    }

    public static class Comparator
    implements RawComparator<TaggedFirstSecondIndexes> {
        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return WritableComparator.compareBytes(b1, s1, l1, b2, s2, l2);
        }

        @Override
        public int compare(TaggedFirstSecondIndexes m1, TaggedFirstSecondIndexes m2) {
            return m1.compareTo(m2);
        }
    }
}

