/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.sort;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.sysml.runtime.io.IOUtilFunctions;

public class CompactOutputFormat<K extends Writable, V extends Writable>
extends FileOutputFormat<K, V> {
    static final String FINAL_SYNC_ATTRIBUTE = "final.sync";

    public static boolean getFinalSync(JobConf conf) {
        return conf.getBoolean(FINAL_SYNC_ATTRIBUTE, false);
    }

    @Override
    public RecordWriter<K, V> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        Path file = FileOutputFormat.getTaskOutputPath(job, name);
        FileSystem fs = file.getFileSystem(job);
        FSDataOutputStream fileOut = fs.create(file, progress);
        return new FixedLengthRecordWriter(fileOut, job);
    }

    public static class FixedLengthRecordWriter<K extends Writable, V extends Writable>
    implements RecordWriter<K, V> {
        private DataOutputStream out;
        private boolean finalSync = false;

        public FixedLengthRecordWriter(DataOutputStream out, JobConf conf) {
            this.out = out;
            this.finalSync = CompactOutputFormat.getFinalSync(conf);
        }

        public void close(Reporter reporter) throws IOException {
            if (this.finalSync) {
                ((FSDataOutputStream)this.out).sync();
            }
            IOUtilFunctions.closeSilently(this.out);
        }

        public void write(K key, V value) throws IOException {
            key.write(this.out);
            value.write(this.out);
        }
    }
}

