/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.mapred.AvroOutputFormat;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class AvroTextOutputFormat<K, V>
extends FileOutputFormat<K, V> {
    private static final String UTF8 = "UTF-8";

    public RecordWriter<K, V> getRecordWriter(FileSystem ignore, JobConf job, String name, Progressable prog) throws IOException {
        Schema schema = Schema.create((Schema.Type)Schema.Type.BYTES);
        byte[] keyValueSeparator = job.get("mapreduce.output.textoutputformat.separator", "\t").getBytes(UTF8);
        DataFileWriter writer = new DataFileWriter((DatumWriter)new ReflectDatumWriter());
        AvroOutputFormat.configureDataFileWriter(writer, job);
        Path path = FileOutputFormat.getTaskOutputPath((JobConf)job, (String)(name + ".avro"));
        writer.create(schema, (OutputStream)path.getFileSystem((Configuration)job).create(path));
        return new AvroTextRecordWriter((DataFileWriter<ByteBuffer>)writer, keyValueSeparator);
    }

    class AvroTextRecordWriter
    implements RecordWriter<K, V> {
        private final DataFileWriter<ByteBuffer> writer;
        private final byte[] keyValueSeparator;

        public AvroTextRecordWriter(DataFileWriter<ByteBuffer> writer, byte[] keyValueSeparator) {
            this.writer = writer;
            this.keyValueSeparator = keyValueSeparator;
        }

        public void write(K key, V value) throws IOException {
            boolean nullValue;
            boolean nullKey = key == null || key instanceof NullWritable;
            boolean bl = nullValue = value == null || value instanceof NullWritable;
            if (nullKey && nullValue) {
                return;
            }
            if (!nullKey && nullValue) {
                this.writer.append((Object)this.toByteBuffer(key));
            } else if (nullKey && !nullValue) {
                this.writer.append((Object)this.toByteBuffer(value));
            } else {
                this.writer.append((Object)this.toByteBuffer(key, this.keyValueSeparator, value));
            }
        }

        public void close(Reporter reporter) throws IOException {
            this.writer.close();
        }

        private ByteBuffer toByteBuffer(Object o) throws IOException {
            if (o instanceof Text) {
                Text to = (Text)o;
                return ByteBuffer.wrap(to.getBytes(), 0, to.getLength());
            }
            return ByteBuffer.wrap(o.toString().getBytes(AvroTextOutputFormat.UTF8));
        }

        private ByteBuffer toByteBuffer(Object key, byte[] sep, Object value) throws IOException {
            int valLength;
            byte[] valBytes;
            int keyLength;
            byte[] keyBytes;
            if (key instanceof Text) {
                Text tkey = (Text)key;
                keyBytes = tkey.getBytes();
                keyLength = tkey.getLength();
            } else {
                keyBytes = key.toString().getBytes(AvroTextOutputFormat.UTF8);
                keyLength = keyBytes.length;
            }
            if (value instanceof Text) {
                Text tval = (Text)value;
                valBytes = tval.getBytes();
                valLength = tval.getLength();
            } else {
                valBytes = value.toString().getBytes(AvroTextOutputFormat.UTF8);
                valLength = valBytes.length;
            }
            ByteBuffer buf = ByteBuffer.allocate(keyLength + sep.length + valLength);
            buf.put(keyBytes, 0, keyLength);
            buf.put(sep);
            buf.put(valBytes, 0, valLength);
            buf.rewind();
            return buf;
        }
    }
}

