/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.utils;

import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageCacheStatistics;
import org.apache.sysds.runtime.matrix.data.LibMatrixDNN;
import org.apache.sysds.runtime.privacy.CheckedConstraintsLog;
import org.apache.sysds.utils.GPUStatistics;
import org.apache.sysds.utils.NativeHelper;

public class Statistics {
    private static long compileStartTime = 0L;
    private static long compileEndTime = 0L;
    private static long execStartTime = 0L;
    private static long execEndTime = 0L;
    private static final ConcurrentHashMap<String, InstStats> _instStats = new ConcurrentHashMap();
    private static final LongAdder numExecutedSPInst = new LongAdder();
    private static final LongAdder numCompiledSPInst = new LongAdder();
    private static final DoubleAdder sizeofPinnedObjects = new DoubleAdder();
    private static long maxNumPinnedObjects = 0L;
    private static double maxSizeofPinnedObjects = 0.0;
    private static final ConcurrentHashMap<String, Double> _cpMemObjs = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, Double> _currCPMemObjs = new ConcurrentHashMap();
    private static long jitCompileTime = 0L;
    private static long jvmGCTime = 0L;
    private static long jvmGCCount = 0L;
    private static final LongAdder hopRecompileTime = new LongAdder();
    private static final LongAdder hopRecompilePred = new LongAdder();
    private static final LongAdder hopRecompileSB = new LongAdder();
    private static final LongAdder codegenCompileTime = new LongAdder();
    private static final LongAdder codegenClassCompileTime = new LongAdder();
    private static final LongAdder codegenHopCompile = new LongAdder();
    private static final LongAdder codegenCPlanCompile = new LongAdder();
    private static final LongAdder codegenClassCompile = new LongAdder();
    private static final LongAdder codegenEnumAll = new LongAdder();
    private static final LongAdder codegenEnumAllP = new LongAdder();
    private static final LongAdder codegenEnumEval = new LongAdder();
    private static final LongAdder codegenEnumEvalP = new LongAdder();
    private static final LongAdder codegenOpCacheHits = new LongAdder();
    private static final LongAdder codegenOpCacheTotal = new LongAdder();
    private static final LongAdder codegenPlanCacheHits = new LongAdder();
    private static final LongAdder codegenPlanCacheTotal = new LongAdder();
    private static final LongAdder funRecompileTime = new LongAdder();
    private static final LongAdder funRecompiles = new LongAdder();
    private static long sparkCtxCreateTime = 0L;
    private static final LongAdder sparkParallelize = new LongAdder();
    private static final LongAdder sparkParallelizeCount = new LongAdder();
    private static final LongAdder sparkCollect = new LongAdder();
    private static final LongAdder sparkCollectCount = new LongAdder();
    private static final LongAdder sparkBroadcast = new LongAdder();
    private static final LongAdder sparkBroadcastCount = new LongAdder();
    private static final LongAdder psNumWorkers = new LongAdder();
    private static final LongAdder psSetupTime = new LongAdder();
    private static final LongAdder psGradientComputeTime = new LongAdder();
    private static final LongAdder psAggregationTime = new LongAdder();
    private static final LongAdder psLocalModelUpdateTime = new LongAdder();
    private static final LongAdder psModelBroadcastTime = new LongAdder();
    private static final LongAdder psBatchIndexTime = new LongAdder();
    private static final LongAdder psRpcRequestTime = new LongAdder();
    private static long parforOptTime = 0L;
    private static long parforOptCount = 0L;
    private static long parforInitTime = 0L;
    private static long parforMergeTime = 0L;
    private static final LongAdder lTotalUIPVar = new LongAdder();
    private static final LongAdder lTotalLix = new LongAdder();
    private static final LongAdder lTotalLixUIP = new LongAdder();
    private static final LongAdder federatedReadCount = new LongAdder();
    private static final LongAdder federatedPutCount = new LongAdder();
    private static final LongAdder federatedGetCount = new LongAdder();
    private static final LongAdder federatedExecuteInstructionCount = new LongAdder();
    private static final LongAdder federatedExecuteUDFCount = new LongAdder();
    private static LongAdder numNativeFailures = new LongAdder();
    public static LongAdder numNativeLibMatrixMultCalls = new LongAdder();
    public static LongAdder numNativeConv2dCalls = new LongAdder();
    public static LongAdder numNativeConv2dBwdDataCalls = new LongAdder();
    public static LongAdder numNativeConv2dBwdFilterCalls = new LongAdder();
    public static LongAdder numNativeSparseConv2dCalls = new LongAdder();
    public static LongAdder numNativeSparseConv2dBwdFilterCalls = new LongAdder();
    public static LongAdder numNativeSparseConv2dBwdDataCalls = new LongAdder();
    public static long nativeLibMatrixMultTime = 0L;
    public static long nativeConv2dTime = 0L;
    public static long nativeConv2dBwdDataTime = 0L;
    public static long nativeConv2dBwdFilterTime = 0L;
    public static long recomputeNNZTime = 0L;
    public static long examSparsityTime = 0L;
    public static long allocateDoubleArrTime = 0L;
    public static boolean allowWorkerStatistics = true;

    public static void incrementNativeFailuresCounter() {
        numNativeFailures.increment();
        throw new RuntimeException("Unexpected ERROR: OOM caused during JNI transfer. Please disable native BLAS by setting enviroment variable: SYSTEMDS_BLAS=none");
    }

    public static long getNoOfExecutedSPInst() {
        return numExecutedSPInst.longValue();
    }

    public static void incrementNoOfExecutedSPInst() {
        numExecutedSPInst.increment();
    }

    public static void decrementNoOfExecutedSPInst() {
        numExecutedSPInst.decrement();
    }

    public static long getNoOfCompiledSPInst() {
        return numCompiledSPInst.longValue();
    }

    public static void incrementNoOfCompiledSPInst() {
        numCompiledSPInst.increment();
    }

    public static boolean createdSparkContext() {
        return sparkCtxCreateTime > 0L;
    }

    public static long getTotalUIPVar() {
        return lTotalUIPVar.longValue();
    }

    public static void incrementTotalUIPVar() {
        lTotalUIPVar.increment();
    }

    public static long getTotalLixUIP() {
        return lTotalLixUIP.longValue();
    }

    public static void incrementTotalLixUIP() {
        lTotalLixUIP.increment();
    }

    public static long getTotalLix() {
        return lTotalLix.longValue();
    }

    public static void incrementTotalLix() {
        lTotalLix.increment();
    }

    public static void resetNoOfCompiledJobs(int count) {
        numCompiledSPInst.reset();
        if (OptimizerUtils.isSparkExecutionMode()) {
            numCompiledSPInst.add(count);
        }
    }

    public static void resetNoOfExecutedJobs() {
        numExecutedSPInst.reset();
        if (DMLScript.USE_ACCELERATOR) {
            GPUStatistics.setNoOfExecutedGPUInst(0);
        }
    }

    public static synchronized void incrementJITCompileTime(long time) {
        jitCompileTime += time;
    }

    public static synchronized void incrementJVMgcTime(long time) {
        jvmGCTime += time;
    }

    public static synchronized void incrementJVMgcCount(long delta) {
        jvmGCCount += delta;
    }

    public static void incrementHOPRecompileTime(long delta) {
        hopRecompileTime.add(delta);
    }

    public static void incrementHOPRecompilePred() {
        hopRecompilePred.increment();
    }

    public static void incrementHOPRecompilePred(long delta) {
        hopRecompilePred.add(delta);
    }

    public static void incrementHOPRecompileSB() {
        hopRecompileSB.increment();
    }

    public static void incrementHOPRecompileSB(long delta) {
        hopRecompileSB.add(delta);
    }

    public static void incrementCodegenDAGCompile() {
        codegenHopCompile.increment();
    }

    public static void incrementCodegenCPlanCompile(long delta) {
        codegenCPlanCompile.add(delta);
    }

    public static void incrementCodegenEnumAll(long delta) {
        codegenEnumAll.add(delta);
    }

    public static void incrementCodegenEnumAllP(long delta) {
        codegenEnumAllP.add(delta);
    }

    public static void incrementCodegenEnumEval(long delta) {
        codegenEnumEval.add(delta);
    }

    public static void incrementCodegenEnumEvalP(long delta) {
        codegenEnumEvalP.add(delta);
    }

    public static void incrementCodegenClassCompile() {
        codegenClassCompile.increment();
    }

    public static void incrementCodegenCompileTime(long delta) {
        codegenCompileTime.add(delta);
    }

    public static void incrementCodegenClassCompileTime(long delta) {
        codegenClassCompileTime.add(delta);
    }

    public static void incrementCodegenOpCacheHits() {
        codegenOpCacheHits.increment();
    }

    public static void incrementCodegenOpCacheTotal() {
        codegenOpCacheTotal.increment();
    }

    public static void incrementCodegenPlanCacheHits() {
        codegenPlanCacheHits.increment();
    }

    public static void incrementCodegenPlanCacheTotal() {
        codegenPlanCacheTotal.increment();
    }

    public static long getCodegenDAGCompile() {
        return codegenHopCompile.longValue();
    }

    public static long getCodegenCPlanCompile() {
        return codegenCPlanCompile.longValue();
    }

    public static long getCodegenEnumAll() {
        return codegenEnumAll.longValue();
    }

    public static long getCodegenEnumAllP() {
        return codegenEnumAllP.longValue();
    }

    public static long getCodegenEnumEval() {
        return codegenEnumEval.longValue();
    }

    public static long getCodegenEnumEvalP() {
        return codegenEnumEvalP.longValue();
    }

    public static long getCodegenClassCompile() {
        return codegenClassCompile.longValue();
    }

    public static long getCodegenCompileTime() {
        return codegenCompileTime.longValue();
    }

    public static long getCodegenClassCompileTime() {
        return codegenClassCompileTime.longValue();
    }

    public static long getCodegenOpCacheHits() {
        return codegenOpCacheHits.longValue();
    }

    public static long getCodegenOpCacheTotal() {
        return codegenOpCacheTotal.longValue();
    }

    public static long getCodegenPlanCacheHits() {
        return codegenPlanCacheHits.longValue();
    }

    public static long getCodegenPlanCacheTotal() {
        return codegenPlanCacheTotal.longValue();
    }

    public static void incrementFunRecompileTime(long delta) {
        funRecompileTime.add(delta);
    }

    public static void incrementFunRecompiles() {
        funRecompiles.increment();
    }

    public static synchronized void incrementParForOptimCount() {
        ++parforOptCount;
    }

    public static synchronized void incrementParForOptimTime(long time) {
        parforOptTime += time;
    }

    public static synchronized void incrementParForInitTime(long time) {
        parforInitTime += time;
    }

    public static synchronized void incrementParForMergeTime(long time) {
        parforMergeTime += time;
    }

    public static synchronized void incFederated(FederatedRequest.RequestType rqt) {
        switch (rqt) {
            case READ_VAR: {
                federatedReadCount.increment();
                break;
            }
            case PUT_VAR: {
                federatedPutCount.increment();
                break;
            }
            case GET_VAR: {
                federatedGetCount.increment();
                break;
            }
            case EXEC_INST: {
                federatedExecuteInstructionCount.increment();
                break;
            }
            case EXEC_UDF: {
                federatedExecuteUDFCount.increment();
                break;
            }
        }
    }

    public static void startCompileTimer() {
        if (DMLScript.STATISTICS) {
            compileStartTime = System.nanoTime();
        }
    }

    public static void stopCompileTimer() {
        if (DMLScript.STATISTICS) {
            compileEndTime = System.nanoTime();
        }
    }

    public static long getCompileTime() {
        return compileEndTime - compileStartTime;
    }

    public static void startRunTimer() {
        execStartTime = System.nanoTime();
    }

    public static void stopRunTimer() {
        execEndTime = System.nanoTime();
    }

    public static long getRunTime() {
        return execEndTime - execStartTime;
    }

    public static void reset() {
        hopRecompileTime.reset();
        hopRecompilePred.reset();
        hopRecompileSB.reset();
        funRecompiles.reset();
        funRecompileTime.reset();
        codegenHopCompile.reset();
        codegenCPlanCompile.reset();
        codegenClassCompile.reset();
        codegenEnumAll.reset();
        codegenEnumAllP.reset();
        codegenEnumEval.reset();
        codegenEnumEvalP.reset();
        codegenCompileTime.reset();
        codegenClassCompileTime.reset();
        codegenOpCacheHits.reset();
        codegenOpCacheTotal.reset();
        codegenPlanCacheHits.reset();
        codegenPlanCacheTotal.reset();
        parforOptCount = 0L;
        parforOptTime = 0L;
        parforInitTime = 0L;
        parforMergeTime = 0L;
        sparkCtxCreateTime = 0L;
        lTotalLix.reset();
        lTotalLixUIP.reset();
        lTotalUIPVar.reset();
        CacheStatistics.reset();
        LineageCacheStatistics.reset();
        Statistics.resetJITCompileTime();
        Statistics.resetJVMgcTime();
        Statistics.resetJVMgcCount();
        Statistics.resetCPHeavyHitters();
        GPUStatistics.reset();
        numNativeLibMatrixMultCalls.reset();
        numNativeSparseConv2dCalls.reset();
        numNativeSparseConv2dBwdDataCalls.reset();
        numNativeSparseConv2dBwdFilterCalls.reset();
        numNativeConv2dCalls.reset();
        numNativeConv2dBwdDataCalls.reset();
        numNativeConv2dBwdFilterCalls.reset();
        numNativeFailures.reset();
        nativeLibMatrixMultTime = 0L;
        nativeConv2dTime = 0L;
        nativeConv2dBwdFilterTime = 0L;
        nativeConv2dBwdDataTime = 0L;
        LibMatrixDNN.resetStatistics();
        federatedReadCount.reset();
        federatedPutCount.reset();
        federatedGetCount.reset();
        federatedExecuteInstructionCount.reset();
        federatedExecuteUDFCount.reset();
    }

    public static void resetJITCompileTime() {
        jitCompileTime = -1L * Statistics.getJITCompileTime();
    }

    public static void resetJVMgcTime() {
        jvmGCTime = -1L * Statistics.getJVMgcTime();
    }

    public static void resetJVMgcCount() {
        jvmGCTime = -1L * Statistics.getJVMgcCount();
    }

    public static void resetCPHeavyHitters() {
        _instStats.clear();
    }

    public static void setSparkCtxCreateTime(long ns) {
        sparkCtxCreateTime = ns;
    }

    public static void accSparkParallelizeTime(long t) {
        sparkParallelize.add(t);
    }

    public static void incSparkParallelizeCount(long c) {
        sparkParallelizeCount.add(c);
    }

    public static void accSparkCollectTime(long t) {
        sparkCollect.add(t);
    }

    public static void incSparkCollectCount(long c) {
        sparkCollectCount.add(c);
    }

    public static void accSparkBroadCastTime(long t) {
        sparkBroadcast.add(t);
    }

    public static void incSparkBroadcastCount(long c) {
        sparkBroadcastCount.add(c);
    }

    public static void incWorkerNumber() {
        psNumWorkers.increment();
    }

    public static void incWorkerNumber(long n) {
        psNumWorkers.add(n);
    }

    public static void accPSSetupTime(long t) {
        psSetupTime.add(t);
    }

    public static void accPSGradientComputeTime(long t) {
        psGradientComputeTime.add(t);
    }

    public static void accPSAggregationTime(long t) {
        psAggregationTime.add(t);
    }

    public static void accPSLocalModelUpdateTime(long t) {
        psLocalModelUpdateTime.add(t);
    }

    public static void accPSModelBroadcastTime(long t) {
        psModelBroadcastTime.add(t);
    }

    public static void accPSBatchIndexingTime(long t) {
        psBatchIndexTime.add(t);
    }

    public static void accPSRpcRequestTime(long t) {
        psRpcRequestTime.add(t);
    }

    public static String getCPHeavyHitterCode(Instruction inst) {
        String opcode = null;
        if (inst instanceof SPInstruction) {
            opcode = "SP_" + InstructionUtils.getOpCode(inst.toString());
            if (inst instanceof FunctionCallCPInstruction) {
                FunctionCallCPInstruction extfunct = (FunctionCallCPInstruction)inst;
                opcode = extfunct.getFunctionName();
            }
        } else {
            opcode = InstructionUtils.getOpCode(inst.toString());
            if (inst instanceof FunctionCallCPInstruction) {
                FunctionCallCPInstruction extfunct = (FunctionCallCPInstruction)inst;
                opcode = extfunct.getFunctionName();
            }
        }
        return opcode;
    }

    public static void addCPMemObject(int hash, double sizeof) {
        double sizePrev = _currCPMemObjs.getOrDefault(hash, 0.0);
        _currCPMemObjs.put(hash, sizeof);
        sizeofPinnedObjects.add(sizeof - sizePrev);
        Statistics.maintainMemMaxStats();
    }

    private static void maintainMemMaxStats() {
        if (maxSizeofPinnedObjects < sizeofPinnedObjects.doubleValue()) {
            maxSizeofPinnedObjects = sizeofPinnedObjects.doubleValue();
        }
        if (maxNumPinnedObjects < (long)_currCPMemObjs.size()) {
            maxNumPinnedObjects = _currCPMemObjs.size();
        }
    }

    public static void removeCPMemObject(int hash) {
        if (_currCPMemObjs.containsKey(hash)) {
            double sizeof = _currCPMemObjs.remove(hash);
            sizeofPinnedObjects.add(-1.0 * sizeof);
        }
    }

    public static void maintainCPHeavyHittersMem(String name, double sizeof) {
        double prevSize = _cpMemObjs.getOrDefault(name, 0.0);
        if (prevSize < sizeof) {
            _cpMemObjs.put(name, sizeof);
        }
    }

    public static void maintainCPHeavyHitters(String instName, long timeNanos) {
        InstStats tmp = _instStats.get(instName);
        if (tmp == null) {
            InstStats tmp0 = new InstStats();
            InstStats tmp1 = _instStats.putIfAbsent(instName, tmp0);
            tmp = tmp1 != null ? tmp1 : tmp0;
        }
        tmp.time.add(timeNanos);
        tmp.count.increment();
    }

    public static void maintainCPFuncCallStats(String instName) {
        InstStats tmp = _instStats.get(instName);
        if (tmp != null) {
            tmp.count.decrement();
        }
    }

    public static Set<String> getCPHeavyHitterOpCodes() {
        return _instStats.keySet();
    }

    public static long getCPHeavyHitterCount(String opcode) {
        InstStats tmp = _instStats.get(opcode);
        return tmp != null ? tmp.count.longValue() : 0L;
    }

    public static String getHeavyHitters(int num) {
        String timeSString;
        double timeS;
        long timeNs;
        int i;
        int len = _instStats.size();
        if (num <= 0 || len <= 0) {
            return "-";
        }
        Map.Entry[] tmp = _instStats.entrySet().toArray(new Map.Entry[len]);
        Arrays.sort(tmp, new Comparator<Map.Entry<String, InstStats>>(){

            @Override
            public int compare(Map.Entry<String, InstStats> e1, Map.Entry<String, InstStats> e2) {
                return Long.compare(e1.getValue().time.longValue(), e2.getValue().time.longValue());
            }
        });
        String numCol = "#";
        String instCol = "Instruction";
        String timeSCol = "Time(s)";
        String countCol = "Count";
        StringBuilder sb = new StringBuilder();
        int numHittersToDisplay = Math.min(num, len);
        int maxNumLen = String.valueOf(numHittersToDisplay).length();
        int maxInstLen = "Instruction".length();
        int maxTimeSLen = "Time(s)".length();
        int maxCountLen = "Count".length();
        DecimalFormat sFormat = new DecimalFormat("#,##0.000");
        for (i = 0; i < numHittersToDisplay; ++i) {
            Map.Entry hh = tmp[len - 1 - i];
            String instruction = (String)hh.getKey();
            timeNs = ((InstStats)hh.getValue()).time.longValue();
            timeS = (double)timeNs / 1.0E9;
            maxInstLen = Math.max(maxInstLen, instruction.length());
            timeSString = sFormat.format(timeS);
            maxTimeSLen = Math.max(maxTimeSLen, timeSString.length());
            maxCountLen = Math.max(maxCountLen, String.valueOf(((InstStats)hh.getValue()).count.longValue()).length());
        }
        maxInstLen = Math.min(maxInstLen, DMLScript.STATISTICS_MAX_WRAP_LEN);
        sb.append(String.format(" %" + maxNumLen + "s  %-" + maxInstLen + "s  %" + maxTimeSLen + "s  %" + maxCountLen + "s", "#", "Instruction", "Time(s)", "Count"));
        sb.append("\n");
        for (i = 0; i < numHittersToDisplay; ++i) {
            String instruction = (String)tmp[len - 1 - i].getKey();
            String[] wrappedInstruction = Statistics.wrap(instruction, maxInstLen);
            timeNs = ((InstStats)tmp[len - 1 - i].getValue()).time.longValue();
            timeS = (double)timeNs / 1.0E9;
            timeSString = sFormat.format(timeS);
            long count = ((InstStats)tmp[len - 1 - i].getValue()).count.longValue();
            int numLines = wrappedInstruction.length;
            for (int wrapIter = 0; wrapIter < numLines; ++wrapIter) {
                String instStr;
                String string = instStr = wrapIter < wrappedInstruction.length ? wrappedInstruction[wrapIter] : "";
                if (wrapIter == 0) {
                    sb.append(String.format(" %" + maxNumLen + "d  %-" + maxInstLen + "s  %" + maxTimeSLen + "s  %" + maxCountLen + "d", i + 1, instStr, timeSString, count));
                } else {
                    sb.append(String.format(" %" + maxNumLen + "s  %-" + maxInstLen + "s  %" + maxTimeSLen + "s  %" + maxCountLen + "s", "", instStr, "", ""));
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static String getCPHeavyHittersMem(int num) {
        int n = _cpMemObjs.size();
        if (n <= 0 || num <= 0) {
            return "-";
        }
        Map.Entry[] entries = _cpMemObjs.entrySet().toArray(new Map.Entry[_cpMemObjs.size()]);
        Arrays.sort(entries, new Comparator<Map.Entry<String, Double>>(){

            @Override
            public int compare(Map.Entry<String, Double> a, Map.Entry<String, Double> b) {
                return b.getValue().compareTo(a.getValue());
            }
        });
        int numHittersToDisplay = Math.min(num, n);
        int numPadLen = String.format("%d", numHittersToDisplay).length();
        int maxNameLength = 0;
        for (String name : _cpMemObjs.keySet()) {
            maxNameLength = Math.max(name.length(), maxNameLength);
        }
        maxNameLength = Math.max(maxNameLength, "Object".length());
        StringBuilder res = new StringBuilder();
        res.append(String.format("  %-" + numPadLen + "s  %-" + maxNameLength + "s  %s\n", "#", "Object", "Memory"));
        for (int ix = 1; ix <= numHittersToDisplay; ++ix) {
            String objName = (String)entries[ix - 1].getKey();
            String objSize = Statistics.byteCountToDisplaySize((Double)entries[ix - 1].getValue());
            String numStr = String.format("  %-" + numPadLen + "s", ix);
            String objNameStr = String.format("  %-" + maxNameLength + "s ", objName);
            res.append(numStr + objNameStr + String.format("  %s", objSize) + "\n");
        }
        return res.toString();
    }

    private static String byteCountToDisplaySize(double numBytes) {
        if (numBytes < 1024.0) {
            return numBytes + " bytes";
        }
        int exp = (int)(Math.log(numBytes) / 6.931471805599453);
        return String.format("%.3f %sB", numBytes / Math.pow(1024.0, exp), Character.valueOf("KMGTP".charAt(exp - 1)));
    }

    public static long getJITCompileTime() {
        long ret = -1L;
        CompilationMXBean cmx = ManagementFactory.getCompilationMXBean();
        if (cmx.isCompilationTimeMonitoringSupported()) {
            ret = cmx.getTotalCompilationTime();
            ret += jitCompileTime;
        }
        return ret;
    }

    public static long getJVMgcTime() {
        long ret = 0L;
        List<GarbageCollectorMXBean> gcxs = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcx : gcxs) {
            ret += gcx.getCollectionTime();
        }
        if (ret > 0L) {
            ret += jvmGCTime;
        }
        return ret;
    }

    public static long getJVMgcCount() {
        long ret = 0L;
        List<GarbageCollectorMXBean> gcxs = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcx : gcxs) {
            ret += gcx.getCollectionCount();
        }
        if (ret > 0L) {
            ret += jvmGCCount;
        }
        return ret;
    }

    public static long getHopRecompileTime() {
        return hopRecompileTime.longValue();
    }

    public static long getHopRecompiledPredDAGs() {
        return hopRecompilePred.longValue();
    }

    public static long getHopRecompiledSBDAGs() {
        return hopRecompileSB.longValue();
    }

    public static long getFunRecompileTime() {
        return funRecompileTime.longValue();
    }

    public static long getFunRecompiles() {
        return funRecompiles.longValue();
    }

    public static long getParforOptCount() {
        return parforOptCount;
    }

    public static long getParforOptTime() {
        return parforOptTime;
    }

    public static long getParforInitTime() {
        return parforInitTime;
    }

    public static long getParforMergeTime() {
        return parforMergeTime;
    }

    public static long getNumPinnedObjects() {
        return maxNumPinnedObjects;
    }

    public static double getSizeofPinnedObjects() {
        return maxSizeofPinnedObjects;
    }

    public static String display() {
        return Statistics.display(DMLScript.STATISTICS_COUNT);
    }

    private static String[] wrap(String str, int wrapLength) {
        int numLines = (int)Math.ceil((double)str.length() / (double)wrapLength);
        int len = str.length();
        String[] ret = new String[numLines];
        for (int i = 0; i < numLines; ++i) {
            ret[i] = str.substring(i * wrapLength, Math.min((i + 1) * wrapLength, len));
        }
        return ret;
    }

    public static String display(int maxHeavyHitters) {
        StringBuilder sb = new StringBuilder();
        sb.append("SystemDS Statistics:\n");
        if (DMLScript.STATISTICS) {
            sb.append("Total elapsed time:\t\t" + String.format("%.3f", (double)(Statistics.getCompileTime() + Statistics.getRunTime()) * 1.0E-9) + " sec.\n");
            sb.append("Total compilation time:\t\t" + String.format("%.3f", (double)Statistics.getCompileTime() * 1.0E-9) + " sec.\n");
        }
        sb.append("Total execution time:\t\t" + String.format("%.3f", (double)Statistics.getRunTime() * 1.0E-9) + " sec.\n");
        if (OptimizerUtils.isSparkExecutionMode()) {
            if (DMLScript.STATISTICS) {
                sb.append("Number of compiled Spark inst:\t" + Statistics.getNoOfCompiledSPInst() + ".\n");
            }
            sb.append("Number of executed Spark inst:\t" + Statistics.getNoOfExecutedSPInst() + ".\n");
        }
        if (DMLScript.USE_ACCELERATOR && DMLScript.STATISTICS) {
            sb.append(GPUStatistics.getStringForCudaTimers());
        }
        if (DMLScript.STATISTICS) {
            if (NativeHelper.CURRENT_NATIVE_BLAS_STATE == NativeHelper.NativeBlasState.SUCCESSFULLY_LOADED_NATIVE_BLAS_AND_IN_USE) {
                String blas = NativeHelper.getCurrentBLAS();
                sb.append("Native " + blas + " calls (dense mult/conv/bwdF/bwdD):\t" + numNativeLibMatrixMultCalls.longValue() + "/" + numNativeConv2dCalls.longValue() + "/" + numNativeConv2dBwdFilterCalls.longValue() + "/" + numNativeConv2dBwdDataCalls.longValue() + ".\n");
                sb.append("Native " + blas + " calls (sparse conv/bwdF/bwdD):\t" + numNativeSparseConv2dCalls.longValue() + "/" + numNativeSparseConv2dBwdFilterCalls.longValue() + "/" + numNativeSparseConv2dBwdDataCalls.longValue() + ".\n");
                sb.append("Native " + blas + " times (dense mult/conv/bwdF/bwdD):\t" + String.format("%.3f", (double)nativeLibMatrixMultTime * 1.0E-9) + "/" + String.format("%.3f", (double)nativeConv2dTime * 1.0E-9) + "/" + String.format("%.3f", (double)nativeConv2dBwdFilterTime * 1.0E-9) + "/" + String.format("%.3f", (double)nativeConv2dBwdDataTime * 1.0E-9) + ".\n");
            }
            if (recomputeNNZTime != 0L || examSparsityTime != 0L || allocateDoubleArrTime != 0L) {
                sb.append("MatrixBlock times (recomputeNNZ/examSparsity/allocateDoubleArr):\t" + String.format("%.3f", (double)recomputeNNZTime * 1.0E-9) + "/" + String.format("%.3f", (double)examSparsityTime * 1.0E-9) + "/" + String.format("%.3f", (double)allocateDoubleArrTime * 1.0E-9) + ".\n");
            }
            sb.append("Cache hits (Mem, WB, FS, HDFS):\t" + CacheStatistics.displayHits() + ".\n");
            sb.append("Cache writes (WB, FS, HDFS):\t" + CacheStatistics.displayWrites() + ".\n");
            sb.append("Cache times (ACQr/m, RLS, EXP):\t" + CacheStatistics.displayTime() + " sec.\n");
            if (DMLScript.JMLC_MEM_STATISTICS) {
                sb.append("Max size of live objects:\t" + Statistics.byteCountToDisplaySize(Statistics.getSizeofPinnedObjects()) + " (" + Statistics.getNumPinnedObjects() + " total objects)\n");
            }
            sb.append("HOP DAGs recompiled (PRED, SB):\t" + Statistics.getHopRecompiledPredDAGs() + "/" + Statistics.getHopRecompiledSBDAGs() + ".\n");
            sb.append("HOP DAGs recompile time:\t" + String.format("%.3f", (double)Statistics.getHopRecompileTime() / 1.0E9) + " sec.\n");
            if (Statistics.getFunRecompiles() > 0L) {
                sb.append("Functions recompiled:\t\t" + Statistics.getFunRecompiles() + ".\n");
                sb.append("Functions recompile time:\t" + String.format("%.3f", (double)Statistics.getFunRecompileTime() / 1.0E9) + " sec.\n");
            }
            if (DMLScript.LINEAGE && !LineageCacheConfig.ReuseCacheType.isNone()) {
                sb.append("LinCache hits (Mem/FS/Del): \t" + LineageCacheStatistics.displayHits() + ".\n");
                sb.append("LinCache MultiLevel (Ins/SB/Fn):" + LineageCacheStatistics.displayMultiLevelHits() + ".\n");
                sb.append("LinCache writes (Mem/FS/Del): \t" + LineageCacheStatistics.displayWtrites() + ".\n");
                sb.append("LinCache FStimes (Rd/Wr): \t" + LineageCacheStatistics.displayTime() + " sec.\n");
                sb.append("LinCache Rewrites:    \t\t" + LineageCacheStatistics.displayRewrites() + ".\n");
            }
            if (ConfigurationManager.isCodegenEnabled()) {
                sb.append("Codegen compile (DAG,CP,JC):\t" + Statistics.getCodegenDAGCompile() + "/" + Statistics.getCodegenCPlanCompile() + "/" + Statistics.getCodegenClassCompile() + ".\n");
                sb.append("Codegen enum (ALLt/p,EVALt/p):\t" + Statistics.getCodegenEnumAll() + "/" + Statistics.getCodegenEnumAllP() + "/" + Statistics.getCodegenEnumEval() + "/" + Statistics.getCodegenEnumEvalP() + ".\n");
                sb.append("Codegen compile times (DAG,JC):\t" + String.format("%.3f", (double)Statistics.getCodegenCompileTime() / 1.0E9) + "/" + String.format("%.3f", (double)Statistics.getCodegenClassCompileTime() / 1.0E9) + " sec.\n");
                sb.append("Codegen enum plan cache hits:\t" + Statistics.getCodegenPlanCacheHits() + "/" + Statistics.getCodegenPlanCacheTotal() + ".\n");
                sb.append("Codegen op plan cache hits:\t" + Statistics.getCodegenOpCacheHits() + "/" + Statistics.getCodegenOpCacheTotal() + ".\n");
            }
            if (OptimizerUtils.isSparkExecutionMode()) {
                String lazy = SparkExecutionContext.isLazySparkContextCreation() ? "(lazy)" : "(eager)";
                sb.append("Spark ctx create time " + lazy + ":\t" + String.format("%.3f", (double)sparkCtxCreateTime * 1.0E-9) + " sec.\n");
                sb.append("Spark trans counts (par,bc,col):" + String.format("%d/%d/%d.\n", sparkParallelizeCount.longValue(), sparkBroadcastCount.longValue(), sparkCollectCount.longValue()));
                sb.append("Spark trans times (par,bc,col):\t" + String.format("%.3f/%.3f/%.3f secs.\n", (double)sparkParallelize.longValue() * 1.0E-9, (double)sparkBroadcast.longValue() * 1.0E-9, (double)sparkCollect.longValue() * 1.0E-9));
            }
            if (psNumWorkers.longValue() > 0L) {
                sb.append(String.format("Paramserv total num workers:\t%d.\n", psNumWorkers.longValue()));
                sb.append(String.format("Paramserv setup time:\t\t%.3f secs.\n", psSetupTime.doubleValue() / 1000.0));
                sb.append(String.format("Paramserv grad compute time:\t%.3f secs.\n", psGradientComputeTime.doubleValue() / 1000.0));
                sb.append(String.format("Paramserv model update time:\t%.3f/%.3f secs.\n", psLocalModelUpdateTime.doubleValue() / 1000.0, psAggregationTime.doubleValue() / 1000.0));
                sb.append(String.format("Paramserv model broadcast time:\t%.3f secs.\n", psModelBroadcastTime.doubleValue() / 1000.0));
                sb.append(String.format("Paramserv batch slice time:\t%.3f secs.\n", psBatchIndexTime.doubleValue() / 1000.0));
                sb.append(String.format("Paramserv RPC request time:\t%.3f secs.\n", psRpcRequestTime.doubleValue() / 1000.0));
            }
            if (parforOptCount > 0L) {
                sb.append("ParFor loops optimized:\t\t" + Statistics.getParforOptCount() + ".\n");
                sb.append("ParFor optimize time:\t\t" + String.format("%.3f", (double)Statistics.getParforOptTime() / 1000.0) + " sec.\n");
                sb.append("ParFor initialize time:\t\t" + String.format("%.3f", (double)Statistics.getParforInitTime() / 1000.0) + " sec.\n");
                sb.append("ParFor result merge time:\t" + String.format("%.3f", (double)Statistics.getParforMergeTime() / 1000.0) + " sec.\n");
                sb.append("ParFor total update in-place:\t" + lTotalUIPVar + "/" + lTotalLixUIP + "/" + lTotalLix + "\n");
            }
            if (federatedReadCount.longValue() > 0L) {
                sb.append("Federated I/O (Read, Put, Get):\t" + federatedReadCount.longValue() + "/" + federatedPutCount.longValue() + "/" + federatedGetCount.longValue() + ".\n");
                sb.append("Federated Execute (Inst, UDF):\t" + federatedExecuteInstructionCount.longValue() + "/" + federatedExecuteUDFCount.longValue() + ".\n");
            }
            sb.append("Total JIT compile time:\t\t" + (double)Statistics.getJITCompileTime() / 1000.0 + " sec.\n");
            sb.append("Total JVM GC count:\t\t" + Statistics.getJVMgcCount() + ".\n");
            sb.append("Total JVM GC time:\t\t" + (double)Statistics.getJVMgcTime() / 1000.0 + " sec.\n");
            sb.append("Heavy hitter instructions:\n" + Statistics.getHeavyHitters(maxHeavyHitters));
        }
        if (DMLScript.CHECK_PRIVACY) {
            sb.append(CheckedConstraintsLog.display());
        }
        return sb.toString();
    }

    private static class InstStats {
        private final LongAdder time = new LongAdder();
        private final LongAdder count = new LongAdder();

        private InstStats() {
        }
    }
}

