/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.parser.ForStatementBlock;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.DMLScriptException;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.IntObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.lineage.Lineage;
import org.apache.sysds.runtime.lineage.LineageDedupUtils;

public class ForProgramBlock
extends ProgramBlock {
    protected ArrayList<Instruction> _fromInstructions;
    protected ArrayList<Instruction> _toInstructions;
    protected ArrayList<Instruction> _incrementInstructions;
    protected ArrayList<ProgramBlock> _childBlocks = new ArrayList();
    protected final String _iterPredVar;

    public ForProgramBlock(Program prog, String iterPredVar) {
        super(prog);
        this._iterPredVar = iterPredVar;
    }

    public ArrayList<Instruction> getFromInstructions() {
        return this._fromInstructions;
    }

    public void setFromInstructions(ArrayList<Instruction> instructions) {
        this._fromInstructions = instructions;
    }

    public ArrayList<Instruction> getToInstructions() {
        return this._toInstructions;
    }

    public void setToInstructions(ArrayList<Instruction> instructions) {
        this._toInstructions = instructions;
    }

    public ArrayList<Instruction> getIncrementInstructions() {
        return this._incrementInstructions;
    }

    public void setIncrementInstructions(ArrayList<Instruction> instructions) {
        this._incrementInstructions = instructions;
    }

    public void addProgramBlock(ProgramBlock childBlock) {
        this._childBlocks.add(childBlock);
    }

    public void setChildBlocks(ArrayList<ProgramBlock> pbs) {
        this._childBlocks = pbs;
    }

    public String getIterVar() {
        return this._iterPredVar;
    }

    @Override
    public ArrayList<ProgramBlock> getChildBlocks() {
        return this._childBlocks;
    }

    @Override
    public boolean isNested() {
        return true;
    }

    @Override
    public void execute(ExecutionContext ec) {
        IntObject incr;
        IntObject from = this.executePredicateInstructions(1, this._fromInstructions, ec);
        IntObject to = this.executePredicateInstructions(2, this._toInstructions, ec);
        IntObject intObject = this._incrementInstructions == null || this._incrementInstructions.isEmpty() ? new IntObject(from.getLongValue() <= to.getLongValue() ? 1L : -1L) : (incr = this.executePredicateInstructions(3, this._incrementInstructions, ec));
        if (incr.getLongValue() == 0L) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Expression for increment of variable '" + this._iterPredVar + "' must evaluate to a non-zero value.");
        }
        try {
            MatrixObject.UpdateType[] flags = this.prepareUpdateInPlaceVariables(ec, this._tid);
            if (DMLScript.LINEAGE_DEDUP) {
                ec.getLineage().initializeDedupBlock(this, ec);
            }
            SequenceIterator seqIter = new SequenceIterator(from, to, incr);
            for (IntObject iterVar : seqIter) {
                if (DMLScript.LINEAGE_DEDUP) {
                    ec.getLineage().resetDedupPath();
                }
                ec.setVariable(this._iterPredVar, iterVar);
                if (DMLScript.LINEAGE) {
                    Lineage li = ec.getLineage();
                    li.set(this._iterPredVar, li.getOrCreate(new CPOperand(iterVar)));
                }
                if (DMLScript.LINEAGE_DEDUP) {
                    ec.getLineage().createDedupPatch(this, ec);
                }
                for (int i = 0; i < this._childBlocks.size(); ++i) {
                    this._childBlocks.get(i).execute(ec);
                }
                if (!DMLScript.LINEAGE_DEDUP) continue;
                LineageDedupUtils.replaceLineage(ec);
                ec.getLineage().traceCurrentDedupPath(this, ec);
            }
            if (DMLScript.LINEAGE_DEDUP) {
                ec.getLineage().clearDedupBlock();
            }
            this.resetUpdateInPlaceVariableFlags(ec, flags);
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating for program block", e);
        }
        this.executeExitInstructions(this._exitInstruction, "for", ec);
    }

    protected IntObject executePredicateInstructions(int pos, ArrayList<Instruction> instructions, ExecutionContext ec) {
        ScalarObject tmp = null;
        IntObject ret = null;
        try {
            if (this._sb != null) {
                ForStatementBlock fsb = (ForStatementBlock)this._sb;
                Hop predHops = null;
                boolean recompile = false;
                if (pos == 1) {
                    predHops = fsb.getFromHops();
                    recompile = fsb.requiresFromRecompilation();
                } else if (pos == 2) {
                    predHops = fsb.getToHops();
                    recompile = fsb.requiresToRecompilation();
                } else if (pos == 3) {
                    predHops = fsb.getIncrementHops();
                    recompile = fsb.requiresIncrementRecompilation();
                }
                tmp = this.executePredicate(instructions, predHops, recompile, Types.ValueType.INT64, ec);
            } else {
                tmp = this.executePredicate(instructions, null, false, Types.ValueType.INT64, ec);
            }
        }
        catch (Exception ex) {
            String predNameStr = null;
            if (pos == 1) {
                predNameStr = "from";
            } else if (pos == 2) {
                predNameStr = "to";
            } else if (pos == 3) {
                predNameStr = "increment";
            }
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating '" + predNameStr + "' predicate", ex);
        }
        ret = tmp instanceof IntObject ? (IntObject)tmp : new IntObject(tmp.getLongValue());
        return ret;
    }

    @Override
    public String printBlockErrorLocation() {
        return "ERROR: Runtime error in for program block generated from for statement block between lines " + this._beginLine + " and " + this._endLine + " -- ";
    }

    protected class SequenceIterator
    implements Iterator<IntObject>,
    Iterable<IntObject> {
        private long _cur = -1L;
        private long _to = -1L;
        private long _incr = -1L;
        private boolean _inuse = false;

        protected SequenceIterator(IntObject from, IntObject to, IntObject incr) {
            this._cur = from.getLongValue();
            this._to = to.getLongValue();
            this._incr = incr.getLongValue();
        }

        @Override
        public boolean hasNext() {
            return this._incr > 0L ? this._cur <= this._to : this._cur >= this._to;
        }

        @Override
        public IntObject next() {
            IntObject ret = new IntObject(this._cur);
            this._cur += this._incr;
            return ret;
        }

        @Override
        public Iterator<IntObject> iterator() {
            if (this._inuse) {
                throw new RuntimeException("Unsupported reuse of iterator.");
            }
            this._inuse = true;
            return this;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Unsupported remove on iterator.");
        }
    }
}

