/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.conf;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.codegen.SpoofCompiler;
import org.apache.sysds.lops.Compression;
import org.apache.sysds.parser.ParseException;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DMLConfig {
    public static final String DEFAULT_SYSTEMDS_CONFIG_FILEPATH = "./SystemDS-config.xml";
    private static final Log LOG = LogFactory.getLog((String)DMLConfig.class.getName());
    public static final String LOCAL_TMP_DIR = "sysds.localtmpdir";
    public static final String SCRATCH_SPACE = "sysds.scratch";
    public static final String OPTIMIZATION_LEVEL = "sysds.optlevel";
    public static final String DEFAULT_BLOCK_SIZE = "sysds.defaultblocksize";
    public static final String CP_PARALLEL_OPS = "sysds.cp.parallel.ops";
    public static final String CP_PARALLEL_IO = "sysds.cp.parallel.io";
    public static final String COMPRESSED_LINALG = "sysds.compressed.linalg";
    public static final String COMPRESSED_LOSSY = "sysds.compressed.lossy";
    public static final String COMPRESSED_VALID_COMPRESSIONS = "sysds.compressed.valid.compressions";
    public static final String COMPRESSED_OVERLAPPING = "sysds.compressed.overlapping";
    public static final String COMPRESSED_SAMPLING_RATIO = "sysds.compressed.sampling.ratio";
    public static final String COMPRESSED_COCODE = "sysds.compressed.cocode";
    public static final String COMPRESSED_TRANSPOSE = "sysds.compressed.transpose";
    public static final String NATIVE_BLAS = "sysds.native.blas";
    public static final String NATIVE_BLAS_DIR = "sysds.native.blas.directory";
    public static final String CODEGEN = "sysds.codegen.enabled";
    public static final String CODEGEN_API = "sysds.codegen.api";
    public static final String CODEGEN_COMPILER = "sysds.codegen.compiler";
    public static final String CODEGEN_OPTIMIZER = "sysds.codegen.optimizer";
    public static final String CODEGEN_PLANCACHE = "sysds.codegen.plancache";
    public static final String CODEGEN_LITERALS = "sysds.codegen.literals";
    public static final String STATS_MAX_WRAP_LEN = "sysds.stats.maxWrapLength";
    public static final String AVAILABLE_GPUS = "sysds.gpu.availableGPUs";
    public static final String SYNCHRONIZE_GPU = "sysds.gpu.sync.postProcess";
    public static final String EAGER_CUDA_FREE = "sysds.gpu.eager.cudaFree";
    public static final String GPU_EVICTION_POLICY = "sysds.gpu.eviction.policy";
    public static final String LOCAL_SPARK_NUM_THREADS = "sysds.local.spark.number.threads";
    public static final String LINEAGECACHESPILL = "sysds.lineage.cachespill";
    public static final String COMPILERASSISTED_RW = "sysds.lineage.compilerassisted";
    public static final String GPU_MEMORY_UTILIZATION_FACTOR = "sysds.gpu.memory.util.factor";
    public static final String GPU_MEMORY_ALLOCATOR = "sysds.gpu.memory.allocator";
    public static final String FLOATING_POINT_PRECISION = "sysds.floating.point.precision";
    public static final String PRINT_GPU_MEMORY_INFO = "sysds.gpu.print.memoryInfo";
    public static final String EVICTION_SHADOW_BUFFERSIZE = "sysds.gpu.eviction.shadow.bufferSize";
    public static final String USE_SSL_FEDERATED_COMMUNICATION = "sysds.federated.ssl";
    public static final String DEFAULT_FEDERATED_INITIALIZATION_TIMEOUT = "sysds.federated.initialization.timeout";
    public static final int DEFAULT_FEDERATED_PORT = 4040;
    public static final int DEFAULT_NUMBER_OF_FEDERATED_WORKER_THREADS = 2;
    public static final String DEFAULT_SHARED_DIR_PERMISSION = "777";
    private static HashMap<String, String> _defaultVals = null;
    private String _fileName = null;
    private Element _xmlRoot = null;
    private DocumentBuilder _documentBuilder = null;
    private Document _document = null;

    public DMLConfig() {
    }

    public DMLConfig(String fileName) throws FileNotFoundException {
        this(fileName, false);
    }

    public DMLConfig(String fileName, boolean silent) throws FileNotFoundException {
        this._fileName = fileName;
        try {
            this.parseConfig();
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (Exception e) {
            if (!silent) {
                LOG.error((Object)"Failed to parse DML config file ", (Throwable)e);
            }
            throw new ParseException("ERROR: error parsing DMLConfig file " + fileName);
        }
    }

    public DMLConfig(Element root) {
        this._xmlRoot = root;
    }

    public DMLConfig(DMLConfig dmlconf) {
        this.set(dmlconf);
    }

    public void set(DMLConfig dmlconf) {
        this._fileName = dmlconf._fileName;
        this._xmlRoot = dmlconf._xmlRoot;
        this._documentBuilder = dmlconf._documentBuilder;
        this._document = dmlconf._document;
    }

    private void parseConfig() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = this.getDocumentBuilder();
        this._document = null;
        if (this._fileName.startsWith("hdfs:") || this._fileName.startsWith("gpfs:") || IOUtilFunctions.isObjectStoreFileScheme(new Path(this._fileName))) {
            Path configFilePath = new Path(this._fileName);
            try (FileSystem DFS = IOUtilFunctions.getFileSystem(configFilePath);){
                this._document = builder.parse((InputStream)DFS.open(configFilePath));
            }
        } else {
            this._document = builder.parse(this._fileName);
        }
        this._xmlRoot = this._document.getDocumentElement();
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this._documentBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            this._documentBuilder = factory.newDocumentBuilder();
        }
        return this._documentBuilder;
    }

    public String getTextValue(String tagName) {
        String retVal;
        String string = retVal = this._xmlRoot != null ? DMLConfig.getTextValue(this._xmlRoot, tagName) : null;
        if (retVal == null) {
            if (_defaultVals.containsKey(tagName)) {
                retVal = _defaultVals.get(tagName);
            } else {
                LOG.error((Object)("Error: requested dml configuration property '" + tagName + "' is invalid."));
            }
        }
        return retVal;
    }

    public int getIntValue(String tagName) {
        return Integer.parseInt(this.getTextValue(tagName));
    }

    public boolean getBooleanValue(String tagName) {
        return Boolean.parseBoolean(this.getTextValue(tagName));
    }

    public double getDoubleValue(String tagName) {
        return Double.parseDouble(this.getTextValue(tagName));
    }

    private static String getTextValue(Element element, String tagName) {
        String textVal = null;
        NodeList list = element.getElementsByTagName(tagName);
        if (list != null && list.getLength() > 0) {
            Element elem = (Element)list.item(0);
            textVal = elem.getFirstChild().getNodeValue();
        }
        return textVal;
    }

    public void setTextValue(String paramName, String paramValue) {
        if (this._xmlRoot != null) {
            NodeList list = this._xmlRoot.getElementsByTagName(paramName);
            if (list != null && list.getLength() > 0) {
                Element elem = (Element)list.item(0);
                elem.getFirstChild().setNodeValue(paramValue);
            } else {
                Text value = this._document.createTextNode(paramValue);
                Element element = this._document.createElement(paramName);
                element.appendChild(value);
                this._xmlRoot.appendChild(element);
            }
        } else {
            try {
                DocumentBuilder builder = this.getDocumentBuilder();
                String configString = "<root><" + paramName + ">" + paramValue + "</" + paramName + "></root>";
                this._document = builder.parse(new ByteArrayInputStream(configString.getBytes("UTF-8")));
                this._xmlRoot = this._document.getDocumentElement();
            }
            catch (Exception e) {
                throw new DMLRuntimeException("Unable to set config value", e);
            }
        }
    }

    public synchronized String serializeDMLConfig() {
        String ret = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(this._xmlRoot);
            transformer.transform(source, result);
            ret = result.getWriter().toString();
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Unable to serialize DML config.", ex);
        }
        return ret;
    }

    public static DMLConfig parseDMLConfig(String content) {
        DMLConfig ret = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document domTree = null;
            domTree = builder.parse(new ByteArrayInputStream(content.getBytes("utf-8")));
            Element root = domTree.getDocumentElement();
            ret = new DMLConfig(root);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Unable to parse DML config.", ex);
        }
        return ret;
    }

    public static DMLConfig readConfigurationFile(String configPath) throws FileNotFoundException {
        DMLConfig config = new DMLConfig();
        if (configPath != null) {
            try {
                config = new DMLConfig(configPath, false);
            }
            catch (FileNotFoundException fnfe) {
                LOG.error((Object)("Custom config file " + configPath + " not found."));
                throw fnfe;
            }
            catch (ParseException e) {
                throw e;
            }
        }
        try {
            config = new DMLConfig(DEFAULT_SYSTEMDS_CONFIG_FILEPATH, false);
        }
        catch (FileNotFoundException fnfe) {
            LOG.info((Object)"Using internal default configuration settings.  If you wish to customize any settings, please supply a `SystemDS-config.xml` file.");
            config = new DMLConfig();
        }
        catch (ParseException e) {
            throw e;
        }
        return config;
    }

    public String getConfigInfo() {
        String[] tmpConfig = new String[]{LOCAL_TMP_DIR, SCRATCH_SPACE, OPTIMIZATION_LEVEL, DEFAULT_BLOCK_SIZE, CP_PARALLEL_OPS, CP_PARALLEL_IO, NATIVE_BLAS, NATIVE_BLAS_DIR, COMPRESSED_LINALG, COMPRESSED_LOSSY, COMPRESSED_VALID_COMPRESSIONS, COMPRESSED_OVERLAPPING, COMPRESSED_SAMPLING_RATIO, COMPRESSED_COCODE, COMPRESSED_TRANSPOSE, CODEGEN, CODEGEN_API, CODEGEN_COMPILER, CODEGEN_OPTIMIZER, CODEGEN_PLANCACHE, CODEGEN_LITERALS, STATS_MAX_WRAP_LEN, LINEAGECACHESPILL, COMPILERASSISTED_RW, PRINT_GPU_MEMORY_INFO, AVAILABLE_GPUS, SYNCHRONIZE_GPU, EAGER_CUDA_FREE, FLOATING_POINT_PRECISION, GPU_EVICTION_POLICY, LOCAL_SPARK_NUM_THREADS, EVICTION_SHADOW_BUFFERSIZE, GPU_MEMORY_ALLOCATOR, GPU_MEMORY_UTILIZATION_FACTOR, USE_SSL_FEDERATED_COMMUNICATION, DEFAULT_FEDERATED_INITIALIZATION_TIMEOUT};
        StringBuilder sb = new StringBuilder();
        for (String tmp : tmpConfig) {
            sb.append("INFO: ");
            sb.append(tmp);
            sb.append(": ");
            sb.append(this.getTextValue(tmp));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String getDefaultTextValue(String key) {
        return _defaultVals.get(key);
    }

    public DMLConfig clone() {
        DMLConfig conf = new DMLConfig();
        conf._fileName = this._fileName;
        conf._xmlRoot = (Element)this._xmlRoot.cloneNode(true);
        return conf;
    }

    static {
        _defaultVals = new HashMap();
        _defaultVals.put(LOCAL_TMP_DIR, "/tmp/systemds");
        _defaultVals.put(SCRATCH_SPACE, "scratch_space");
        _defaultVals.put(OPTIMIZATION_LEVEL, String.valueOf(OptimizerUtils.DEFAULT_OPTLEVEL.ordinal()));
        _defaultVals.put(DEFAULT_BLOCK_SIZE, String.valueOf(1000));
        _defaultVals.put(CP_PARALLEL_OPS, "true");
        _defaultVals.put(CP_PARALLEL_IO, "true");
        _defaultVals.put(COMPRESSED_LINALG, Compression.CompressConfig.FALSE.name());
        _defaultVals.put(COMPRESSED_LOSSY, "false");
        _defaultVals.put(COMPRESSED_VALID_COMPRESSIONS, "SDC,DDC");
        _defaultVals.put(COMPRESSED_OVERLAPPING, "true");
        _defaultVals.put(COMPRESSED_SAMPLING_RATIO, "NaN");
        _defaultVals.put(COMPRESSED_COCODE, "COST");
        _defaultVals.put(COMPRESSED_TRANSPOSE, "auto");
        _defaultVals.put(CODEGEN, "false");
        _defaultVals.put(CODEGEN_API, SpoofCompiler.GeneratorAPI.JAVA.name());
        _defaultVals.put(CODEGEN_COMPILER, SpoofCompiler.CompilerType.AUTO.name());
        _defaultVals.put(CODEGEN_OPTIMIZER, SpoofCompiler.PlanSelector.FUSE_COST_BASED_V2.name());
        _defaultVals.put(CODEGEN_PLANCACHE, "true");
        _defaultVals.put(CODEGEN_LITERALS, "1");
        _defaultVals.put(NATIVE_BLAS, "none");
        _defaultVals.put(NATIVE_BLAS_DIR, "none");
        _defaultVals.put(LINEAGECACHESPILL, "true");
        _defaultVals.put(COMPILERASSISTED_RW, "true");
        _defaultVals.put(PRINT_GPU_MEMORY_INFO, "false");
        _defaultVals.put(EVICTION_SHADOW_BUFFERSIZE, "0.0");
        _defaultVals.put(STATS_MAX_WRAP_LEN, "30");
        _defaultVals.put(GPU_MEMORY_UTILIZATION_FACTOR, "0.9");
        _defaultVals.put(GPU_MEMORY_ALLOCATOR, "cuda");
        _defaultVals.put(AVAILABLE_GPUS, "-1");
        _defaultVals.put(GPU_EVICTION_POLICY, "min_evict");
        _defaultVals.put(LOCAL_SPARK_NUM_THREADS, "*");
        _defaultVals.put(SYNCHRONIZE_GPU, "false");
        _defaultVals.put(EAGER_CUDA_FREE, "false");
        _defaultVals.put(FLOATING_POINT_PRECISION, "double");
        _defaultVals.put(USE_SSL_FEDERATED_COMMUNICATION, "false");
        _defaultVals.put(DEFAULT_FEDERATED_INITIALIZATION_TIMEOUT, "10");
    }
}

