/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.executor;

import java.net.URL;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.worker.WorkerWatcher;
import org.apache.spark.deploy.worker.WorkerWatcher$;
import org.apache.spark.executor.CoarseGrainedExecutorBackend;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcEnv$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$RetrieveSparkAppConfig$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class CoarseGrainedExecutorBackend$
implements Logging {
    public static final CoarseGrainedExecutorBackend$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CoarseGrainedExecutorBackend$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    private void run(String driverUrl, String executorId, String hostname, int cores, String appId, Option<String> workerUrl, Seq<URL> userClassPath) {
        Utils$.MODULE$.initDaemon(this.log());
        SparkHadoopUtil$.MODULE$.get().runAsSparkUser((Function0<BoxedUnit>)new Serializable(driverUrl, executorId, hostname, cores, appId, workerUrl, userClassPath){
            public static final long serialVersionUID = 0L;
            private final String driverUrl$1;
            private final String executorId$1;
            private final String hostname$1;
            private final int cores$1;
            private final String appId$1;
            private final Option workerUrl$1;
            private final Seq userClassPath$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Utils$.MODULE$.checkHost(this.hostname$1, Utils$.MODULE$.checkHost$default$2());
                SparkConf executorConf = new SparkConf();
                int port = executorConf.getInt("spark.executor.port", 0);
                RpcEnv fetcher = RpcEnv$.MODULE$.create("driverPropsFetcher", this.hostname$1, port, executorConf, new SecurityManager(executorConf, SecurityManager$.MODULE$.$lessinit$greater$default$2()), true);
                RpcEndpointRef driver = fetcher.setupEndpointRefByURI(this.driverUrl$1);
                CoarseGrainedClusterMessages.SparkAppConfig cfg = (CoarseGrainedClusterMessages.SparkAppConfig)driver.askWithRetry(CoarseGrainedClusterMessages$RetrieveSparkAppConfig$.MODULE$, ClassTag$.MODULE$.apply(CoarseGrainedClusterMessages.SparkAppConfig.class));
                Seq props = (Seq)cfg.sparkProperties().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"spark.app.id", (Object)this.appId$1)})), Seq$.MODULE$.canBuildFrom());
                fetcher.shutdown();
                SparkConf driverConf = new SparkConf();
                props.withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                        Tuple2<String, String> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, driverConf){
                    public static final long serialVersionUID = 0L;
                    private final SparkConf driverConf$1;

                    public final SparkConf apply(Tuple2<String, String> x$3) {
                        Tuple2<String, String> tuple2 = x$3;
                        if (tuple2 != null) {
                            String key = (String)tuple2._1();
                            String value2 = (String)tuple2._2();
                            SparkConf sparkConf = SparkConf$.MODULE$.isExecutorStartupConf(key) ? this.driverConf$1.setIfMissing(key, value2) : this.driverConf$1.set(key, value2);
                            return sparkConf;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.driverConf$1 = driverConf$1;
                    }
                });
                if (driverConf.contains("spark.yarn.credentials.file")) {
                    CoarseGrainedExecutorBackend$.MODULE$.logInfo((Function0<String>)new Serializable(this, driverConf){
                        public static final long serialVersionUID = 0L;
                        private final SparkConf driverConf$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Will periodically update credentials from: ").append((Object)this.driverConf$1.get("spark.yarn.credentials.file")).toString();
                        }
                        {
                            this.driverConf$1 = driverConf$1;
                        }
                    });
                    SparkHadoopUtil$.MODULE$.get().startCredentialUpdater(driverConf);
                }
                SparkEnv env = SparkEnv$.MODULE$.createExecutorEnv(driverConf, this.executorId$1, this.hostname$1, port, this.cores$1, cfg.ioEncryptionKey(), false);
                env.rpcEnv().setupEndpoint("Executor", new CoarseGrainedExecutorBackend(env.rpcEnv(), this.driverUrl$1, this.executorId$1, this.hostname$1, this.cores$1, (Seq<URL>)this.userClassPath$1, env));
                this.workerUrl$1.foreach((Function1)new Serializable(this, env){
                    public static final long serialVersionUID = 0L;
                    private final SparkEnv env$1;

                    public final RpcEndpointRef apply(String url) {
                        return this.env$1.rpcEnv().setupEndpoint("WorkerWatcher", new WorkerWatcher(this.env$1.rpcEnv(), url, WorkerWatcher$.MODULE$.$lessinit$greater$default$3()));
                    }
                    {
                        this.env$1 = env$1;
                    }
                });
                env.rpcEnv().awaitTermination();
                SparkHadoopUtil$.MODULE$.get().stopCredentialUpdater();
            }
            {
                this.driverUrl$1 = driverUrl$1;
                this.executorId$1 = executorId$1;
                this.hostname$1 = hostname$1;
                this.cores$1 = cores$1;
                this.appId$1 = appId$1;
                this.workerUrl$1 = workerUrl$1;
                this.userClassPath$1 = userClassPath$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        String driverUrl = null;
        String executorId = null;
        String hostname = null;
        int cores = 0;
        String appId = null;
        None$ workerUrl = None$.MODULE$;
        ListBuffer userClassPath = new ListBuffer();
        List argv = Predef$.MODULE$.refArrayOps((Object[])args).toList();
        while (true) {
            BoxedUnit boxedUnit;
            List list;
            if (argv.isEmpty()) {
                if (driverUrl == null || executorId == null || hostname == null || cores <= 0 || appId == null) {
                    this.printUsageAndExit();
                }
                this.run(driverUrl, executorId, hostname, cores, appId, (Option<String>)workerUrl, (Seq<URL>)userClassPath);
                System.exit(0);
                return;
            }
            boolean bl = false;
            .colon.colon colon2 = null;
            List list2 = list;
            if (list2 instanceof .colon.colon) {
                bl = true;
                colon2 = (.colon.colon)list2;
                String string = (String)colon2.head();
                List list3 = colon2.tl$1();
                if ("--driver-url".equals(string) && list3 instanceof .colon.colon) {
                    .colon.colon colon3 = (.colon.colon)list3;
                    String value2 = (String)colon3.head();
                    List tail = colon3.tl$1();
                    String string2 = value2;
                    list = tail;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list4 = colon2.tl$1();
                if ("--executor-id".equals(string) && list4 instanceof .colon.colon) {
                    .colon.colon colon4 = (.colon.colon)list4;
                    String value3 = (String)colon4.head();
                    List tail = colon4.tl$1();
                    String string3 = value3;
                    list = tail;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list5 = colon2.tl$1();
                if ("--hostname".equals(string) && list5 instanceof .colon.colon) {
                    .colon.colon colon5 = (.colon.colon)list5;
                    String value4 = (String)colon5.head();
                    List tail = colon5.tl$1();
                    String string4 = value4;
                    list = tail;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list6 = colon2.tl$1();
                if ("--cores".equals(string) && list6 instanceof .colon.colon) {
                    .colon.colon colon6 = (.colon.colon)list6;
                    String value5 = (String)colon6.head();
                    List tail = colon6.tl$1();
                    int n = new StringOps(Predef$.MODULE$.augmentString(value5)).toInt();
                    list = tail;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list7 = colon2.tl$1();
                if ("--app-id".equals(string) && list7 instanceof .colon.colon) {
                    .colon.colon colon7 = (.colon.colon)list7;
                    String value6 = (String)colon7.head();
                    List tail = colon7.tl$1();
                    String string5 = value6;
                    list = tail;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list8 = colon2.tl$1();
                if ("--worker-url".equals(string) && list8 instanceof .colon.colon) {
                    .colon.colon colon8 = (.colon.colon)list8;
                    String value7 = (String)colon8.head();
                    List tail = colon8.tl$1();
                    Some some = new Some((Object)value7);
                    list = tail;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list9 = colon2.tl$1();
                if ("--user-class-path".equals(string) && list9 instanceof .colon.colon) {
                    void var8_8;
                    .colon.colon colon9 = (.colon.colon)list9;
                    String value8 = (String)colon9.head();
                    List tail = colon9.tl$1();
                    var8_8.$plus$eq((Object)new URL(value8));
                    list = tail;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (Nil$.MODULE$.equals(list2)) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unrecognized options: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{list2.mkString(" ")})));
            this.printUsageAndExit();
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void printUsageAndExit() {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("\n      |Usage: CoarseGrainedExecutorBackend [options]\n      |\n      | Options are:\n      |   --driver-url <driverUrl>\n      |   --executor-id <executorId>\n      |   --hostname <hostname>\n      |   --cores <cores>\n      |   --app-id <appid>\n      |   --worker-url <workerUrl>\n      |   --user-class-path <url>\n      |")).stripMargin());
        System.exit(1);
    }

    private CoarseGrainedExecutorBackend$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

