/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlockDataInput;

public class ByteBufferDataInput
implements DataInput,
MatrixBlockDataInput {
    protected final ByteBuffer _buff;

    public ByteBufferDataInput(ByteBuffer buff) {
        this._buff = buff;
    }

    public int available() {
        return this._buff.limit() - this._buff.position();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this._buff.get(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this._buff.get(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this._buff.position(this._buff.position() + n);
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return (this._buff.get() & 0xFF) != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)(this._buff.get() & 0xFF);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public short readShort() throws IOException {
        return this._buff.getShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this._buff.getChar();
    }

    @Override
    public char readChar() throws IOException {
        return this._buff.getChar();
    }

    @Override
    public int readInt() throws IOException {
        return this._buff.getInt();
    }

    @Override
    public long readLong() throws IOException {
        return this._buff.getLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this._buff.getFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this._buff.getDouble();
    }

    @Override
    public String readLine() throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public long readDoubleArray(int len, double[] varr) throws IOException {
        long nnz = 0L;
        for (int i = 0; i < len; ++i) {
            varr[i] = this._buff.getDouble();
            nnz += varr[i] != 0.0 ? 1L : 0L;
        }
        return nnz;
    }

    @Override
    public long readSparseRows(int rlen, long nnz, SparseBlock rows) throws IOException {
        long gnnz = 0L;
        for (int i = 0; i < rlen; ++i) {
            int lnnz = this._buff.getInt();
            if (lnnz <= 0) continue;
            rows.allocate(i, lnnz);
            for (int j = 0; j < lnnz; ++j) {
                rows.append(i, this._buff.getInt(), this._buff.getDouble());
            }
            gnnz += (long)lnnz;
        }
        if (gnnz != nnz) {
            throw new IOException("Invalid number of read nnz: " + gnnz + " vs " + nnz);
        }
        return nnz;
    }
}

