/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.io;

import java.lang.reflect.Constructor;
import org.apache.spark.SparkConf;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.LZ4CompressionCodec;
import org.apache.spark.io.LZFCompressionCodec;
import org.apache.spark.io.SnappyCompressionCodec;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;

public final class CompressionCodec$ {
    public static final CompressionCodec$ MODULE$;
    private final String org$apache$spark$io$CompressionCodec$$configKey;
    private final Map<String, String> shortCompressionCodecNames;
    private final String FALLBACK_COMPRESSION_CODEC;
    private final String DEFAULT_COMPRESSION_CODEC;
    private final Seq<String> ALL_COMPRESSION_CODECS;

    static {
        new CompressionCodec$();
    }

    public String org$apache$spark$io$CompressionCodec$$configKey() {
        return this.org$apache$spark$io$CompressionCodec$$configKey;
    }

    public boolean supportsConcatenationOfSerializedStreams(CompressionCodec codec) {
        return codec instanceof SnappyCompressionCodec || codec instanceof LZFCompressionCodec || codec instanceof LZ4CompressionCodec;
    }

    private Map<String, String> shortCompressionCodecNames() {
        return this.shortCompressionCodecNames;
    }

    public String getCodecName(SparkConf conf) {
        return conf.get(this.org$apache$spark$io$CompressionCodec$$configKey(), this.DEFAULT_COMPRESSION_CODEC());
    }

    public CompressionCodec createCodec(SparkConf conf) {
        return this.createCodec(conf, this.getCodecName(conf));
    }

    public CompressionCodec createCodec(SparkConf conf, String codecName) {
        None$ none$;
        String codecClass = (String)this.shortCompressionCodecNames().getOrElse((Object)codecName.toLowerCase(), (Function0)new Serializable(codecName){
            public static final long serialVersionUID = 0L;
            private final String codecName$2;

            public final String apply() {
                return this.codecName$2;
            }
            {
                this.codecName$2 = codecName$2;
            }
        });
        try {
            Constructor<?> ctor = Utils$.MODULE$.classForName(codecClass).getConstructor(SparkConf.class);
            none$ = new Some((Object)((CompressionCodec)ctor.newInstance(conf)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            none$ = None$.MODULE$;
        }
        catch (ClassNotFoundException classNotFoundException) {
            none$ = None$.MODULE$;
        }
        None$ codec = none$;
        return (CompressionCodec)codec.getOrElse((Function0)new Serializable(codecName){
            public static final long serialVersionUID = 0L;
            private final String codecName$2;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Codec [", "] is not available. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.codecName$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consider setting ", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CompressionCodec$.MODULE$.org$apache$spark$io$CompressionCodec$$configKey(), CompressionCodec$.MODULE$.FALLBACK_COMPRESSION_CODEC()}))).toString());
            }
            {
                this.codecName$2 = codecName$2;
            }
        });
    }

    public String getShortName(String codecName) {
        return this.shortCompressionCodecNames().contains((Object)codecName) ? codecName : (String)this.shortCompressionCodecNames().collectFirst((PartialFunction)new Serializable(codecName){
            public static final long serialVersionUID = 0L;
            private final String codecName$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String v;
                    String k = (String)A1._1();
                    String string = v = (String)A1._2();
                    String string2 = this.codecName$1;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        object = k;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<String, String> x1) {
                String v;
                Tuple2<String, String> tuple2 = x1;
                if (tuple2 == null) return false;
                String string = v = (String)tuple2._2();
                String string2 = this.codecName$1;
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
            {
                this.codecName$1 = codecName$1;
            }
        }).getOrElse((Function0)new Serializable(codecName){
            public static final long serialVersionUID = 0L;
            private final String codecName$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No short name for codec ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.codecName$1})));
            }
            {
                this.codecName$1 = codecName$1;
            }
        });
    }

    public String FALLBACK_COMPRESSION_CODEC() {
        return this.FALLBACK_COMPRESSION_CODEC;
    }

    public String DEFAULT_COMPRESSION_CODEC() {
        return this.DEFAULT_COMPRESSION_CODEC;
    }

    public Seq<String> ALL_COMPRESSION_CODECS() {
        return this.ALL_COMPRESSION_CODECS;
    }

    private CompressionCodec$() {
        MODULE$ = this;
        this.org$apache$spark$io$CompressionCodec$$configKey = "spark.io.compression.codec";
        this.shortCompressionCodecNames = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lz4"), (Object)LZ4CompressionCodec.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lzf"), (Object)LZFCompressionCodec.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"snappy"), (Object)SnappyCompressionCodec.class.getName())}));
        this.FALLBACK_COMPRESSION_CODEC = "snappy";
        this.DEFAULT_COMPRESSION_CODEC = "lz4";
        this.ALL_COMPRESSION_CODECS = this.shortCompressionCodecNames().values().toSeq();
    }
}

