/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.bitmap.Bitmap;
import org.apache.sysds.runtime.compress.bitmap.MultiColBitmap;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.QDictionary;
import org.apache.sysds.runtime.compress.utils.DArrCounts;
import org.apache.sysds.runtime.compress.utils.DblArrayCountHashMap;
import org.apache.sysds.runtime.compress.utils.DoubleCountHashMap;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public interface DictionaryFactory {
    public static final Log LOG = LogFactory.getLog((String)DictionaryFactory.class.getName());

    public static ADictionary read(DataInput in) throws IOException {
        Type type = Type.values()[in.readByte()];
        switch (type) {
            case FP64_DICT: {
                return Dictionary.read(in);
            }
            case MATRIX_BLOCK_DICT: {
                return MatrixBlockDictionary.read(in);
            }
            case INT8_DICT: {
                return QDictionary.read(in);
            }
        }
        throw new DMLCompressionException("Unsupported type of dictionary : " + type);
    }

    public static long getInMemorySize(int nrValues, int nrColumns, double tupleSparsity, boolean lossy) {
        if (lossy) {
            return QDictionary.getInMemorySize(nrValues * nrColumns);
        }
        if (nrColumns > 1 && tupleSparsity < 0.4) {
            return MatrixBlockDictionary.getInMemorySize(nrValues, nrColumns, tupleSparsity);
        }
        return Dictionary.getInMemorySize(nrValues * nrColumns);
    }

    public static ADictionary create(DblArrayCountHashMap map, int nCols, boolean addZeroTuple, double sparsity) {
        try {
            ArrayList<DArrCounts> vals = map.extractValues();
            int nVals = vals.size();
            int nTuplesOut = nVals + (addZeroTuple ? 1 : 0);
            if (sparsity < 0.4) {
                MatrixBlock retB = new MatrixBlock(nTuplesOut, nCols, true);
                retB.allocateSparseRowsBlock();
                SparseBlock sb = retB.getSparseBlock();
                for (int i = 0; i < nVals; ++i) {
                    DArrCounts dac = vals.get(i);
                    double[] dv = dac.key.getData();
                    for (int k = 0; k < dv.length; ++k) {
                        sb.append(dac.id, k, dv[k]);
                    }
                }
                retB.recomputeNonZeros();
                retB.examSparsity(true);
                return new MatrixBlockDictionary(retB, nCols);
            }
            double[] resValues = new double[nTuplesOut * nCols];
            for (int i = 0; i < nVals; ++i) {
                DArrCounts dac = vals.get(i);
                System.arraycopy(dac.key.getData(), 0, resValues, dac.id * nCols, nCols);
            }
            return new Dictionary(resValues);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to create dictionary: ", (Throwable)e);
            return null;
        }
    }

    public static ADictionary create(ABitmap ubm) {
        return DictionaryFactory.create(ubm, 1.0);
    }

    public static ADictionary create(ABitmap ubm, double sparsity, boolean withZeroTuple) {
        return withZeroTuple ? DictionaryFactory.createWithAppendedZeroTuple(ubm, sparsity) : DictionaryFactory.create(ubm, sparsity);
    }

    public static ADictionary create(ABitmap ubm, double sparsity) {
        int nCol = ubm.getNumColumns();
        if (ubm instanceof Bitmap) {
            return new Dictionary(((Bitmap)ubm).getValues());
        }
        if (sparsity < 0.4 && nCol > 4 && ubm instanceof MultiColBitmap) {
            MultiColBitmap mcbm = (MultiColBitmap)ubm;
            MatrixBlock m = new MatrixBlock(ubm.getNumValues(), nCol, true);
            m.allocateSparseRowsBlock();
            SparseBlock sb = m.getSparseBlock();
            int nVals = ubm.getNumValues();
            for (int i = 0; i < nVals; ++i) {
                double[] tuple = mcbm.getValues(i);
                for (int col = 0; col < nCol; ++col) {
                    sb.append(i, col, tuple[col]);
                }
            }
            m.recomputeNonZeros();
            m.examSparsity(true);
            return new MatrixBlockDictionary(m, nCol);
        }
        if (ubm instanceof MultiColBitmap) {
            MultiColBitmap mcbm = (MultiColBitmap)ubm;
            int nVals = ubm.getNumValues();
            double[] resValues = new double[nVals * nCol];
            for (int i = 0; i < nVals; ++i) {
                System.arraycopy(mcbm.getValues(i), 0, resValues, i * nCol, nCol);
            }
            return new Dictionary(resValues);
        }
        throw new NotImplementedException("Not implemented creation of bitmap type : " + ubm.getClass().getSimpleName());
    }

    public static ADictionary create(ABitmap ubm, int defaultIndex, double[] defaultTuple, double sparsity, boolean addZero) {
        int nCol = ubm.getNumColumns();
        int nVal = ubm.getNumValues() - (addZero ? 0 : 1);
        if (nCol > 4 && sparsity < 0.4) {
            int col;
            double[] tuple;
            int i;
            MultiColBitmap mcbm = (MultiColBitmap)ubm;
            MatrixBlock m = new MatrixBlock(nVal, nCol, true);
            m.allocateSparseRowsBlock();
            SparseBlock sb = m.getSparseBlock();
            for (i = 0; i < defaultIndex; ++i) {
                tuple = mcbm.getValues(i);
                for (col = 0; col < nCol; ++col) {
                    sb.append(i, col, tuple[col]);
                }
            }
            System.arraycopy(mcbm.getValues(defaultIndex), 0, defaultTuple, 0, nCol);
            for (i = defaultIndex; i < ubm.getNumValues() - 1; ++i) {
                tuple = mcbm.getValues(i);
                for (col = 0; col < nCol; ++col) {
                    sb.append(i, col, tuple[col]);
                }
            }
            m.recomputeNonZeros();
            m.examSparsity(true);
            return new MatrixBlockDictionary(m, nCol);
        }
        double[] dict = new double[nCol * nVal];
        if (ubm instanceof Bitmap) {
            double[] bmv = ((Bitmap)ubm).getValues();
            System.arraycopy(bmv, 0, dict, 0, defaultIndex);
            defaultTuple[0] = bmv[defaultIndex];
            System.arraycopy(bmv, defaultIndex + 1, dict, defaultIndex, bmv.length - defaultIndex - 1);
        } else if (ubm instanceof MultiColBitmap) {
            int i;
            MultiColBitmap mcbm = (MultiColBitmap)ubm;
            for (i = 0; i < defaultIndex; ++i) {
                System.arraycopy(mcbm.getValues(i), 0, dict, i * nCol, nCol);
            }
            System.arraycopy(mcbm.getValues(defaultIndex), 0, defaultTuple, 0, nCol);
            for (i = defaultIndex; i < ubm.getNumValues() - 1; ++i) {
                System.arraycopy(mcbm.getValues(i + 1), 0, dict, i * nCol, nCol);
            }
        } else {
            throw new NotImplementedException("not supported ABitmap of type:" + ubm.getClass().getSimpleName());
        }
        return new Dictionary(dict);
    }

    public static ADictionary createWithAppendedZeroTuple(ABitmap ubm, double sparsity) {
        int nVals = ubm.getNumValues();
        int nRows = nVals + 1;
        int nCols = ubm.getNumColumns();
        if (ubm instanceof Bitmap) {
            double[] resValues = new double[nRows];
            double[] from = ((Bitmap)ubm).getValues();
            System.arraycopy(from, 0, resValues, 0, from.length);
            return new Dictionary(resValues);
        }
        MultiColBitmap mcbm = (MultiColBitmap)ubm;
        if (sparsity < 0.4 && nCols > 4) {
            MatrixBlock m = new MatrixBlock(nRows, nCols, true);
            m.allocateSparseRowsBlock();
            SparseBlock sb = m.getSparseBlock();
            for (int i = 0; i < nVals; ++i) {
                double[] tuple = mcbm.getValues(i);
                for (int col = 0; col < nCols; ++col) {
                    sb.append(i, col, tuple[col]);
                }
            }
            m.recomputeNonZeros();
            m.examSparsity(true);
            return new MatrixBlockDictionary(m, nCols);
        }
        double[] resValues = new double[nRows * nCols];
        for (int i = 0; i < nVals; ++i) {
            System.arraycopy(mcbm.getValues(i), 0, resValues, i * nCols, nCols);
        }
        return new Dictionary(resValues);
    }

    public static ADictionary create(DoubleCountHashMap map) {
        double[] resValues = map.getDictionary();
        return new Dictionary(resValues);
    }

    public static enum Type {
        FP64_DICT,
        MATRIX_BLOCK_DICT,
        INT8_DICT;

    }
}

