/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import java.util.ArrayList;
import java.util.Comparator;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public class DoubleIntListHashMap {
    protected static final int INIT_CAPACITY = 8;
    protected static final int RESIZE_FACTOR = 2;
    protected static final float LOAD_FACTOR = 0.5f;
    protected int _size = -1;
    private DIListEntry[] _data = null;
    public static int hashMissCount = 0;

    public DoubleIntListHashMap() {
        this._data = new DIListEntry[8];
        this._size = 0;
    }

    public DoubleIntListHashMap(int init_capacity) {
        this._data = new DIListEntry[init_capacity];
        this._size = 0;
    }

    public int size() {
        return this._size;
    }

    public IntArrayList get(double key) {
        if (this._size == 0) {
            return null;
        }
        int hash = DoubleIntListHashMap.hash(key);
        return this.getHash(key, hash);
    }

    private IntArrayList getHash(double key, int hash) {
        int ix = DoubleIntListHashMap.indexFor(hash, this._data.length);
        return this.getHashIndex(key, ix);
    }

    private IntArrayList getHashIndex(double key, int ix) {
        DIListEntry e = this._data[ix];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    private void appendValue(double key, IntArrayList value) {
        int hash = DoubleIntListHashMap.hash(key);
        int ix = DoubleIntListHashMap.indexFor(hash, this._data.length);
        DIListEntry enew = new DIListEntry(key, value);
        enew.next = this._data[ix];
        this._data[ix] = enew;
        if (enew.next != null && enew.next.key == key) {
            enew.next = enew.next.next;
            --this._size;
        }
        ++this._size;
        if ((float)this._size >= 0.5f * (float)this._data.length) {
            this.resize();
        }
    }

    public void appendValue(double key, int value) {
        if (key == 0.0) {
            return;
        }
        int hash = DoubleIntListHashMap.hash(key);
        int ix = DoubleIntListHashMap.indexFor(hash, this._data.length);
        IntArrayList lstPtr = null;
        if (this._data[ix] == null) {
            lstPtr = new IntArrayList();
            this._data[ix] = new DIListEntry(key, lstPtr);
            ++this._size;
        } else {
            DIListEntry e = this._data[ix];
            while (e != null) {
                if (e.key == key) {
                    lstPtr = e.value;
                    break;
                }
                if (e.next == null) {
                    lstPtr = new IntArrayList();
                    DIListEntry eOld = this._data[ix];
                    this._data[ix] = new DIListEntry(key, lstPtr);
                    this._data[ix].next = eOld;
                    ++this._size;
                    break;
                }
                e = e.next;
            }
        }
        lstPtr.appendValue(value);
        if ((float)this._size >= 0.5f * (float)this._data.length) {
            this.resize();
        }
    }

    public ArrayList<DIListEntry> extractValues() {
        ArrayList<DIListEntry> ret = new ArrayList<DIListEntry>();
        for (DIListEntry e : this._data) {
            if (e == null) continue;
            while (e.next != null) {
                ret.add(e);
                e = e.next;
            }
            ret.add(e);
        }
        return ret;
    }

    private void resize() {
        if (this._data.length > 0x3FFFFFFF) {
            return;
        }
        DIListEntry[] olddata = this._data;
        this._data = new DIListEntry[this._data.length * 2];
        this._size = 0;
        for (DIListEntry e : olddata) {
            if (e == null) continue;
            while (e.next != null) {
                this.appendValue(e.key, e.value);
                e = e.next;
            }
            this.appendValue(e.key, e.value);
        }
    }

    private static int hash(double key) {
        long bits = Double.doubleToRawLongBits(key);
        int h = (int)(bits ^ bits >>> 32);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + this.hashCode());
        for (int i = 0; i < this._data.length; ++i) {
            if (this._data[i] == null) continue;
            sb.append(", " + this._data[i]);
        }
        return sb.toString();
    }

    public static class DIListEntry
    implements Comparator<DIListEntry>,
    Comparable<DIListEntry> {
        public double key = Double.MAX_VALUE;
        public IntArrayList value = null;
        public DIListEntry next = null;

        public DIListEntry(double ekey, IntArrayList evalue) {
            this.key = ekey;
            this.value = evalue;
            this.next = null;
        }

        @Override
        public int compareTo(DIListEntry o) {
            return this.compare(this, o);
        }

        @Override
        public int compare(DIListEntry arg0, DIListEntry arg1) {
            return Double.compare(arg0.key, arg1.key);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[" + this.key + ", ");
            sb.append(this.value + ", ");
            sb.append(this.next + "]");
            return sb.toString();
        }
    }
}

