/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring.repositories;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.BaseModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.CoordinatorModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.DataObjectModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.EventModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.EventStageModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.HeavyHitterModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.RequestModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.TrafficModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.UtilizationModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.WorkerModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.repositories.IRepository;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.services.MapperService;

public class DerbyRepository
implements IRepository {
    private static final String DB_CONNECTION = "jdbc:derby:memory:derbyDB";
    private final List<BaseModel> _allEntities = new ArrayList<HeavyHitterModel>(List.of(new WorkerModel(), new CoordinatorModel(), new UtilizationModel(), new TrafficModel(), new EventModel(), new EventStageModel(), new DataObjectModel(), new RequestModel(), new HeavyHitterModel()));
    private static final String ENTITY_SCHEMA_CREATE_STMT = "CREATE TABLE %s (id INTEGER PRIMARY KEY GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1)";
    private static final String ENTITY_INSERT_STMT = "INSERT INTO %s VALUES %s";
    private static final String GET_ENTITY_WITH_COL_STMT = "SELECT * FROM %s WHERE %s = ?";
    private static final String GET_ENTITY_WITH_COL_LIMIT_STMT = "SELECT * FROM %s WHERE %s = ? ORDER BY ID DESC FETCH FIRST %d ROWS ONLY";
    private static final String DELETE_ENTITY_WITH_COL_STMT = "DELETE FROM %s WHERE %s = ?";
    private static final String UPDATE_ENTITY_WITH_COL_STMT = "UPDATE %s SET %s WHERE %s = ?";
    private static final String GET_ALL_ENTITIES_STMT = "SELECT * FROM %s";

    public DerbyRepository() {
        this.createMonitoringDatabase();
    }

    private void createMonitoringDatabase() {
        Connection db = null;
        try {
            db = DriverManager.getConnection("jdbc:derby:memory:derbyDB;create=true");
            this.createMonitoringEntitiesInDB(db);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void createMonitoringEntitiesInDB(Connection db) {
        try {
            DatabaseMetaData dbMetaData = db.getMetaData();
            for (BaseModel entity : this._allEntities) {
                Field[] fields;
                String entityName = entity.getClass().getSimpleName().replace("Model", "");
                ResultSet entityExist = dbMetaData.getTables(null, null, entityName.toUpperCase(), null);
                if (entityExist.next()) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(String.format(ENTITY_SCHEMA_CREATE_STMT, entityName));
                for (Field field : fields = entity.getClass().getFields()) {
                    if (field.getName().equalsIgnoreCase("id")) continue;
                    if (field.getType().isAssignableFrom(String.class)) {
                        sb.append(String.format(",%s %s", field.getName(), "VARCHAR(5000)"));
                        continue;
                    }
                    if (field.getType().isAssignableFrom(Double.TYPE)) {
                        sb.append(String.format(",%s %s", field.getName(), "DOUBLE"));
                        continue;
                    }
                    if (field.getType().isAssignableFrom(Long.class) || field.getType().isAssignableFrom(Integer.TYPE)) {
                        sb.append(String.format(",%s %s", field.getName(), "INTEGER"));
                        continue;
                    }
                    if (!field.getType().isAssignableFrom(LocalDateTime.class)) continue;
                    sb.append(String.format(",%s %s", field.getName(), "TIMESTAMP"));
                }
                sb.append(")");
                PreparedStatement st = db.prepareStatement(sb.toString());
                st.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends BaseModel> Long createEntity(T model) {
        PreparedStatement st = null;
        long id = -1L;
        try (Connection db = DriverManager.getConnection(DB_CONNECTION);){
            StringBuilder sb = new StringBuilder();
            String entityName = model.getClass().getSimpleName().replace("Model", "");
            sb.append(String.format("%s (", entityName));
            Field[] fields = model.getClass().getFields();
            int dbFieldCount = 0;
            for (Field field : fields) {
                if (field.getName().equalsIgnoreCase("id") || !field.getType().isAssignableFrom(String.class) && !field.getType().isAssignableFrom(Double.TYPE) && !field.getType().isAssignableFrom(Long.class) && !field.getType().isAssignableFrom(Integer.TYPE) && !field.getType().isAssignableFrom(LocalDateTime.class)) continue;
                sb.append(String.format("%s,", field.getName()));
                ++dbFieldCount;
            }
            sb.replace(sb.length() - 1, sb.length(), ")");
            String bindVarsStr = String.format("(%s)", String.join((CharSequence)",", Collections.nCopies(dbFieldCount, "?")));
            st = db.prepareStatement(String.format(ENTITY_INSERT_STMT, sb, bindVarsStr), 1);
            int bindVarIndex = 1;
            for (Field field : fields) {
                if (field.getName().equalsIgnoreCase("id")) continue;
                if (field.getType().isAssignableFrom(String.class)) {
                    st.setString(bindVarIndex, String.valueOf(field.get(model)));
                    ++bindVarIndex;
                    continue;
                }
                if (field.getType().isAssignableFrom(Double.TYPE)) {
                    st.setDouble(bindVarIndex, (Double)field.get(model));
                    ++bindVarIndex;
                    continue;
                }
                if (field.getType().isAssignableFrom(Long.class) || field.getType().isAssignableFrom(Integer.TYPE)) {
                    st.setLong(bindVarIndex, (Long)field.get(model));
                    ++bindVarIndex;
                    continue;
                }
                if (!field.getType().isAssignableFrom(LocalDateTime.class)) continue;
                st.setTimestamp(bindVarIndex, Timestamp.valueOf((LocalDateTime)field.get(model)));
                ++bindVarIndex;
            }
            st.executeUpdate();
            ResultSet rs = st.getGeneratedKeys();
            if (rs.next()) {
                id = rs.getLong(1);
            }
        }
        catch (IllegalAccessException | SQLException e) {
            throw new RuntimeException(e);
        }
        return id;
    }

    @Override
    public <T extends BaseModel> T getEntity(Long id, Class<T> type) {
        T resultModel = null;
        PreparedStatement st = null;
        try (Connection db = DriverManager.getConnection(DB_CONNECTION);){
            String entityName = type.getSimpleName().replace("Model", "");
            st = db.prepareStatement(String.format(GET_ENTITY_WITH_COL_STMT, entityName, "id"));
            st.setLong(1, id);
            ResultSet resultSet = st.executeQuery();
            if (resultSet.next()) {
                resultModel = MapperService.mapResultToModel(resultSet, type);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return resultModel;
    }

    @Override
    public <T extends BaseModel> List<T> getAllEntities(Class<T> type) {
        ArrayList<T> resultModels = new ArrayList<T>();
        PreparedStatement st = null;
        try (Connection db = DriverManager.getConnection(DB_CONNECTION);){
            String entityName = type.getSimpleName().replace("Model", "");
            st = db.prepareStatement(String.format(GET_ALL_ENTITIES_STMT, entityName));
            ResultSet resultSet = st.executeQuery();
            while (resultSet.next()) {
                resultModels.add(MapperService.mapResultToModel(resultSet, type));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return resultModels;
    }

    @Override
    public <T extends BaseModel> List<T> getAllEntitiesByField(String fieldName, Object value, Class<T> type) {
        return this.getAllEntitiesByField(fieldName, value, type, -1);
    }

    @Override
    public <T extends BaseModel> List<T> getAllEntitiesByField(String fieldName, Object value, Class<T> type, int rowCount) {
        ArrayList<T> resultModels = new ArrayList<T>();
        PreparedStatement st = null;
        try (Connection db = DriverManager.getConnection(DB_CONNECTION);){
            String entityName = type.getSimpleName().replace("Model", "");
            st = rowCount < 0 ? db.prepareStatement(String.format(GET_ENTITY_WITH_COL_STMT, entityName, fieldName)) : db.prepareStatement(String.format(GET_ENTITY_WITH_COL_LIMIT_STMT, entityName, fieldName, rowCount));
            if (value.getClass().isAssignableFrom(String.class)) {
                st.setString(1, String.valueOf(value));
            } else if (value.getClass().isAssignableFrom(Long.class)) {
                st.setLong(1, Long.parseLong(String.valueOf(value)));
            }
            ResultSet resultSet = st.executeQuery();
            while (resultSet.next()) {
                resultModels.add(MapperService.mapResultToModel(resultSet, type));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return resultModels;
    }

    @Override
    public <T extends BaseModel> void removeAllEntitiesByField(String fieldName, Object value, Class<T> type) {
        PreparedStatement st = null;
        try (Connection db = DriverManager.getConnection(DB_CONNECTION);){
            String entityName = type.getSimpleName().replace("Model", "");
            st = db.prepareStatement(String.format(DELETE_ENTITY_WITH_COL_STMT, entityName, fieldName));
            if (value.getClass().isAssignableFrom(String.class)) {
                st.setString(1, String.valueOf(value));
            } else if (value.getClass().isAssignableFrom(Long.class)) {
                st.setLong(1, Long.parseLong(String.valueOf(value)));
            }
            st.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends BaseModel> void updateEntity(T model) {
        PreparedStatement st = null;
        try (Connection db = DriverManager.getConnection(DB_CONNECTION);){
            StringBuilder sb = new StringBuilder();
            String entityName = model.getClass().getSimpleName().replace("Model", "");
            Field[] fields = model.getClass().getFields();
            ArrayList<Field> fieldsToChange = new ArrayList<Field>();
            for (Field field : fields) {
                if (field.getName().equalsIgnoreCase("id") || !field.getType().isAssignableFrom(String.class) && !field.getType().isAssignableFrom(Double.TYPE) && !field.getType().isAssignableFrom(Long.class) && !field.getType().isAssignableFrom(Integer.TYPE) && !field.getType().isAssignableFrom(LocalDateTime.class) || field.get(model) == null) continue;
                sb.append(String.format("%s = ?,", field.getName()));
                fieldsToChange.add(field);
            }
            sb.replace(sb.length() - 1, sb.length(), "");
            st = db.prepareStatement(String.format(UPDATE_ENTITY_WITH_COL_STMT, entityName, sb, "id"));
            for (int i = 0; i < fieldsToChange.size(); ++i) {
                Field field = (Field)fieldsToChange.get(i);
                if (field.getType().isAssignableFrom(String.class)) {
                    st.setString(i + 1, String.valueOf(field.get(model)));
                    continue;
                }
                if (field.getType().isAssignableFrom(Double.TYPE)) {
                    st.setDouble(i + 1, (Double)field.get(model));
                    continue;
                }
                if (field.getType().isAssignableFrom(Long.class) || field.getType().isAssignableFrom(Integer.TYPE)) {
                    st.setLong(i + 1, (Long)field.get(model));
                    continue;
                }
                if (!field.getType().isAssignableFrom(LocalDateTime.class)) continue;
                st.setTimestamp(i + 1, Timestamp.valueOf((LocalDateTime)field.get(model)));
            }
            st.setLong(fieldsToChange.size() + 1, model.id);
            st.executeUpdate();
        }
        catch (IllegalAccessException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends BaseModel> void removeEntity(Long id, Class<T> type) {
        PreparedStatement st = null;
        try (Connection db = DriverManager.getConnection(DB_CONNECTION);){
            String entityName = type.getSimpleName().replace("Model", "");
            st = db.prepareStatement(String.format(DELETE_ENTITY_WITH_COL_STMT, entityName, "id"));
            st.setLong(1, id);
            st.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

