/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.concurrent.Future;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.controlprogram.federated.MatrixLineagePair;
import org.apache.sysds.runtime.functionobjects.OffsetColumnIndex;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.AppendCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.spark.AppendSPInstruction;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.ReorgOperator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataUtils;

public class AppendFEDInstruction
extends BinaryFEDInstruction {
    protected boolean _cbind;

    protected AppendFEDInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, boolean cbind, String opcode, String istr) {
        super(FEDInstruction.FEDType.Append, op, in1, in2, out, opcode, istr);
        this._cbind = cbind;
    }

    protected AppendFEDInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, boolean cbind, String opcode, String istr, FEDInstruction.FederatedOutput fedOut) {
        super(FEDInstruction.FEDType.Append, op, in1, in2, out, opcode, istr, fedOut);
        this._cbind = cbind;
    }

    public static AppendFEDInstruction parseInstruction(AppendCPInstruction instr) {
        return new AppendFEDInstruction(instr.getOperator(), instr.input1, instr.input2, instr.output, instr.getAppendType().equals((Object)AppendCPInstruction.AppendType.CBIND), instr.getOpcode(), instr.getInstructionString(), FEDInstruction.FederatedOutput.NONE);
    }

    public static AppendFEDInstruction parseInstruction(AppendSPInstruction instr) {
        return new AppendFEDInstruction(instr.getOperator(), instr.input1, instr.input2, instr.output, instr.getCBind(), instr.getOpcode(), instr.getInstructionString(), FEDInstruction.FederatedOutput.NONE);
    }

    public static AppendFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 7, 6, 5);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand out = new CPOperand(parts[parts.length - 3]);
        boolean cbind = Boolean.parseBoolean(parts[parts.length - 2]);
        FEDInstruction.FederatedOutput fedOut = FEDInstruction.FederatedOutput.valueOf(parts[parts.length - 1]);
        ReorgOperator op = new ReorgOperator(OffsetColumnIndex.getOffsetColumnIndexFnObject(-1));
        return new AppendFEDInstruction(op, in1, in2, out, cbind, opcode, str, fedOut);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void processInstruction(ExecutionContext ec) {
        String string;
        MatrixLineagePair mo1 = ec.getMatrixLineagePair(this.input1);
        MatrixLineagePair mo2 = ec.getMatrixLineagePair(this.input2);
        DataCharacteristics dc1 = mo1.getDataCharacteristics();
        DataCharacteristics dc2 = mo2.getDataCharacteristics();
        if (this._cbind && mo1.getNumRows() != mo2.getNumRows()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Append-cbind is not possible for federated input matrices ");
            sb.append(this.input1.getName()).append(" and ").append(this.input2.getName());
            sb.append(" with different number of rows: ");
            sb.append(mo1.getNumRows()).append(" vs ").append(mo2.getNumRows());
            throw new DMLRuntimeException(sb.toString());
        }
        if (!this._cbind && mo1.getNumColumns() != mo2.getNumColumns()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Append-rbind is not possible for federated input matrices ");
            sb.append(this.input1.getName()).append(" and ").append(this.input2.getName());
            sb.append(" with different number of columns: ");
            sb.append(mo1.getNumColumns()).append(" vs ").append(mo2.getNumColumns());
            throw new DMLRuntimeException(sb.toString());
        }
        MatrixObject out = ec.getMatrixObject(this.output);
        MetaDataUtils.updateAppendDataCharacteristics(dc1, dc2, out.getDataCharacteristics(), this._cbind);
        if (mo1.isFederated(FTypes.FType.ROW) && mo2.isFederated(FTypes.FType.ROW) && this._cbind || mo1.isFederated(FTypes.FType.COL) && mo2.isFederated(FTypes.FType.COL) && !this._cbind) {
            FTypes.AlignType[] alignTypeArray = new FTypes.AlignType[1];
            FTypes.AlignType alignType = alignTypeArray[0] = mo1.isFederated(FTypes.FType.ROW) ? FTypes.AlignType.ROW : FTypes.AlignType.COL;
            if (mo1.getFedMapping().isAligned(mo2.getFedMapping(), alignTypeArray)) {
                boolean isSpark = this.instString.contains("SPARK");
                FederatedRequest fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2}, new long[]{mo1.getFedMapping().getID(), mo2.getFedMapping().getID()});
                if (isSpark) {
                    FederatedRequest frTmp = new FederatedRequest(FederatedRequest.RequestType.PUT_VAR, fr2.getID(), new Object[]{new MatrixCharacteristics(-1L, -1L), mo1.getDataType()});
                    mo1.getFedMapping().execute(this.getTID(), true, frTmp, fr2);
                } else {
                    mo1.getFedMapping().execute(this.getTID(), true, fr2);
                }
                int dim = this._cbind ? 1 : 0;
                FederationMap newFedMap = mo1.getFedMapping().copyWithNewID(fr2.getID()).modifyFedRanges(mo1.getDim(dim) + mo2.getDim(dim), dim);
                out.setFedMapping(newFedMap);
                return;
            }
        }
        if ((mo1.isFederated(FTypes.FType.ROW) || mo2.isFederated(FTypes.FType.ROW)) && !this._cbind || (mo1.isFederated(FTypes.FType.COL) || mo2.isFederated(FTypes.FType.COL)) && this._cbind) {
            long id = FederationUtils.getNextFedDataID();
            long roff = this._cbind ? 0L : dc1.getRows();
            long coff = this._cbind ? dc1.getCols() : 0L;
            boolean isFed1 = mo1.isFederated(this._cbind ? FTypes.FType.COL : FTypes.FType.ROW);
            boolean isFed2 = mo2.isFederated(this._cbind ? FTypes.FType.COL : FTypes.FType.ROW);
            FederationMap fed1 = isFed1 ? mo1.getFedMapping() : FederationUtils.federateLocalData(mo1.getMO());
            FederationMap fed2 = isFed2 ? mo2.getFedMapping() : FederationUtils.federateLocalData(mo2.getMO());
            out.setFedMapping(fed1.identCopy(this.getTID(), id).bind(roff, coff, fed2.identCopy(this.getTID(), id)));
            return;
        }
        if ((mo1.isFederated(FTypes.FType.ROW) || mo2.isFederated(FTypes.FType.ROW)) && this._cbind || (mo1.isFederated(FTypes.FType.COL) || mo2.isFederated(FTypes.FType.COL)) && !this._cbind) {
            long[] lArray;
            boolean isFed1 = mo1.isFederated(this._cbind ? FTypes.FType.ROW : FTypes.FType.COL);
            boolean isSpark = this.instString.contains("SPARK");
            MatrixLineagePair moFed = isFed1 ? mo1 : mo2;
            MatrixLineagePair moLoc = isFed1 ? mo2 : mo1;
            FederatedRequest[] fr1 = moFed.getFedMapping().broadcastSliced(moLoc, false);
            CPOperand[] cPOperandArray = new CPOperand[]{this.input1, this.input2};
            if (isFed1) {
                long[] lArray2 = new long[2];
                lArray2[0] = moFed.getFedMapping().getID();
                lArray = lArray2;
                lArray2[1] = fr1[0].getID();
            } else {
                long[] lArray3 = new long[2];
                lArray3[0] = fr1[0].getID();
                lArray = lArray3;
                lArray3[1] = moFed.getFedMapping().getID();
            }
            FederatedRequest fr2 = FederationUtils.callInstruction(this.instString, this.output, cPOperandArray, lArray);
            Future<FederatedResponse>[] ret = null;
            if (isSpark) {
                FederatedRequest tmp = new FederatedRequest(FederatedRequest.RequestType.PUT_VAR, fr2.getID(), new Object[]{new MatrixCharacteristics(-1L, -1L), mo1.getDataType()});
                ret = moFed.getFedMapping().execute(this.getTID(), true, fr1, new FederatedRequest[]{tmp, fr2});
            } else {
                ret = moFed.getFedMapping().execute(this.getTID(), true, fr1, new FederatedRequest[]{fr2});
            }
            int dim = this._cbind ? 1 : 0;
            FederationMap newFedMap = moFed.getFedMapping().copyWithNewID(fr2.getID()).modifyFedRanges(moFed.getDim(dim) + moLoc.getDim(dim), dim);
            out.setFedMapping(newFedMap);
            out.getDataCharacteristics().setNonZeros(FederationUtils.sumNonZeros(ret));
            return;
        }
        String string2 = mo1.isFederated() ? mo1.getFedMapping().getType().name() : "LOCAL";
        if (mo2.isFederated()) {
            string = mo2.getFedMapping().getType().name();
            throw new DMLRuntimeException("Unsupported federated append:  input 1 FType is " + string2 + ", input 2 FType is " + string + ", and column bind is " + this._cbind);
        }
        string = "LOCAL";
        throw new DMLRuntimeException("Unsupported federated append:  input 1 FType is " + string2 + ", input 2 FType is " + string + ", and column bind is " + this._cbind);
    }
}

