/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark.utils;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;

public class FrameRDDAggregateUtils {
    public static JavaPairRDD<Long, FrameBlock> mergeByKey(JavaPairRDD<Long, FrameBlock> in) {
        return in.combineByKey((Function)new CreateBlockCombinerFunction(), (Function2)new MergeBlocksFunction(false), (Function2)new MergeBlocksFunction(false));
    }

    private static class MergeBlocksFunction
    implements Function2<FrameBlock, FrameBlock, FrameBlock> {
        private static final long serialVersionUID = 7807210434431147007L;
        private boolean _deep = false;

        public MergeBlocksFunction(boolean deep) {
            this._deep = deep;
        }

        public FrameBlock call(FrameBlock b1, FrameBlock b2) throws Exception {
            if (b1.getNumRows() != b2.getNumRows() || b1.getNumColumns() != b2.getNumColumns()) {
                throw new DMLRuntimeException("Mismatched frame block sizes for: " + b1.getNumRows() + " " + b1.getNumColumns() + " " + b2.getNumRows() + " " + b2.getNumColumns());
            }
            FrameBlock ret = this._deep ? new FrameBlock(b1) : b1;
            ret.merge(b2);
            return ret;
        }
    }

    private static class CreateBlockCombinerFunction
    implements Function<FrameBlock, FrameBlock> {
        private static final long serialVersionUID = -4445167244905540494L;

        private CreateBlockCombinerFunction() {
        }

        public FrameBlock call(FrameBlock arg0) throws Exception {
            return new FrameBlock(arg0);
        }
    }
}

