/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.caching;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.LinkedList;

public class PageCache {
    private static final int CLEANUP_THRESHOLD = 128;
    private static HashMap<Integer, LinkedList<SoftReference<byte[]>>> _pool;

    public static void init() {
        _pool = new HashMap();
    }

    public static void clear() {
        _pool = null;
    }

    public static void putPage(byte[] data) {
        LinkedList<SoftReference<Object>> list;
        if (_pool.size() > 128) {
            _pool.clear();
        }
        if ((list = _pool.get(data.length)) == null) {
            list = new LinkedList();
            _pool.put(data.length, list);
        }
        list.addLast(new SoftReference<byte[]>(data));
    }

    public static byte[] getPage(int size) {
        LinkedList<SoftReference<byte[]>> list = _pool.get(size);
        if (list != null) {
            while (!list.isEmpty()) {
                SoftReference<byte[]> ref = list.removeFirst();
                byte[] tmp = ref.get();
                if (tmp == null) continue;
                return tmp;
            }
        }
        return null;
    }
}

