/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.api;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sysds.api.DMLException;
import org.apache.sysds.api.DMLOptions;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.api.jmlc.Connection;
import py4j.DefaultGatewayServerListener;
import py4j.GatewayServer;
import py4j.GatewayServerListener;
import py4j.Py4JNetworkException;

public class PythonDMLScript {
    private static final Log LOG = LogFactory.getLog((String)PythonDMLScript.class.getName());
    private final Connection _connection = new Connection();
    public static GatewayServer GwS;

    public static void main(String[] args) throws Exception {
        DMLOptions dmlOptions = DMLOptions.parseCLArguments(args);
        DMLScript.loadConfiguration(dmlOptions.configFile);
        GwS = new GatewayServer((Object)new PythonDMLScript(), dmlOptions.pythonPort);
        GwS.addListener((GatewayServerListener)new DMLGateWayListener());
        try {
            GwS.start();
        }
        catch (Py4JNetworkException p4e) {
            LOG.info((Object)"failed startup", (Throwable)p4e);
            System.exit(-1);
        }
        catch (Exception e) {
            throw new DMLException("Failed startup and maintaining Python gateway", e);
        }
    }

    private PythonDMLScript() {
    }

    public static void setDMLGateWayListenerLoggerLevel(Level l) {
        Logger.getLogger(DMLGateWayListener.class).setLevel(l);
    }

    public Connection getConnection() {
        return this._connection;
    }

    protected static class DMLGateWayListener
    extends DefaultGatewayServerListener {
        private static final Log LOG = LogFactory.getLog((String)DMLGateWayListener.class.getName());

        protected DMLGateWayListener() {
        }

        public void serverPostShutdown() {
            LOG.info((Object)"Shutdown done");
        }

        public void serverPreShutdown() {
            LOG.info((Object)"Starting JVM shutdown");
        }

        public void serverStarted() {
            LOG.info((Object)"GatewayServer started");
        }

        public void serverStopped() {
            LOG.info((Object)"GatewayServer stopped");
        }
    }
}

