/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.scheme;

import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.ASDC;
import org.apache.sysds.runtime.compress.colgroup.ASDCZero;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCFOR;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.scheme.ACLAScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.SDCSchemeMC;
import org.apache.sysds.runtime.compress.colgroup.scheme.SDCSchemeSC;

public abstract class SDCScheme
extends ACLAScheme {
    protected IDictionary lastDict;

    protected SDCScheme(IColIndex cols) {
        super(cols);
    }

    public static SDCScheme create(ASDC g) {
        if (g instanceof ColGroupSDCFOR) {
            throw new NotImplementedException();
        }
        if (g.getColIndices().size() == 1) {
            return new SDCSchemeSC(g);
        }
        return new SDCSchemeMC(g);
    }

    public static SDCScheme create(ASDCZero g) {
        if (g.getColIndices().size() == 1) {
            return new SDCSchemeSC(g);
        }
        return new SDCSchemeMC(g);
    }

    protected abstract Object getDef();

    protected abstract Object getMap();

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("\nCols: ");
        sb.append(this.cols);
        sb.append("\nDef:  ");
        sb.append(this.getDef());
        sb.append("\nMap:  ");
        sb.append(this.getMap());
        return sb.toString();
    }
}

