/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlockCSR;
import org.apache.sysds.runtime.data.SparseBlockMCSR;
import org.apache.sysds.runtime.data.SparseRowVector;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.UtilFunctions;

public interface LibMatrixDenseToSparse {
    public static final Log LOG = LogFactory.getLog((String)LibMatrixDenseToSparse.class.getName());

    public static void denseToSparse(MatrixBlock r, boolean allowCSR) {
        LibMatrixDenseToSparse.denseToSparse(r, allowCSR, 1);
    }

    public static void denseToSparse(MatrixBlock r, boolean allowCSR, int k) {
        DenseBlock a = r.getDenseBlock();
        if (r.nonZeros < 0L) {
            r.recomputeNonZeros(k);
        }
        r.sparse = true;
        if (a == null) {
            return;
        }
        if (k > 1 && (long)r.rlen * (long)r.clen > 100000L && r.nonZeros > 1000L) {
            LibMatrixDenseToSparse.denseToSparseParallel(r, k, allowCSR);
        } else if (allowCSR && r.nonZeros <= Integer.MAX_VALUE) {
            LibMatrixDenseToSparse.denseToSparseCSRSafe(r);
        } else {
            LibMatrixDenseToSparse.denseToSparseMCSR(r);
        }
        r.denseBlock = null;
    }

    private static void denseToSparseCSRSafe(MatrixBlock r) {
        try {
            if (r.getNumRows() == 1) {
                LibMatrixDenseToSparse.denseToSparseCSRSingleRow(r);
            } else {
                LibMatrixDenseToSparse.denseToSparseCSR(r);
            }
        }
        catch (ArrayIndexOutOfBoundsException ioobe) {
            LOG.warn((Object)"Incorrect nnz count in matrix therefore recounting in denseToSparse");
            r.sparse = false;
            r.recomputeNonZeros();
            LibMatrixDenseToSparse.denseToSparse(r, true);
        }
    }

    private static void denseToSparseCSRSingleRow(MatrixBlock r) {
        DenseBlock a = r.getDenseBlock();
        int n = r.clen;
        int lnnz = (int)r.nonZeros;
        int[] indexes = new int[lnnz];
        double[] values = new double[lnnz];
        double[] avals = a.values(0);
        LibMatrixDenseToSparse.addColCSR(avals, n, 0, indexes, values, 0);
        int[] rptr = new int[2];
        rptr[1] = lnnz;
        r.sparseBlock = new SparseBlockCSR(rptr, indexes, values, lnnz);
    }

    private static void denseToSparseCSR(MatrixBlock r) {
        DenseBlock a = r.getDenseBlock();
        int m = r.rlen;
        int n = r.clen;
        int lnnz = (int)r.nonZeros;
        int[] rptr = new int[m + 1];
        int[] indexes = new int[lnnz];
        double[] values = new double[lnnz];
        int pos = 0;
        for (int i = 0; i < m; ++i) {
            double[] avals = a.values(i);
            int aix = a.pos(i);
            rptr[i + 1] = pos = LibMatrixDenseToSparse.addColCSR(avals, n, aix, indexes, values, pos);
        }
        r.sparseBlock = new SparseBlockCSR(rptr, indexes, values, lnnz);
    }

    private static int addColCSR(double[] avals, int n, int aix, int[] indexes, double[] values, int pos) {
        for (int j = 0; j < n; ++j) {
            double aval = avals[aix + j];
            if (aval == 0.0) continue;
            indexes[pos] = j;
            values[pos] = aval;
            ++pos;
        }
        return pos;
    }

    private static void denseToSparseMCSR(MatrixBlock r) {
        DenseBlock a = r.getDenseBlock();
        int m = r.rlen;
        int n = r.clen;
        long nnzTemp = r.getNonZeros();
        if (!r.allocateSparseRowsBlock()) {
            r.reset();
        }
        SparseBlockMCSR sblock = (SparseBlockMCSR)r.sparseBlock;
        LibMatrixDenseToSparse.toSparseMCSRRangeScan(a, sblock, n, 0, m);
        r.nonZeros = nnzTemp;
    }

    private static void toSparseMCSRRangeNoScan(DenseBlock a, SparseBlockMCSR b, int n, int rl, int ru, int est) {
        for (int i = rl; i < ru; ++i) {
            LibMatrixDenseToSparse.toSparseMCSRRowNoScan(a, b, n, i, est);
        }
    }

    private static void toSparseMCSRRangeScan(DenseBlock a, SparseBlockMCSR b, int n, int rl, int ru) {
        for (int i = rl; i < ru; ++i) {
            LibMatrixDenseToSparse.toSparseMCSRRowScan(a, b, n, i);
        }
    }

    private static void toSparseMCSRRowScan(DenseBlock a, SparseBlockMCSR b, int n, int i) {
        int aix;
        double[] avals = a.values(i);
        int lnnz = UtilFunctions.computeNnz(avals, aix = a.pos(i), n);
        if (lnnz <= 0) {
            return;
        }
        SparseRowVector sb = LibMatrixDenseToSparse.toSparseMCSRRowKnownNNZ(avals, aix, n, i, lnnz);
        b.set(i, sb, false);
    }

    private static void toSparseMCSRRowNoScan(DenseBlock a, SparseBlockMCSR b, int n, int i, int est) {
        double[] avals = a.values(i);
        int aix = a.pos(i);
        SparseRowVector sb = new SparseRowVector(est / 2);
        LibMatrixDenseToSparse.toSparseMCSRRowUnknownNNZ(avals, aix, n, i, sb);
        b.set(i, sb, false);
    }

    private static SparseRowVector toSparseMCSRRowKnownNNZ(double[] avals, int aix, int n, int i, int lnnz) {
        double[] vals = new double[lnnz];
        int[] idx = new int[lnnz];
        int o = 0;
        for (int j = 0; j < n; ++j) {
            double v = avals[aix + j];
            if (v == 0.0) continue;
            vals[o] = v;
            idx[o] = j;
            ++o;
        }
        return new SparseRowVector(vals, idx);
    }

    private static void toSparseMCSRRowUnknownNNZ(double[] avals, int aix, int n, int i, SparseRowVector sb) {
        for (int j = 0; j < n; ++j) {
            sb.append(j, avals[aix++]);
        }
        sb.compact();
    }

    private static void denseToSparseParallel(MatrixBlock r, int k, boolean allowCSR) {
        DenseBlock a = r.getDenseBlock();
        ExecutorService pool = CommonThreadPool.get(k);
        try {
            r.denseBlock = null;
            r.sparseBlock = null;
            int m = r.rlen;
            int n = r.clen;
            long nnzTemp = r.getNonZeros();
            double sp = r.getSparsity();
            r.reset(r.getNumRows(), r.getNumColumns(), nnzTemp);
            r.sparseBlock = new SparseBlockMCSR(r.getNumRows());
            r.sparse = true;
            SparseBlockMCSR b = (SparseBlockMCSR)r.sparseBlock;
            int blockSize = Math.max(1, m / k);
            int est = Math.max(1, (int)((double)n * sp));
            ArrayList tasks = new ArrayList();
            for (int i = 0; i < m; i += blockSize) {
                int n2 = i;
                int end = Math.min(m, i + blockSize);
                if (sp < 0.03) {
                    tasks.add(pool.submit(() -> LibMatrixDenseToSparse.toSparseMCSRRangeNoScan(a, b, n, start, end, est)));
                    continue;
                }
                tasks.add(pool.submit(() -> LibMatrixDenseToSparse.toSparseMCSRRangeScan(a, b, n, start, end)));
            }
            r.nonZeros = nnzTemp;
            for (Future future : tasks) {
                future.get();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            pool.shutdown();
        }
    }
}

