/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.MarkupWriterListener;
import org.apache.tapestry5.dom.DefaultMarkupModel;
import org.apache.tapestry5.dom.Document;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.dom.MarkupModel;
import org.apache.tapestry5.dom.Text;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public class MarkupWriterImpl
implements MarkupWriter {
    private final Document document;
    private Element current;
    private Text currentText;
    private List<MarkupWriterListener> listeners;

    public MarkupWriterImpl() {
        this(new DefaultMarkupModel());
    }

    public MarkupWriterImpl(MarkupModel model) {
        this(model, null, null);
    }

    public MarkupWriterImpl(MarkupModel model, String encoding, String mimeType) {
        this.document = new Document(model, encoding, mimeType);
    }

    @Override
    public void toMarkup(PrintWriter writer) {
        this.document.toMarkup(writer);
    }

    public String toString() {
        return this.document.toString();
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public Element getElement() {
        return this.current;
    }

    @Override
    public void cdata(String content) {
        this.currentText = null;
        if (this.current == null) {
            this.document.cdata(content);
        } else {
            this.current.cdata(content);
        }
    }

    @Override
    public void write(String text) {
        if (text == null) {
            return;
        }
        if (this.currentText == null) {
            this.currentText = this.current == null ? this.document.text(text) : this.current.text(text);
            return;
        }
        this.currentText.write(text);
    }

    @Override
    public void writef(String format, Object ... args) {
        this.write("");
        this.currentText.writef(format, args);
    }

    @Override
    public void attributes(Object ... namesAndValues) {
        this.ensureCurrentElement();
        int i = 0;
        int length = namesAndValues.length;
        if (length % 2 != 0) {
            throw new IllegalArgumentException(String.format("Writing attributes of the element '%s' failed. An attribute name or value is omitted [%s]. Please provide an even number of values, alternating names and values.", this.current.getName(), InternalUtils.join(Arrays.asList(namesAndValues))));
        }
        while (i < length) {
            Object value;
            String name = namesAndValues[i++].toString();
            if ((value = namesAndValues[i++]) == null) continue;
            this.current.attribute(name, value.toString());
        }
    }

    private void ensureCurrentElement() {
        if (this.current == null) {
            throw new IllegalStateException("This markup writer does not have a current element. The current element is established with the first call to element() and is maintained across subsequent calls.");
        }
    }

    @Override
    public Element element(String name, Object ... namesAndValues) {
        if (this.current == null) {
            Element existingRootElement = this.document.getRootElement();
            if (existingRootElement != null) {
                throw new IllegalStateException(String.format("A document must have exactly one root element. Element <%s> is already the root element.", existingRootElement.getName()));
            }
            this.current = this.document.newRootElement(name);
        } else {
            this.current = this.current.element(name, new String[0]);
        }
        this.attributes(namesAndValues);
        this.currentText = null;
        this.fireElementDidStart();
        return this.current;
    }

    @Override
    public void writeRaw(String text) {
        this.currentText = null;
        if (this.current == null) {
            this.document.raw(text);
        } else {
            this.current.raw(text);
        }
    }

    @Override
    public Element end() {
        this.ensureCurrentElement();
        this.fireElementDidEnd();
        this.current = this.current.getContainer();
        this.currentText = null;
        return this.current;
    }

    @Override
    public void comment(String text) {
        this.currentText = null;
        if (this.current == null) {
            this.document.comment(text);
        } else {
            this.current.comment(text);
        }
    }

    @Override
    public Element attributeNS(String namespace, String attributeName, String attributeValue) {
        this.ensureCurrentElement();
        this.current.attribute(namespace, attributeName, attributeValue);
        return this.current;
    }

    @Override
    public Element defineNamespace(String namespace, String namespacePrefix) {
        this.ensureCurrentElement();
        this.current.defineNamespace(namespace, namespacePrefix);
        return this.current;
    }

    @Override
    public Element elementNS(String namespace, String elementName) {
        this.current = this.current == null ? this.document.newRootElement(namespace, elementName) : this.current.elementNS(namespace, elementName);
        this.currentText = null;
        this.fireElementDidStart();
        return this.current;
    }

    @Override
    public void addListener(MarkupWriterListener listener) {
        assert (listener != null);
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<MarkupWriterListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(MarkupWriterListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireElementDidStart() {
        if (MarkupWriterImpl.isEmpty(this.listeners)) {
            return;
        }
        for (MarkupWriterListener l : this.listeners) {
            l.elementDidStart(this.current);
        }
    }

    private static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    private void fireElementDidEnd() {
        if (MarkupWriterImpl.isEmpty(this.listeners)) {
            return;
        }
        for (MarkupWriterListener l : this.listeners) {
            l.elementDidEnd(this.current);
        }
    }
}

