/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.rest.jackson.modules;

import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import java.util.List;
import org.apache.tapestry5.commons.MappedConfiguration;
import org.apache.tapestry5.commons.OrderedConfiguration;
import org.apache.tapestry5.http.services.HttpRequestBodyConverter;
import org.apache.tapestry5.http.services.Response;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.ChainBuilder;
import org.apache.tapestry5.jacksondatabind.services.ObjectMapperSource;
import org.apache.tapestry5.rest.jackson.internal.FallbackObjectMapperSource;
import org.apache.tapestry5.rest.jackson.internal.JacksonComponentEventResultProcessor;
import org.apache.tapestry5.rest.jackson.internal.JacksonHttpRequestBodyConverter;
import org.apache.tapestry5.rest.jackson.internal.JacksonOpenApiTypeDescriber;
import org.apache.tapestry5.services.ComponentEventResultProcessor;
import org.apache.tapestry5.services.rest.MappedEntityManager;
import org.apache.tapestry5.services.rest.OpenApiTypeDescriber;

public class RestJacksonModule {
    public static void contributeObjectMapperSource(OrderedConfiguration<ObjectMapperSource> configuration) {
        configuration.addInstance("Fallback", FallbackObjectMapperSource.class, new String[]{"after:*"});
    }

    public static void contributeComponentEventResultProcessor(MappedConfiguration<Class, ComponentEventResultProcessor> configuration, MappedEntityManager mappedEntityManager, Response response, ObjectMapperSource objectMapperSource, @Symbol(value="tapestry.charset") String outputEncoding) {
        for (Class entityClass : mappedEntityManager.getEntities()) {
            configuration.add((Object)entityClass, new JacksonComponentEventResultProcessor(entityClass, response, outputEncoding, objectMapperSource));
        }
    }

    public static void contributeHttpRequestBodyConverter(OrderedConfiguration<HttpRequestBodyConverter> configuration) {
        configuration.addInstance("Jackson", JacksonHttpRequestBodyConverter.class, new String[0]);
    }

    public static ObjectMapperSource buildObjectMapperSource(List<ObjectMapperSource> configuration, ChainBuilder chainBuilder) {
        return (ObjectMapperSource)chainBuilder.build(ObjectMapperSource.class, configuration);
    }

    public static SchemaGenerator buildSchemaGenerator() {
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2019_09, OptionPreset.PLAIN_JSON);
        SchemaGeneratorConfig config = configBuilder.build();
        return new SchemaGenerator(config);
    }

    public static void contributeOpenApiTypeDescriber(OrderedConfiguration<OpenApiTypeDescriber> configuration) {
        configuration.addInstance("Jackson", JacksonOpenApiTypeDescriber.class, new String[0]);
    }
}

