/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5;

import java.util.Collections;
import java.util.List;
import org.apache.tapestry5.commons.util.CollectionFactory;

public class MarkupUtils {
    static final char APOS = '\'';
    static final char QUOTE = '\"';
    static final char SLASH = '\\';

    public static String quote(String text) {
        StringBuilder result = new StringBuilder(text.length() * 2);
        result.append('\'');
        for (char ch : text.toCharArray()) {
            switch (ch) {
                case '\"': 
                case '\'': 
                case '\\': {
                    result.append('\\');
                }
            }
            result.append(ch);
        }
        result.append('\'');
        return result.toString();
    }

    public static String join(String ... values) {
        List list = CollectionFactory.newList((Object[])values);
        return MarkupUtils.sortAndJoin(list);
    }

    public static String join(List<String> values) {
        List copy = CollectionFactory.newList(values);
        return MarkupUtils.sortAndJoin(copy);
    }

    static String sortAndJoin(List<String> list) {
        Collections.sort(list);
        StringBuilder builder = new StringBuilder(10 * list.size());
        String sep = "";
        for (String name : list) {
            builder.append(sep);
            builder.append(name);
            sep = " ";
        }
        return builder.toString();
    }
}

