/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.tapestry5.internal.jpa.PersistenceContextSpecificEntityTransactionManager;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.annotations.Scope;
import org.apache.tapestry5.jpa.EntityManagerManager;
import org.apache.tapestry5.jpa.EntityTransactionManager;
import org.slf4j.Logger;

@Scope(value="perthread")
public class EntityTransactionManagerImpl
implements EntityTransactionManager {
    private final Logger logger;
    private final EntityManagerManager entityManagerManager;
    private final Map<String, PersistenceContextSpecificEntityTransactionManager> transactionManagerMap;

    public EntityTransactionManagerImpl(Logger logger, EntityManagerManager entityManagerManager) {
        this.logger = logger;
        this.entityManagerManager = entityManagerManager;
        this.transactionManagerMap = new HashMap<String, PersistenceContextSpecificEntityTransactionManager>(entityManagerManager.getEntityManagers().size());
    }

    private EntityManager getEntityManager(String unitName) {
        if (unitName != null) {
            return this.entityManagerManager.getEntityManager(unitName);
        }
        Map<String, EntityManager> entityManagers = this.entityManagerManager.getEntityManagers();
        if (entityManagers.size() == 1) {
            return entityManagers.values().iterator().next();
        }
        throw new RuntimeException("Unable to locate a single EntityManager. You must provide the persistence unit name as defined in the persistence.xml using the @PersistenceContext annotation.");
    }

    @Override
    public void runInTransaction(String unitName, Runnable runnable) {
        this.getPersistenceContextSpecificEntityTransactionManager(unitName).invokeInTransaction(new EntityTransactionManager.VoidInvokable(runnable));
    }

    @Override
    public <T> T invokeInTransaction(String unitName, Invokable<T> invokable) {
        return this.getPersistenceContextSpecificEntityTransactionManager(unitName).invokeInTransaction(invokable);
    }

    private PersistenceContextSpecificEntityTransactionManager getPersistenceContextSpecificEntityTransactionManager(String unitName) {
        if (!this.transactionManagerMap.containsKey(unitName)) {
            PersistenceContextSpecificEntityTransactionManager transactionManager = new PersistenceContextSpecificEntityTransactionManager(this.logger, this.getEntityManager(unitName));
            this.transactionManagerMap.put(unitName, transactionManager);
            return transactionManager;
        }
        return this.transactionManagerMap.get(unitName);
    }

    @Override
    public void invokeBeforeCommit(String unitName, Invokable<Boolean> invokable) {
        this.getPersistenceContextSpecificEntityTransactionManager(unitName).addBeforeCommitInvokable(invokable);
    }

    @Override
    public void invokeAfterCommit(String unitName, Invokable<Boolean> invokable) {
        this.getPersistenceContextSpecificEntityTransactionManager(unitName).addAfterCommitInvokable(invokable);
    }
}

