/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.commons.ObjectCreator;
import org.apache.tapestry5.commons.ObjectLocator;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.ServiceBuilderResources;
import org.apache.tapestry5.ioc.ServiceResources;
import org.apache.tapestry5.ioc.internal.ConfigurationType;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.apache.tapestry5.ioc.internal.util.DelegatingInjectionResources;
import org.apache.tapestry5.ioc.internal.util.InjectionResources;
import org.apache.tapestry5.ioc.internal.util.MapInjectionResources;
import org.slf4j.Logger;

public abstract class AbstractServiceCreator
implements ObjectCreator {
    protected final String serviceId;
    private final Map<Class, Object> injectionResources = CollectionFactory.newMap();
    protected final ServiceBuilderResources resources;
    protected final Logger logger;
    private static final Map<Class, ConfigurationType> PARAMETER_TYPE_TO_CONFIGURATION_TYPE = CollectionFactory.newMap();
    protected final String creatorDescription;

    public AbstractServiceCreator(ServiceBuilderResources resources, String creatorDescription) {
        this.serviceId = resources.getServiceId();
        this.resources = resources;
        this.creatorDescription = creatorDescription;
        this.logger = resources.getLogger();
        this.injectionResources.put(ObjectLocator.class, resources);
        this.injectionResources.put(ServiceResources.class, resources);
        this.injectionResources.put(Logger.class, this.logger);
        this.injectionResources.put(Class.class, resources.getServiceInterface());
        this.injectionResources.put(OperationTracker.class, resources.getTracker());
    }

    protected final InjectionResources createInjectionResources() {
        MapInjectionResources core = new MapInjectionResources(this.injectionResources);
        InjectionResources configurations = new InjectionResources(){
            private boolean seenOne;

            @Override
            public <T> T findResource(Class<T> resourceType, Type genericType) {
                ConfigurationType thisType = (ConfigurationType)((Object)PARAMETER_TYPE_TO_CONFIGURATION_TYPE.get(resourceType));
                if (thisType == null) {
                    return null;
                }
                if (this.seenOne) {
                    throw new RuntimeException(IOCMessages.tooManyConfigurationParameters(AbstractServiceCreator.this.creatorDescription));
                }
                this.seenOne = true;
                switch (thisType) {
                    case UNORDERED: {
                        return resourceType.cast(AbstractServiceCreator.this.getUnorderedConfiguration(genericType));
                    }
                    case ORDERED: {
                        return resourceType.cast(AbstractServiceCreator.this.getOrderedConfiguration(genericType));
                    }
                    case MAPPED: {
                        return resourceType.cast(AbstractServiceCreator.this.getMappedConfiguration(genericType));
                    }
                }
                return null;
            }
        };
        return new DelegatingInjectionResources(core, configurations);
    }

    private List getOrderedConfiguration(Type genericType) {
        Class valueType = AbstractServiceCreator.findParameterizedTypeFromGenericType(genericType);
        return this.resources.getOrderedConfiguration(valueType);
    }

    private Collection getUnorderedConfiguration(Type genericType) {
        Class valueType = AbstractServiceCreator.findParameterizedTypeFromGenericType(genericType);
        return this.resources.getUnorderedConfiguration(valueType);
    }

    private Map getMappedConfiguration(Type genericType) {
        Class keyType = AbstractServiceCreator.findParameterizedTypeFromGenericType(genericType, 0);
        Class valueType = AbstractServiceCreator.findParameterizedTypeFromGenericType(genericType, 1);
        if (keyType == null || valueType == null) {
            throw new IllegalArgumentException(IOCMessages.genericTypeNotSupported(genericType));
        }
        return this.resources.getMappedConfiguration(keyType, valueType);
    }

    static Class findParameterizedTypeFromGenericType(Type type) {
        Class result = AbstractServiceCreator.findParameterizedTypeFromGenericType(type, 0);
        if (result == null) {
            throw new IllegalArgumentException(IOCMessages.genericTypeNotSupported(type));
        }
        return result;
    }

    private static Class findParameterizedTypeFromGenericType(Type type, int typeIndex) {
        if (type instanceof Class) {
            return Object.class;
        }
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType pt = (ParameterizedType)type;
        Type[] types = pt.getActualTypeArguments();
        Type actualType = types[typeIndex];
        return actualType instanceof Class ? (Class)actualType : null;
    }

    static {
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(Collection.class, ConfigurationType.UNORDERED);
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(List.class, ConfigurationType.ORDERED);
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(Map.class, ConfigurationType.MAPPED);
    }
}

