/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary;

import java.util.HashMap;
import java.util.Map;

public enum DataType {
    INT(1),
    LONG(2),
    STRING(3),
    DATE(4),
    TIMESTAMP(5),
    CLASS(6),
    DOUBLE(7),
    FLOAT(8),
    LIST(9),
    MAP(10),
    SET(11),
    UUID(12),
    EDGE(13),
    PATH(14),
    PROPERTY(15),
    GRAPH(16),
    VERTEX(17),
    VERTEXPROPERTY(18),
    BARRIER(19),
    BINDING(20),
    BYTECODE(21),
    CARDINALITY(22),
    COLUMN(23),
    DIRECTION(24),
    OPERATOR(25),
    ORDER(26),
    PICK(27),
    POP(28),
    LAMBDA(29),
    P(30),
    SCOPE(31),
    T(32),
    TRAVERSER(33),
    BIGDECIMAL(34),
    BIGINTEGER(35),
    BYTE(36),
    BYTEBUFFER(37),
    SHORT(38),
    BOOLEAN(39),
    TEXTP(40),
    TRAVERSALSTRATEGY(41),
    BULKSET(42),
    TREE(43),
    METRICS(44),
    TRAVERSALMETRICS(45),
    MERGE(46),
    DT(47),
    CHAR(128),
    DURATION(129),
    INETADDRESS(130),
    INSTANT(131),
    LOCALDATE(132),
    LOCALDATETIME(133),
    LOCALTIME(134),
    MONTHDAY(135),
    OFFSETDATETIME(136),
    OFFSETTIME(137),
    PERIOD(138),
    YEAR(139),
    YEARMONTH(140),
    ZONEDATETIME(141),
    ZONEOFFSET(142),
    CUSTOM(0),
    UNSPECIFIED_NULL(254);

    private final int code;
    private static final Map<Integer, DataType> typeByCode;
    private static final Map<DataType, byte[]> bufferByDataType;

    private DataType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public byte getCodeByte() {
        return (byte)this.code;
    }

    byte[] getDataTypeBuffer() {
        return bufferByDataType.get((Object)this);
    }

    public static DataType get(int code) {
        return typeByCode.get(code);
    }

    static {
        typeByCode = new HashMap<Integer, DataType>();
        bufferByDataType = new HashMap<DataType, byte[]>();
        for (DataType t : DataType.values()) {
            typeByCode.put(t.code, t);
            bufferByDataType.put(t, new byte[]{(byte)t.code});
        }
    }
}

