/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Connection;
import org.apache.tinkerpop.gremlin.driver.ResultQueue;
import org.apache.tinkerpop.gremlin.driver.exception.ConnectionException;
import org.apache.tinkerpop.gremlin.driver.handler.GremlinResponseHandler;
import org.apache.tinkerpop.gremlin.driver.handler.HttpContentDecompressionHandler;
import org.apache.tinkerpop.gremlin.driver.handler.HttpGremlinRequestEncoder;
import org.apache.tinkerpop.gremlin.driver.handler.HttpGremlinResponseDecoder;
import org.apache.tinkerpop.gremlin.driver.handler.IdleConnectionHandler;
import org.apache.tinkerpop.gremlin.driver.handler.InactiveChannelHandler;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;

public interface Channelizer
extends ChannelHandler {
    public void init(Connection var1);

    public void close(Channel var1);

    default public void connected() {
    }

    default public String getScheme(boolean sslEnabled) {
        return sslEnabled ? "https" : "http";
    }

    public static final class HttpChannelizer
    extends AbstractChannelizer {
        public static final ResponseMessage LAST_CONTENT_READ_RESPONSE = ResponseMessage.build().code(HttpResponseStatus.NO_CONTENT).result(Collections.emptyList()).create();
        private HttpGremlinRequestEncoder gremlinRequestEncoder;
        private HttpGremlinResponseDecoder gremlinResponseDecoder;
        private HttpContentDecompressionHandler httpCompressionDecoder;
        private IdleStateHandler idleStateHandler;
        private IdleConnectionHandler idleConnectionHandler;

        @Override
        public void init(Connection connection) {
            super.init(connection);
            this.httpCompressionDecoder = new HttpContentDecompressionHandler();
            this.gremlinRequestEncoder = new HttpGremlinRequestEncoder(this.cluster.getSerializer(), this.cluster.getRequestInterceptors(), this.cluster.isUserAgentOnConnectEnabled(), this.cluster.isBulkResultsEnabled(), connection.getUri());
            this.gremlinResponseDecoder = new HttpGremlinResponseDecoder(this.cluster.getSerializer());
            if (this.cluster.getIdleConnectionTimeout() > 0L) {
                int idleConnectionTimeout = (int)(this.cluster.getIdleConnectionTimeout() / 1000L);
                this.idleStateHandler = new IdleStateHandler(idleConnectionTimeout, idleConnectionTimeout, 0);
                this.idleConnectionHandler = new IdleConnectionHandler();
            }
        }

        @Override
        public void connected() {
            super.connected();
        }

        @Override
        public boolean supportsSsl() {
            String scheme = this.connection.getUri().getScheme();
            return "https".equalsIgnoreCase(scheme);
        }

        @Override
        public void configure(ChannelPipeline pipeline) {
            String scheme = this.connection.getUri().getScheme();
            if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
                throw new IllegalStateException("Unsupported scheme (only http: or https: supported): " + scheme);
            }
            if (!this.supportsSsl() && "https".equalsIgnoreCase(scheme)) {
                throw new IllegalStateException("To use https scheme ensure that enableSsl is set to true in configuration");
            }
            if (this.cluster.getIdleConnectionTimeout() > 0L) {
                pipeline.addLast("idle-state-handler", (ChannelHandler)this.idleStateHandler);
                pipeline.addLast("idle-connection-handler", (ChannelHandler)this.idleConnectionHandler);
            }
            HttpClientCodec handler = new HttpClientCodec(4096, 8192, 0x100000, false, true, 128, false, false, false);
            pipeline.addLast("http-codec", (ChannelHandler)handler);
            pipeline.addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(this.cluster.getMaxResponseContentLength() > 0L ? (int)this.cluster.getMaxResponseContentLength() : Integer.MAX_VALUE));
            pipeline.addLast("gremlin-encoder", (ChannelHandler)this.gremlinRequestEncoder);
            pipeline.addLast("http-decompression-handler", (ChannelHandler)this.httpCompressionDecoder);
            pipeline.addLast("gremlin-decoder", (ChannelHandler)this.gremlinResponseDecoder);
        }
    }

    public static abstract class AbstractChannelizer
    extends ChannelInitializer<SocketChannel>
    implements Channelizer {
        protected Connection connection;
        protected Cluster cluster;
        protected SslHandler sslHandler;
        private AtomicReference<ResultQueue> pending;
        protected static final String PIPELINE_GREMLIN_HANDLER = "gremlin-handler";
        protected static final String PIPELINE_SSL_HANDLER = "gremlin-ssl-handler";
        protected static final String PIPELINE_IDLE_STATE_HANDLER = "idle-state-handler";
        protected static final String PIPELINE_IDLE_CONNECTION_HANDLER = "idle-connection-handler";
        protected static final String PIPELINE_HTTP_CODEC = "http-codec";
        protected static final String PIPELINE_HTTP_AGGREGATOR = "http-aggregator";
        protected static final String PIPELINE_HTTP_ENCODER = "gremlin-encoder";
        protected static final String PIPELINE_HTTP_DECODER = "gremlin-decoder";
        protected static final String PIPELINE_HTTP_DECOMPRESSION_HANDLER = "http-decompression-handler";
        private static final String HANDSHAKE_ERROR = "Could not complete connection setup to the server. Ensure that SSL is correctly configured at both the client and the server. Ensure that client http handshake protocol matches the server. Ensure that the server is still reachable.";
        private static final InactiveChannelHandler inactiveChannelHandler = new InactiveChannelHandler();

        public boolean supportsSsl() {
            return this.cluster.connectionPoolSettings().enableSsl;
        }

        public abstract void configure(ChannelPipeline var1);

        public void finalize(ChannelPipeline pipeline) {
        }

        @Override
        public void close(Channel channel) {
        }

        @Override
        public void init(Connection connection) {
            this.connection = connection;
            this.cluster = connection.getCluster();
            this.pending = connection.getPending();
        }

        protected void initChannel(SocketChannel socketChannel) {
            Optional<Object> sslCtx;
            ChannelPipeline pipeline = socketChannel.pipeline();
            if (this.supportsSsl()) {
                try {
                    sslCtx = Optional.of(this.cluster.createSSLContext());
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                sslCtx = Optional.empty();
            }
            if (sslCtx.isPresent()) {
                this.sslHandler = ((SslContext)sslCtx.get()).newHandler(socketChannel.alloc(), this.connection.getUri().getHost(), this.connection.getUri().getPort());
                this.sslHandler.setHandshakeTimeoutMillis(0L);
                pipeline.addLast(PIPELINE_SSL_HANDLER, (ChannelHandler)this.sslHandler);
            } else {
                pipeline.addLast(PIPELINE_SSL_HANDLER, (ChannelHandler)inactiveChannelHandler);
            }
            this.configure(pipeline);
            pipeline.addLast(PIPELINE_GREMLIN_HANDLER, (ChannelHandler)new GremlinResponseHandler(this.pending));
        }

        @Override
        public void connected() {
            if (this.supportsSsl()) {
                try {
                    this.sslHandler.handshakeFuture().sync();
                }
                catch (Exception ex) {
                    throw new ConnectionException(this.connection.getUri(), HANDSHAKE_ERROR, ex);
                }
            }
        }
    }
}

